package ru.yandex.direct.core.entity.adgeneration;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import static org.junit.Assert.assertEquals;

@RunWith(Parameterized.class)
public class GenerationUtilsTest {

    @Parameterized.Parameter
    public String input;

    @Parameterized.Parameter(1)
    public String output;

    @Parameterized.Parameters(name = "input = {0}")
    public static Collection<Object[]> params() {
        return Arrays.asList(new Object[][]{
                // Регистр, искуственные примеры
                {"", ""},
                {"ГУМ", "Гум"},
                {"ЯНДЕКС", "Яндекс"},
                {"YANDEX", "Yandex"},
                {"YANDEXTAXI", "Yandextaxi"},
                {"ЯНДЕКСТАКСИ", "Яндекстакси"},
                {"НИИ РАН", "Нии Ран"},
                {"Вот НИИ РАН", "Вот НИИ РАН"},
                {"ЯНДЕКС TAXI", "Яндекс Taxi"},
                {"YANDEX ТАКСИ", "Yandex Такси"},
                {"вниманиЕ. YANDEX TAXI", "Внимание. Yandex Taxi"},
                {"АХ, ЗА ЧТО МНЕ ВСЕ ЭТО. БЫТЬ ИЛИ НЕ БЫТЬ В САНКТ-ПЕТЕРБУРГЕ. В ЧЕМ-ТО МЫ С ТОБОЙ ПОХОЖИ.",
                        "Ах, за Что Мне Все Это. Быть или не Быть в Санкт-Петербурге. В Чем-то мы с Тобой Похожи."},

                // Регистр, реальные примеры
                {"Страхование от СПАО «Ингосстрах» – крупнейшей страховой...",
                        "Страхование от СПАО «Ингосстрах» – крупнейшей страховой..."},
                {"ГУМ-Каток", "ГУМ-Каток"},
                {"ГУМ – официальный интернет-магазин главного универмага страны Одежда, обувь, аксессуары, " +
                        "косметика и парфюмерия более 100 ведущих мировых брендов ГУМ - обслуживание VIP " +
                        "уровня Доставка по Москве и всей России Примерка перед покупкой!",
                        "ГУМ – официальный интернет-магазин главного универмага страны Одежда, обувь, аксессуары, " +
                                "косметика и парфюмерия более 100 ведущих мировых брендов ГУМ - обслуживание VIP " +
                                "уровня Доставка по Москве и всей России Примерка перед покупкой!"},
                {"МФТИ — Московский физико-технический институт", "МФТИ — Московский физико-технический институт"},
                {"Все факультеты НИУ ВШЭ. Выберите Факультет Национального исследовательского университета " +
                        "Высшая школа экономики...",
                        "Все факультеты НИУ ВШЭ. Выберите Факультет Национального исследовательского университета " +
                                "Высшая школа экономики..."},
                {"ПАЯЛЬНАЯ СТАНЦИЯ ELEMENT-702", "Паяльная Станция Element-702"},
                {"Грузовые шины AEOLUS", "Грузовые шины AEOLUS"},
                {"Стабилизаторы напряжения ЭНЕРГОТЕХ", "Стабилизаторы напряжения Энерготех"},
                {"ГРУЗЧИКИ, РАБОЧИЕ/КОМПЛЕКТОВЩИЦЫ", "Грузчики, Рабочие/Комплектовщицы"},
                {"THE METERS – Все квартиры в 1 месте!", "The Meters – Все квартиры в 1 месте!"},
                {"Лыжные ботинки Fischer RC5 Classic", "Лыжные ботинки Fischer RC5 Classic"},

                // Замена недопустимых символов
                {"МГУ имени М.В.Ломоносова | ВКонтакте", "МГУ имени М.В.Ломоносова ВКонтакте"},
                {"|Мой   Магазин|", "Мой Магазин"},
                {"Мой       Магазин", "Мой Магазин"},
                {"М|Г|У", "М г у"},

                /** В текущем виде алгоритм не распозрает аббревеатуры из примеро ниже.
                {"Страховка на машину в Москве, Санкт-Петербурге и других городах от лидера автострахования " +
                        "\uD83D\uDE98 КАСКО, ОСАГО, е-ОСАГО - удобный расчет на калькуляторах. Возможность " +
                        "сохранить свой расчет. Доставка и получение на e-mail...",
                        "Страховка на машину в Москве, Санкт-Петербурге и других городах от лидера автострахования " +
                                "\uD83D\uDE98 КАСКО, ОСАГО, е-ОСАГО - удобный расчет на калькуляторах. Возможность " +
                                "сохранить свой расчет. Доставка и получение на e-mail..."},
                {"Узел прохода УП1, УП2, УП3, УП4, УП5", "Узел прохода УП1, УП2, УП3, УП4, УП5"},
                 */
        });
    }

    @Test
    public void correctCapsLock() {
        assertEquals(output, GenerationUtils.updateAdText(input));
    }
}
