package ru.yandex.direct.core.entity.strategy.type.withmetrikacounters

import org.junit.Before
import org.junit.Test
import org.junit.runner.RunWith
import org.springframework.test.context.junit4.SpringRunner
import ru.yandex.direct.core.entity.strategy.container.StrategyOperationOptions
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.service.update.StrategyUpdateOperationTestBase
import ru.yandex.direct.core.testing.configuration.CoreTest
import ru.yandex.direct.core.testing.data.strategy.TestAutobudgetMaxReachCustomPeriodStrategies
import ru.yandex.direct.core.testing.info.ClientInfo
import ru.yandex.direct.core.testing.info.campaign.SmartCampaignInfo
import ru.yandex.direct.model.ModelChanges

@CoreTest
@RunWith(SpringRunner::class)
class StrategyWithMetrikaCountersUpdatePositiveTest : StrategyUpdateOperationTestBase() {
    private lateinit var clientInfo: ClientInfo

    private lateinit var smartCampaignInfo: SmartCampaignInfo

    private var id: Long = 0

    @Before
    fun setUp() {
        clientInfo = steps.clientSteps().createDefaultClient()
        walletService.createWalletForNewClient(clientInfo.clientId, clientInfo.uid)
        smartCampaignInfo = steps.smartCampaignSteps().createDefaultCampaign(clientInfo)

        val strategy = TestAutobudgetMaxReachCustomPeriodStrategies.clientAutobudgetMaxReachCustomPeriodStrategy()
            .withMetrikaCounters(listOf())

        val operation = createAddOperation(listOf(strategy), StrategyOperationOptions())
        val result = operation.prepareAndApply()
        id = result[0].result
    }

    override fun getShard() = clientInfo.shard

    override fun getClientId() = clientInfo.clientId!!

    override fun getOperatorUid(): Long = clientInfo.uid

    @Test
    fun `update strategy with empty metrika counters`() {
        val mc = ModelChanges.build(
            id, StrategyWithMetrikaCounters::class.java,
            StrategyWithMetrikaCounters.METRIKA_COUNTERS, listOf()
        )

        prepareAndApplyValid(listOf(mc))
    }

    @Test
    fun `update strategy with one metrika counter`() {
        val mc = ModelChanges.build(
            id, StrategyWithMetrikaCounters::class.java,
            StrategyWithMetrikaCounters.METRIKA_COUNTERS, listOf(123)
        )

        prepareAndApplyValid(listOf(mc))
    }

    //    @Test
    fun `update strategy with one non-system metrika counter and one system for perf campaign`() {
        val mc = ModelChanges.build(
            id, StrategyWithMetrikaCounters::class.java,
            StrategyWithMetrikaCounters.METRIKA_COUNTERS, listOf(123)
        )

        prepareAndApplyInvalid(listOf(mc))
    }

    //    @Test
    fun `update strategy with available non-system metrika counters and system`() {
        val mc = ModelChanges.build(
            id, StrategyWithMetrikaCounters::class.java,
            StrategyWithMetrikaCounters.METRIKA_COUNTERS, listOf(123)
        )

        prepareAndApplyInvalid(listOf(mc))
    }
}
