package ru.yandex.direct.core.entity.timetarget.service;

import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import static java.util.Arrays.asList;
import static ru.yandex.direct.utils.DateTimeUtils.MOSCOW_TIMEZONE;

/**
 * Тест для того, чтобы убедиться, что ZoneId.of(String) понимает все, указанные в БД значения.
 */
@Ignore
@RunWith(Parameterized.class)
public class DbGeoTimezonesTest {

    @Parameterized.Parameter
    public String dbTimezone;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        // Timezone'ы выгружены с помощью "select distinct timezone from geo_timezones"
        List<String> dbTimezones = asList(
                "America/Denver",
                "America/Juneau",
                "America/Kentucky/Monticello",
                "America/Los_Angeles",
                "America/Louisville",
                "America/North_Dakota/Center",
                "Pacific/Honolulu",
                "America/Argentina/Buenos_Aires",
                "America/Maceio",
                "America/Manaus",
                "America/Noronha",
                "America/Rio_Branco",
                "America/Sao_Paulo",
                "America/Halifax",
                "America/Miquelon",
                "America/Swift_Current",
                "America/Toronto",
                "America/Vancouver",
                "America/Winnipeg",
                "America/Yellowknife",
                "Europe/Berlin",
                "Europe/London",
                "Europe/Vienna",
                "Europe/Brussels",
                "Europe/Sofia",
                "Europe/Budapest",
                "Europe/Vilnius",
                "Europe/Amsterdam",
                "Europe/Oslo",
                MOSCOW_TIMEZONE,
                "Europe/Warsaw",
                "Europe/Bratislava",
                "Europe/Ljubljana",
                "Europe/Helsinki",
                "Europe/Paris",
                "Europe/Prague",
                "Europe/Zurich",
                "Europe/Stockholm",
                "Asia/Shanghai",
                "Asia/Urumqi",
                "Asia/Seoul",
                "Asia/Tokyo",
                "Pacific/Auckland",
                "Europe/Minsk",
                "Asia/Almaty",
                "Asia/Aqtobe",
                "Asia/Baku",
                "Asia/Yerevan",
                "Asia/Tbilisi",
                "Asia/Ashgabat",
                "Asia/Tashkent",
                "Europe/Tallinn",
                "Europe/Belgrade",
                "Asia/Jerusalem",
                "Europe/Kiev",
                "Atlantic/Faeroe",
                "Europe/Copenhagen",
                "Atlantic/Canary",
                "Europe/Madrid",
                "Europe/Rome",
                "Europe/Riga",
                "Asia/Bishkek",
                "Asia/Dushanbe",
                "Asia/Dubai",
                "Asia/Jakarta",
                "Australia/Brisbane",
                "Australia/Perth",
                "Australia/Sydney",
                "Asia/Barnaul",
                "Asia/Chita",
                "Asia/Irkutsk",
                "Asia/Kamchatka",
                "Asia/Krasnoyarsk",
                "Asia/Novokuznetsk",
                "Asia/Omsk",
                "Asia/Srednekolymsk",
                "Asia/Tomsk",
                "Asia/Vladivostok",
                "Asia/Yakutsk",
                "Asia/Yekaterinburg",
                "Europe/Astrakhan",
                "Europe/Kaliningrad",
                "Europe/Samara",
                "Europe/Ulyanovsk",
                "Europe/Athens",
                "Europe/Istanbul",
                "Asia/Bangkok",
                "Africa/Cairo",
                "America/Jamaica",
                "America/La_Paz",
                "America/Havana",
                "Africa/Casablanca",
                "Africa/Johannesburg",
                "Indian/Mauritius",
                "Africa/Tripoli",
                "Africa/Tunis",
                "Pacific/Fiji",
                "Europe/Tirane",
                "Europe/Sarajevo",
                "Europe/Dublin",
                "Atlantic/Reykjavik",
                "Europe/Vaduz",
                "Europe/Skopje",
                "Europe/Malta",
                "Europe/Monaco",
                "Atlantic/Azores",
                "Europe/Lisbon",
                "Europe/Bucharest",
                "Europe/Zagreb",
                "Europe/Andorra",
                "Europe/Gibraltar",
                "Asia/Dhaka",
                "Asia/Vientiane",
                "Asia/Jayapura",
                "Asia/Makassar",
                "Asia/Singapore",
                "Asia/Kuala_Lumpur",
                "Indian/Maldives",
                "Asia/Hovd",
                "Asia/Ulaanbaatar",
                "Asia/Karachi",
                "Asia/Pyongyang",
                "Asia/Manila",
                "Asia/Bahrain",
                "Asia/Amman",
                "Asia/Kuwait",
                "Asia/Beirut",
                "Asia/Riyadh",
                "Asia/Damascus",
                "America/Chihuahua",
                "America/Hermosillo",
                "America/Mexico_City",
                "America/Tijuana",
                "Asia/Brunei",
                "Asia/Baghdad",
                "Asia/Nicosia",
                "Africa/Abidjan",
                "Africa/Douala",
                "Pacific/Port_Moresby",
                "Africa/Lagos",
                "America/Dominica",
                "Pacific/Guam",
                "America/St_Vincent",
                "Africa/Kigali",
                "Africa/Kinshasa",
                "America/Puerto_Rico",
                "Africa/Addis_Ababa",
                "America/Guatemala",
                "America/Guayaquil",
                "America/Lima",
                "Pacific/Galapagos",
                "Africa/El_Aaiun",
                "Europe/San_Marino",
                "Africa/Accra",
                "Africa/Conakry",
                "Africa/Algiers",
                "Indian/Antananarivo",
                "America/Antigua",
                "Pacific/Apia",
                "Pacific/Samoa",
                "America/Santiago",
                "Pacific/Easter",
                "Africa/Porto-Novo",
                "Pacific/Efate",
                "America/Santo_Domingo",
                "Africa/Harare",
                "Africa/Khartoum",
                "Asia/Phnom_Penh",
                "Africa/Asmera",
                "America/Asuncion",
                "Africa/Bamako",
                "Africa/Bangui",
                "Africa/Banjul",
                "America/Barbados",
                "America/St_Kitts",
                "Africa/Malabo",
                "America/Costa_Rica",
                "Africa/Libreville",
                "Africa/Bissau",
                "Africa/Lusaka",
                "Africa/Lome",
                "America/Tegucigalpa",
                "America/Caracas",
                "America/Port_of_Spain",
                "America/Bogota",
                "Africa/Brazzaville",
                "Africa/Sao_Tome",
                "Europe/Luxembourg",
                "Africa/Dar_es_Salaam",
                "Africa/Bujumbura",
                "Africa/Windhoek",
                "Africa/Freetown",
                "Africa/Nairobi",
                "Africa/Mogadishu",
                "Africa/Kampala",
                "America/Managua",
                "Africa/Maputo",
                "Africa/Gaborone",
                "Africa/Mbabane",
                "Africa/Maseru",
                "Africa/Monrovia",
                "America/Montevideo",
                "Indian/Comoro",
                "America/Port-au-Prince",
                "America/Nassau",
                "Atlantic/Cape_Verde",
                "Pacific/Tahiti",
                "Africa/Ndjamena",
                "Africa/Niamey",
                "America/Cayenne",
                "Africa/Nouakchott",
                "Europe/Vatican",
                "America/Grenada",
                "Africa/Dakar",
                "Africa/Djibouti",
                "America/Guyana",
                "America/Anguilla",
                "America/Aruba",
                "America/Curacao",
                "America/Belize",
                "Atlantic/Bermuda",
                "Asia/Thimphu",
                "Asia/Aden",
                "America/St_Thomas",
                "America/Tortola",
                "Asia/Dili",
                "America/Godthab",
                "America/Cayman",
                "Pacific/Tarawa",
                "Pacific/Rarotonga",
                "Pacific/Majuro",
                "Pacific/Yap",
                "Pacific/Nauru",
                "Pacific/Noumea",
                "Asia/Muscat",
                "Pacific/Palau",
                "America/Grand_Turk",
                "Pacific/Tongatapu",
                "Pacific/Funafuti",
                "America/Montserrat",
                "Pacific/Norfolk",
                "Pacific/Niue",
                "Asia/Gaza");
        return dbTimezones.stream().map(tz -> new Object[]{tz}).collect(Collectors.toList());
    }

    @Test
    public void testAllTimezonesAreValid() {
        ZoneId zoneId = ZoneId.of(dbTimezone);
        System.out.println(zoneId);
    }
}
