JAVA_LIBRARY()

WITH_KOTLIN()
INCLUDE(${ARCADIA_ROOT}/direct/libs/common.inc)

OWNER(g:direct)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)
WITH_KOTLIN()

EXCLUDE(
    # исключаем junit4, приезжающий транзитивно из libs/curator и libs/balance-client
    contrib/java/junit/junit
)

PEERDIR(
    contrib/java/com/google/guava/guava

    direct/common

    direct/libs-internal/core-model
    direct/libs-internal/dbqueue
    direct/libs-internal/hrefs-parameterizer
    direct/libs-internal/market-client
    direct/libs-internal/mysql-grut-mapper
    direct/libs-internal/integrations
    direct/libs-internal/tvm
    direct/libs-internal/yt-components
    direct/libs-internal/autobudget-restart

    direct/libs/advq-client
    direct/libs/avatars-client
    direct/libs/balance-client
    direct/libs/banner-categories-multik-client
    direct/libs/blackbox-client
    direct/libs/bs-auction-client
    direct/libs/bs-history
    direct/libs/bvm-client
    direct/libs/canvas-client
    direct/libs/clemmer
    direct/libs/crypta-client
    direct/libs/dbschema
    direct/libs/direct-intapi-client
    direct/libs/dss-client
    direct/libs/geobase-helper
    direct/libs/geosearch-client
    direct/libs/geosuggest-client
    direct/libs/i18n
    direct/libs/inventori-client
    direct/libs/jooqmapper
    direct/libs/keyword-utils
    direct/libs/keyword-utils
    direct/libs/landlord-client
    direct/libs/mail-sender
    direct/libs/pdfgen
    direct/libs/pokazometer-client
    direct/libs/queryrec
    direct/libs/staff-client
    direct/libs/timetarget
    direct/libs/turbo-landings-client
    direct/libs/turboapps-client
    direct/libs/turbopages-client
    direct/libs/uaas
    direct/libs/ugcdb-client
    direct/libs/validation
    direct/libs/zora-fetcher
    direct/libs/telephony-client
    direct/libs/multitype
    direct/libs/result
    direct/libs/operation
    direct/libs/xiva-client
    direct/libs/gemini-client

    kernel/ugc/proto
    grut/java/client
    grut/java/yp_discovery

    library/java/monlib/metrics

    contrib/java/com/amazonaws/aws-java-sdk-s3

    iceberg/inside-passport-internal-api

    tracker/tracker-java-client/tracker-client/src/main

    # java expression language api and implementation
    contrib/java/javax/el/javax.el-api
    contrib/java/org/glassfish/web/javax.el

    # validation (needs expression language)
    contrib/java/javax/validation/validation-api
    contrib/java/org/hibernate/hibernate-validator

    contrib/java/commons-validator/commons-validator

    contrib/java/org/apache/tika/tika-core/1.20

    # Spring Security
    contrib/java/org/springframework/security/spring-security-core
    contrib/java/org/springframework/security/spring-security-config

    # Spring retry
    contrib/java/org/springframework/retry/spring-retry

    contrib/java/org/apache/commons/commons-collections4

    contrib/java/org/jsoup/jsoup

    contrib/java/it/unimi/dsi/fastutil

    contrib/java/com/googlecode/libphonenumber/libphonenumber

    yt/java/yson

    contrib/java/com/github/tamtam180/cityhash

    contrib/java/org/glassfish/jaxb/jaxb-runtime
)

END()

RECURSE_FOR_TESTS(
    ut
    ut-grut
)
