# Хранение и скачивание файлов

## Куда сохранить файл

### Аватарница

Для хранения изображений в Директе используется [Аватарница](https://wiki.yandex-team.ru/mds/avatars/). Для неё в Java
есть [клиент](https://a.yandex-team.ru/arc_vcs/direct/libs/avatars-client/src/main/java/ru/yandex/direct/avatars/client/AvatarsClient.java),
позволяющий загрузить изображение или удалить изображение и получить ссылку на чтение. В Директе используется по прямому
назначению — хранить и отдавать разного рода изображения. Кроме хранения изображений, Аватарница умеет генерировать для
них разные размеры, смотреть на них компьютерным зрением (для модерации) и [прочее](https://wiki.yandex-team.ru/mds/avatars/#operaciisizobrazhenijami).


В Директе используется несколько namespace'ов Аватарницы для разных целей:

- `direct-avatars`
- `direct`
- `direct-picture`


### MDS

[MeDiaStorage](https://wiki.yandex-team.ru/mds/) — хранилище файлов в Яндексе, поверх которого работают и Аватарница,
и MDS S3. В Директе используется для хранения файлов различных типов и целей, например, хранения разного рода отчётов,
загрузки фидов, выгрузки excel-файлов и csv-детализаций.


Документация к MDS рекомендует для обычного хранения файлов использовать MDS S3 API, если не требуется специфичной
функциональности вроде редиректов и symlink. У "чистого" MDS есть свои
[особенности](https://wiki.yandex-team.ru/mds/#kljuchevyeosobennostixranilishhachistyjjmds), которые надо учитывать при
разработке, но есть удобный соответствующий
[сервис](https://a.yandex-team.ru/arc_vcs/direct/core/src/main/java/ru/yandex/direct/core/entity/mdsfile/service/MdsFileService.java).
Без хранения метаданных (как делает сервис) можно обойтись в случае, если надо сформировать файл, положить его куда-то
и сразу отдать на скачивание.


В Директе доступен один общий
[namespace](https://a.yandex-team.ru/arc_vcs/direct/libs-internal/config/src/main/resources/common-production.conf?rev=1231e3794f5ea7926353870d9a894b01c606a79a#L865)
для всех — `direct-files`. Namespace настроен только для доступа из внутренней сети, об отдаче файлов наружу — ниже.


### MDS S3

[MDS S3](https://wiki.yandex-team.ru/mds/s3-api/) — реализация API Amazon S3 поверх MDS. В Директе используется пока
только для агентских offline-отчётов.

Для работы с бакетами S3 можно использовать один из [стандартных клиентов S3](https://wiki.yandex-team.ru/mds/s3-api/s3-clients/).
Бакеты заводятся под задачи (в данный момент кроме технических бакетов вроде direct-backup[s] есть только один —
для offline-отчётов). В коде работа с S3 также осуществляется через стандартный [клиент](https://a.yandex-team.ru/arc_vcs/direct/core/src/main/java/ru/yandex/direct/core/configuration/CoreConfiguration.java?rev=1231e3794f5ea7926353870d9a894b01c606a79a#L495).


## Как отдать файл

### Java

У клиента Аватарницы есть специальный метод, формирующий ссылку на изображение, которую можно отдать наружу.


В некоторых случаях (например, excel-выгрузки про внутреннюю рекламу для маркетологов Яндекса) пользователям отдаётся
прямая ссылка на файл в MDS. Namespace `direct-files` в MDS и бакеты в S3 по умолчанию настраиваются недоступными извне,
поэтому по такой ссылке файл можно будет получить только из внутренней сети.


В общем случае, если надо сделать файл доступным и внешним пользователям, надо использовать механизм с nginx-редиректом.
Такой подход выбран, чтобы обеспечить проверку прав. Порядок получается такой:

- Пользователь через интерфейс Директа делает запрос к web-api
- Ручка в web-api создаёт файл и отправляет его в MDS/S3 или получает готовую ссылку, например, из БД, и формирует
ответ в виде редиректа на `/serve_mds_file` или `/serve_s3_file` (см. методы `setInternalRedirectTo...` в
[HttpUtil](https://a.yandex-team.ru/arc_vcs/direct/common/src/main/java/ru/yandex/direct/common/util/HttpUtil.java))
- Nginx получает соответствующий редирект и проксирует запрос на MDS/S3
- Файл из MDS/S3 возвращается пользователю


### Perl

TODO: описать