[Как настроить мониторинг джобы](../../guide/dev/jobs-monitoring.md) <br/>

# Мониторинг джоб

## Зачем мониторить джобы

Каждая джоба в той или иной степени рассчитывает на окружение, которое может меняться с течением времени, или попросту ломаться. Поэтому, в определенный момент джоба может перестать выполнять свою функцию. Как правило, рано или поздно так и происходит. Очень важно вовремя об этом узнать и принять необходимые меры.

{% note info %}

Все продакшеновые джобы должны мониториться.

{% endnote %}


## Как мониторить джобы

Для мониторинга джоб используется система мониторинга [Juggler](https://docs.yandex-team.ru/juggler/).

Настроить мониторинг джобы можно с помощью аннотации `@JugglerCheck` ([руководство по использованию](../../guide/dev/jobs-monitoring.md)).


## Этапы мониторинга джоб { #stages }

### 1. Этап разработки

На этапе разработки фичи или нового продукта, частью которой является джоба, она мониторится силами команды, которая разрабатывает эту фичу. Этот этап включает в себя всевозможные доработки и исправления, повышение стабильности и настройку мониторинга.

Обычно новый продукт или фича находится на поддержке у её разработчиков в течение двух месяцев после публичного запуска. Для джоб по умолчанию применяется это же правило.

### 2. Централизованный мониторинг в рамках дежурства app-duty { #stages-appduty }

{% note info %}

Этот процесс ещё на стадии разработки, и более детальная информация появится позже.

{% endnote %}

Когда новая фича запущена и джоба стабильно работает в продакшене, она передаётся в дежурство и мониторится централизованно вместе с остальными джобами.

К моменту передачи в централизованный мониторинг джоба должна удовлетворять следующим критериям:
- Выполняет свою функцию: делает то что нужно и не содержит известных проблем, требующих исправления.
- Сможет выполнять свою функцию с течением времени (с накоплением бОльших объемов данных, с притоком новых пользователей и пр.).
- Джоба не зажигает мониторинг тогда, когда не требуется реакция дежурного.
- Зажигает мониторинг тогда, когда требуется реакция дежурного.
- По джобе написана эксплуатационная документация по шаблону и с учётом рекомендаций (см. руководство [Написание эксплуатационной документации по джобам](../../guide/dev/jobs-operation-doc.md)).

Передача джобы в дежурство app-duty сопровождается ревью одного из дежурных. <br/>
На ревью проверяется:
- Стабильность джобы в Juggler (если лампочка краснела, то только по делу).
- Документация (понятная, соответствует шаблону, следует рекомендациям).

Так же в процессе ревью джобе присваивается [приоритет критичности](#priorities).


## Приоритеты критичности { #priorities }

Для облегчения мониторинга большого числа джоб они разделены на три группы по требованиям ко времени исправления поломки. На [дэшборде дежурных](https://solomon.yandex-team.ru/?project=direct&dashboard=direct-group-sre-tv) отображается по одной "лампочке" для каждой группы.

**Группа "PRIORITY_0"**

Наивысшая степень критичности. Такие джобы требуют безотлагательного исправления силами app-duty или под их пристальным наблюдением.

Этот приоритет имеют, как правило, жизненно-важные для всего сервиса джобы: транспорты в БК и Модерацию, расчет агрегированных статусов.

Этот приоритет выдаётся джобам, имеющим жёсткие требования к скорости работы, которые измеряются в секундах, минутах, часах. Отказ джобы должен или приводить к недоступности части функциональности, или быть заметным большому числу пользователей (даже если основные сценарии не заблокированы), или же затягивание её исправления может привести к еще большим проблемам.


**Группа "PRIORITY_1"**

Эти джобы допускают исправления в течение суток. Желательно не силами app-duty, но под их наблюдением.

Они так же могут быть жизненно-важными, но при этом не иметь столь жёстких требований к скорости обработки данных, как PRIORITY_0. Если они не поработают сутки, это не приведет к значительным для пользователей последствиям.


**Группа "PRIORITY_2"**

Эти джобы допускают исправления в течение недели или больше силами zbp или разработчиков джобы.

{% note info "Как выставить джобе приоритет критичности?" %}

Лампочки по уровню критичности собираются на основе тегов `CheckTag.DIRECT_PRIORITY_0`, `CheckTag.DIRECT_PRIORITY_1` и `CheckTag.DIRECT_PRIORITY_2`. Просто установите тег в аннотацию `@JugglerCheck` для продакшенового окружения (см. [Как настроить агрегирующий мониторинг группы джоб](../../guide/dev/jobs-monitoring.md#jobgroup)).

{% endnote %}
