# PCI DSS в Директе

## Теория

`PCI DSS` – стандарт безопасности индустрии платёжных карт.

Одним из множества требований стандарта является контроль процесса разработки программного обеспечения с точки зрения безопасности вносимых изменений в программный код компонент, работающих с данными платёжных карт пользователей.

Контроль безопасности производится на этапе код ревью `PR`-а сертифицированным разработчиком.

В Яндексе разработана система `PCI Express`, облегчающая обеспечение требований стандарта `PCI DSS`.

Документация `PCI Express` доступна по [ссылке](https://docs.yandex-team.ru/arcanum/projects/pci-dss).

## PCI Express в Директе

В Директе применяется `PCI Express` для контроля соответствия кода стандарту `PCI DSS`.

Компоненты для которых требуется ревью в рамках `PCI DSS` перечислены в следующих конфигурационных [файлах](https://a.yandex-team.ru/search?search=,pci-dss-package).

### Контроль изменений

Контроль изменений в Директе производится в два этапа:

- При формировании ПР робот Искорка назначает сертифицированного ревьюера (как им стать см. "Сертификация разработчиков"), который проводит ревью кода с точки зрения обеспечения безопасности по стандарту PCI DSS. Подробнее в разделе ["Контроль изменений на этапе ПР"](#kontrol-izmenenij-na-etape-pr).

- При сборке релиза происходит дополнительная проверка всех коммитов на предмет того требуется ли для них контроль безопасности по стандарту PCI DSS и прошли ли они его на этапе код-ревью. Подробнее в разделе ["Контроль изменений на этапе релиза"](#kontrol-izmenenij-na-etape-reliza).

### Сертификация разработчиков

Чтобы стать сертифицированным разработчиком необходимо пройти один из следующих курсов:
- [https://moe.yandex-team.ru/courses/my/course/1010](https://moe.yandex-team.ru/courses/my/course/1010)
- [https://moe.yandex-team.ru/courses/my/course/1298](https://moe.yandex-team.ru/courses/my/course/1298) (Общий курс по безопасной разработке в Яндексе)

После окончания курса необходимо запросить одну из следующих ролей в abc Директа:
- ["PCI DSS Ревьюер Front"](https://nda.ya.ru/t/6IaiG2nI5Bzv5u)
- ["PCI DSS Ревьюер Backend"](https://nda.ya.ru/t/0wBlOb-i5Bzv86)

Как запросить роль через abc в картинках:
![alt text](_assets/abc_add_participant.png "ABC добавить участника")
![alt text](_assets/abc_add_participant_name.png "ABC добавить участника по имени")
![alt text](_assets/abc_add_participant_clear_role.png "ABC очистить роль")
![alt text](_assets/abc_add_participant_pci.png "ABC ввести нужную роль")
![alt text](_assets/abc_add_participant_request.png "ABC запросить роль")

Из первых рук про сертификацию разработчиков можно прочитать в [документации PCI Express](https://docs.yandex-team.ru/arcanum/projects/pci-dss#process-sertifikacii-razrabotchikov).

### Контроль изменений на этапе ПР

При формировании ПР запускается проверка `direct: PCI DSS – PR Checks` (для коммитов в директорию `/direct`) или `adv: PCI DSS – PR Checks` (для коммитов в директорию `/adv`):
![alt text](_assets/pci_dss_check_failed.png "PCI DSS запускается проверка")

В этой проверке определяется затрагивают ли изменения, вносимые в данном ПР-е какие-либо файлы, для которых требуется провести код-ревью с точки зрения стандарта `PCI DSS`.

Если оказывается, что необходимо "специальное" код-ревью, проверка падает с ошибкой, и робот Искорка добавляет сертифицированного ревьюера в ПР и оставляет комментарий о необходимости провести код ревью на предмет соответствия стандарту `PCI DSS`.

![alt text](_assets/pci_dss_check_review_task_failed.png "PCI DSS падает кубик")
![alt text](_assets/pci_dss_special_reviewer_assigned.png "PCI DSS назначается ревьюер")

Так же на странице ПР-а появляется бейджик о необходимости "специального" код-ревью:

![alt text](_assets/pci_dss_not_reviewed_badge.png "PCI DSS появляется бейджик")

Назначенный сертифицированный разработчик проводит ревью файлов, попадающих под требования стандарта `PCI DSS`:

![alt text](_assets/pci_dss_review_only_pci_dss.png "PCI DSS код-ревью")

После проведения код-ревью, сертифицированный разработчик ставит `ship`.

{% note alert %}

Обратите внимание что `sticky-ship` в данном случае не годится, так как он не обеспечивает достаточного уровня безопасности кода.

Как следствие вам придётся посмотреть все патчи для данного ПР-а.

{% endnote %}

Бейджик меняет своё значение на `shipped`:
![alt text](_assets/pci_dss_review_shipped.png "PCI DSS ship")

Идём в упавшую проверку `direct: PCI DSS – PR Checks` или `adv: PCI DSS – PR Checks` и перезапускаем упавший кубик:

![alt text](_assets/pci_dss_check_review_restarted.png "PCI DSS ship")

После завершения работы кубика можно смёрджить ПР.

### Контроль изменений на этапе релиза

Проверяющий кубик `verify-pcidss-job` запускается в релизах приложений:
- uac
- api5
- intapi
- jobs
- web

Кубик проходит по всем коммитам на странице `PCI Express` заданного приложения в Аркадии и проверяет статус коммита.
Если коммит требует ревью на предмет соответствия стандарту `PCI DSS` и не прошёл его, кубик падает с ошибкой.

В данном случае необходимо перейти по ссылке из кубика:
![alt text](_assets/pci_dss_arcanum_link.png)

Выбрать на вкладке коммиты не прошедшие код-ревью (стрелочка 1):
![alt text](_assets/pci_add_arcanum_link_not_reviewed.png "PCI DSS фильтр коммитов")

Найти сертифицированного разработчика, готового провести код-ревью этих коммитов (обратите внимание что автор коммита не может провести код-ревью).
Для каждого коммита для которого необходимо провести код-ревью, сертифицированному разработчику неоьходимо перейти на страницу коммита (стрелочка 2):
![alt text](_assets/pci_add_arcanum_link_not_reviewed.png "PCI DSS фильтр коммитов")


Провести код-ревью и если всё ок, поставить `approve`:
![alt text](_assets/pci_dss_arcanum_link_approve.png "PCI DSS ссылка")

Так же можно сделать `revert` коммита или запросить исправления.

{% note alert %}

Необходимо помнить что коммит не прошедший ревью на это исключение из правил.

Такие коммиты тормозят релизы и ломают релизные процессы.

{% endnote %}

После проведения ревью для всех проблемных коммитов, необходимо перезапустить кубик `verify-pcidss-job` в релизе.
