# Зависимости между релизами

{% note tip "TL;DR" %}

Описать новую межрелизную зависимость: [шаблон](https://st.yandex-team.ru/createTicket?template=1177&queue=DIRECT) в
очереди DIRECT.

{% endnote %}

## Общая концепция

Тикеты-зависимости описывают, в каком порядке следует доставлять в продакшен код, закоммиченный с определенными
тикетами.<br>

{% note warning "Важно" %}

Тикет всегда указывается вместе с приложением, в котором должен выехать. "Просто выложен" не бывает; всегда -- "прошел
через релиз такого-то приложения".

{% endnote %}

## Как пользоваться: просмотр { #how-to-read-release-dependencies }

Проверить релиз перед выкладкой на ppcdev:

```
dt-deps-manager -cr DIRECT-RRRRR
```

Список тикетов-зависимостей:

* В [обсерваториуме](https://observatorium.common.yandex.ru/release_deps/list_tickets/).
* [Фильтр](https://st.yandex-team.ru/filters/filter?query=Filter%3A%2031914%20Status%3A!Closed) в Трекере.
* Выборка на [релизном дашборде](https://st.yandex-team.ru/dashboard/1249).

Визуализация:

* [Всех незакрытых зависимостей](https://observatorium.common.yandex.ru/release_deps/ticket_viz?ticket=all).
* [Незакрытых зависимостей в незакрытых релизах](https://observatorium.common.yandex.ru/release_deps/ticket_viz?releases=1)
  .

{% note info "Легенда" %}

* Красным цветом отмечены еще не выложенные тикеты, зеленым -- уже выложенные.
* Стрелка идет от задачи, которая должна быть выложена раньше, к задаче, которая от нее зависит.

{% endnote %}

![no alt](_assets/release-dependencies-ticket-status.png "Визуализация статуса тикетов из релизной зависимости")

## Как пользоваться: описание зависимости { #how-to-create-release-dependencies }

Создать тикет по [шаблону](https://st.yandex-team.ru/createTicket?template=1177&queue=DIRECT) и заполнить своими
задачами.

Формат:

```
**Порядок**:
java-intapi/DIRECT-NNNNN
java-web/DIRECT-LLLLLL
direct/DIRECT-MMMMMMM
dna/DIRECT-EEEEEE
----
**Порядок**:
java-intapi/DIRECT-NNNNN
java-web/DIRECT-LLLLLL
direct/DIRECT-MMMMMMM
dna/DIRECT-EEEEEE
----
```

{% note tip %}

Cписок названий приложений на ppcdev-ах можно посмотреть в ```/etc/yandex-direct/direct-apps.conf.yaml```.

{% endnote %}

{% note warning %}

* В тикете можно несколько раз написать заголовок ```**Порядок**```  и после него перечислять приложения и тикеты,
  которые должны выезжать строго по порядку.
* Внутри одной секции ```**Порядок**``` задачи должны вызжать строго в указанной очередности.
* Между разными секциями ```**Порядок**``` упорядоченности нет.

{% endnote %}

## Примеры

{% cut "Сначала в произвольном порядке надо выложить тикеты 1 и 2 в приложении java-intapi и только потом тикет 3 в приложении direct" %}

Будет две секции по два тикета:

```
**Порядок**
java-intapi/1
direct/3
----
**Порядок**
java-intapi/2
direct/3
```

{% endcut %}

## Ограничения { #release-dependencies-limitations }

Зависимости не сработают в случае, если:

* Указать в зависимости тикет DIRECTMIGR. Примененность миграции не сводится к доставке кода в продакшен.

{% note warning %}

Если миграция блокирует выкладку другого релиза, то после того, как она создалась в виде DIRECTMIGR-тикета, нужно попросить применить ее в [админском чате]({{chat-direct-admin}}), не дожидаясь выкладки перлового релиза. Следить за своевременным применением миграции должен ее автор.

{% endnote %}

* Указать в зависимости тикет другого проекта (БК, Баланс, ADVQ и т.д.) Зависимости полагаются на разметку тикетов,
  которую мы в Директе делаем сами.
* Указать в зависимости тикет, по которому раньше был "ошибочный" коммит в транк. Такой тикет уже считается выложенным.
* Указать в зависимости общий тикет, по которому никогда не будет коммитов. Такой тикет никогда не будет считаться
  выложенным.
