[Архитектура баннеров (концепции)](concept.md) <br/>

# Поиск ассетов и их бизнес-логики

Инструкция может пригодится, если:

- вы хотите узнать, как работает тот или иной ассет;
- вы хотите переиспользовать ассет;
- вы хотите внести изменение в поведение ассета.

Для получение полного представления вам необходимо найти все релевантные интерфейсы и связанную с ними бизнес-логику.

## Поиск базового интерфейса ассета { #find-base-interface }

### Способ 1 — от директории ассета

1. Перейдите в модуль `core` в директорию [core/entity/banner/type](https://a.yandex-team.ru/arc/trunk/arcadia/direct/core/src/main/java/ru/yandex/direct/core/entity/banner/type). В ней находятся корневые директории всех ассетов.

1. Найдите нужную директорию по имени ассета. В ней находится вся бизнес-логика ассета. Так же может быть бизнес-логика некоторых объединений данного ассета с другими (подробнее [о расположении классов](concept.md#asset-directory)).

1. Далее необходимо выделить _базовый интерфейс_, чтобы найти привязанную к нему логику отдельно от логики _агрегирующих интерфейсов_. Найдите в этой же директории класс репозитория `*RepositoryTypeSupport`, первая часть его имени и будет названием базового интерфейса. Например, `BannerWithButtonRepositoryTypeSupport` — репозиторий для интерфейса `BannerWithButton`. (Подробнее [о типах интерфейсов](concept.md#asset-interface)).

1. Найдите классы, в которых используется базовый интерфейс, а среди них найдите его тайп-саппорты. В них находится основная бизнес-логика ассета отдельно от объединений (подробнее [о тайп-саппортах](concept.md#asset-business-logic)).

### Способ 2 - от базового интерфейса ассета

1. Найдите _базовый интерфейс_ ассета в IDE. Базовые интерфейсы имеют имена в формате `"BannerWith" + <название ассета>`. Например, `BannerWithButton`, `BannerWithPixels`. (Подробнее [о типах интерфейсов](concept.md#asset-interface)).

1. Проверьте, что это _базовый интерфейс_. Базовый интерфейс может наследоваться только от `Banner`, `BannerWithAdGroupId` или `BannerWithCampaignId` (не считая интерфейсов `*PropHolder`). В противном случае вы имеете дело с дополнительным или агрегирующим интерфейсом.

1. Найдите классы, в которых используется базовый интерфейс, а среди них найдите его тайп-саппорты. В них находится основная бизнес-логика ассета (подробнее [о тайп-саппортах](concept.md#asset-business-logic)).

## Поиск дополнительной бизнес-логики ассетов и их объединений { #find-additional-logic }

1. Найдите все интерфейсы (не конечные классы), которые наследуются от _базового интерфейса_ ассета. Это _дополнительные_ и _агрегирующие_ интерфейсы. Для поиска базового интерфейса воспользуйтесь [инструкцией](#find-base-interface). (Подробнее [о типах интерфейсов](concept.md#asset-interface)).

1. Для каждого из найденных интерфейсов найдите классы, в которых он используется, а среди них найдите его тайп-саппорты (подробнее [о тайп-саппортах](concept.md#asset-business-logic)). Они являются точкой входа в дополнительную бизнес-логику ассетов.
