[Архитектура баннеров (концепции)](concept.md) <br/>

# Добавление ассета в конечный тип баннера

Каждый конечный тип баннера представляет собой набор интерфейсов, к каждому из которых, в свою очередь, подключена бизнес-логика (подробнее об [интерфейсах](concept.md#asset-interface) и их [бизнес-логике](concept.md#asset-business-logic)). Таким образом, подключение ассета к баннеру сводится к тому, чтобы имплементировать в баннере определенные интерфейсы, а так же при необходимости переопределить часть логики, если именно в целевом типе баннера она отличается.

## Поиск подходящих интерфейсов для подключения к баннеру { #reuse-find-interfaces }

1. Найдите _базовый интерфейс_ ассета и его бизнес-логику с помощью [инструкции](howto-find-asset.md#find-base-interface).
   - Если логика подходит "as is", то достаточно будет в дальнейшем имплементировать этот интерфейс.
   - Если часть его логики не подходит для целевого типа баннера, то потребуется точечное [переопределение](#reuse-override).
1. Найдите _дополнительные_ и _агрегирующие_ интерфейсы и их бизнес-логику с помощью [инструкции](howto-find-asset.md#find-additional-logic).
   - Если логика интерфейса подходит "as is", то достаточно будет в дальнейшем имплементировать этот интерфейс.
   - Если логика интерфейса подходит по сути (это отражено в названии интерфейса), но отличается в деталях,
то используйте этот интерфейс с [переопределением части логики](#reuse-override).
   - Если логика интерфейса не подходит по сути, то не используйте его.

Если для конечного типа баннера от ассета или его объединения с другими требуется принципиально новое поведение, еще не реализованное ни в одном из интерфейсов, тогда вам потребуется добавить новый интерфейс.

{% note tip %}

Для понимания устройства управления статусами модерации, обратитесь к [концепциям](concept.md).

{% endnote %}

В результате вы знаете:

- какой набор существующих интерфейсов потребуется имплементировать в целевом типе баннера;
- в каких из интерфейсов потребуется переопределить часть бизнес-логики;
- потребуется ли вам добавлять новые интерфейсы.

## Добавление интерфейсов в модель баннера { #reuse-implement-interfaces }

1. Найдите конфигурационный файл модели баннера. Он находится в модуле [libs-internal/core-model](https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal) в директории [src/main/model-conf/banner](https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal/core-model/src/main/model-conf). Имя файла имеет формат `"class_" + <краткое имя типа баннера>`.

1. Добавьте необходимые интерфейсы в поле `extends`, а так же поля _базового интерфейса_ в поле `attrs`. Порядок полей в поле `attrs` должен соответствовать порядку интерфейсов в поле `extends`. Поля одного интерфейса отделяются от других пустыми строками. Проследите, чтобы поля не продублировались (такие поля как `id`, `adGroupId`, `campaignId`, всегда находятся наверху). (Подробнее о [формате конфигурационных файлов моделей](https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs/model-generator/CONFIG_FORMAT.md)).

1. Перегенерируйте модели: запустите скрипт `bin/generate_models.sh`.

Результат: целевой тип баннера получил все поля указанных интерфейсов и всю их бизнес-логику (чтения и сохранения, валидации, управления статусами и т.п.).

## Переопределение логики интерфейса для целевого типа баннера { #reuse-override }

### Переопределение валидации конечного состояния { #reuse-override-validation }

Вам пригодится эта инструкция, если логика валидации конечного состояния модели не подходит как есть для целевого типа баннера (подробнее о [валидации](concept.md#validation)).

Посмотрите, как работает валидация в `*ValidatorProvider` для других типов баннеров:

- Если есть блок `if-return` для другого типа баннера, который подходит для целевого типа as is, то просто добавьте целевой тип в условие.
- Если есть валидаторы, которые подходят вам по сути, но не подходят в мелких деталях, то сделайте их более настраиваемыми, добавив входные параметры.
- Если вам требуется новая и достаточно специфическая валидация, то добавьте новый валидатор.

{% note tip "Применяйте SRP" %}

В принятии решения о том, добавлять функциональность в существующий валидатор или создавать новый воспользуйтесь принципом единственной обязанности (SRP). Если с высокой вероятностью новая часть валидации будет меняться отдельно от остальной части, то она заслуживает отдельного класса.

{% endnote %}

Простой эталонный пример: [BannerWithTurboLandingValidatorProvider](https://a.yandex-team.ru/arc/trunk/arcadia/direct/core/src/main/java/ru/yandex/direct/core/entity/banner/type/turbolanding/BannerWithTurboLandingValidatorProvider.java). <br/>
Пример с применением к одному и тому же полю разного набора валидаторов: [BannerWithCreativeValidatorProvider](https://a.yandex-team.ru/arc/trunk/arcadia/direct/core/src/main/java/ru/yandex/direct/core/entity/banner/type/creative/BannerWithCreativeValidatorProvider.java).

### Переопределение управления статусом модерации ассета

Вам пригодится эта инструкция, если у ассета есть собственный статус модерации и в целевом типе баннера логика управления им отличается от стандартной (подробнее о [статусе модерации ассета в операции обновления](concept.md#op-update-asset-moderation)).

В директории ассета найдите интерфейс, который наследуется от [BannerWithChildrenModerationProcessor](https://a.yandex-team.ru/arc/trunk/arcadia/direct/core/src/main/java/ru/yandex/direct/core/entity/banner/service/moderation/BannerWithChildrenModerationProcessor.java). Пример для турболендинга: [BannerWithTurboLandingModerationProcessor](https://a.yandex-team.ru/arc/trunk/arcadia/direct/core/src/main/java/ru/yandex/direct/core/entity/banner/type/turbolanding/moderation/BannerWithTurboLandingModerationProcessor.java).

Имплементируйте найденный интерфейс для целевого типа баннера в той же директории. Сделайте его спринговым синглтоном.

Результат: для целевого типа баннера управлением статусом модерации ассета будет заниматься новый процессор.

### Переопределение других частей бизнес-логики

Выше описывается переопределение логики интерфейсов для тех частей бизнес-логики, где это чаще всего встречается. Однако, есть еще множество мест, которые потенциально могут потребовать переопределения. Но так как это не частая ситуация, каких-то особенных средств или рекомендаций для этих частей не предусмотрено. Используйте конструкции `if-return` (не `if-else`) для переопределения логики в зависимости от типа баннера, группы, кампании или любых других параметров или фич. Лучшим вашим помощником будет здравый смысл.
