[Дежурство по продакшену](app-duty.md) <br/>

# Дежурство "Релизы + ТС"

## Что это такое и зачем { #theory }

Дежурство "Релизы + ТС" - объединяет все дежурства по релизам (intapi, api5, jobs),
разбор проблем в регрессиях (web, perl), поддержку работоспособности тестовой среды Директа,
а также улучшение релизной инфраструктуры.

Основная цель дежурства: получение вердикта "можно катить" / "нельзя катить" для релиза и его последующая выкладка.

График дежурств (дежурство full-time, 5/2): <https://abc.yandex-team.ru/services/direct-app-duty/duty2/30726>

## Перед дежурством { #start }
* Прийти на [встречу](https://calendar.yandex-team.ru/event/66009657) передачи дежурства
* Ознакомиться с [докой](duty_start_shift.md) и проверить доступы.
* Убедиться, что подписан на чат в телеграм [direct-releases](https://t.me/joinchat/CW352WKxudAyYjhi)
* Настроить [GPG-ключи](../guide/initial-setup/gpg-key.md) и пройти по инструкции [для релиз-инженеров](../guide/releases/before-first-java-release.md#keys-and-tokens)
* Создать "дежурный тикет". [Ссылка на создание](https://st.yandex-team.ru/createTicket?queue=DIRECT&boards%5B%5D=16386&description=%D0%94%D0%BE%D0%BA%D1%83%D0%BC%D0%B5%D0%BD%D1%82%D0%B0%D1%86%D0%B8%D1%8F+%D0%BF%D0%BE+%D0%B4%D0%B5%D0%B6%D1%83%D1%80%D1%81%D1%82%D0%B2%D1%83%3A+https%3A%2F%2Fdocs.yandex-team.ru%2Fdirect-dev%2Fprocesses%2Fdirect-releases-duty&priority=2&summary=%D0%94%D0%B5%D0%B6%D1%83%D1%80%D1%81%D1%82%D0%B2%D0%BE+%D0%BF%D0%BE+%D1%80%D0%B5%D0%BB%D0%B8%D0%B7%D0%B0%D0%BC+%D0%94%D0%B8%D1%80%D0%B5%D0%BA%D1%82%D0%B0%3A+login+2022-mm-dd&tags%5B%5D=%D0%94%D0%B5%D0%B6%D1%83%D1%80%D1%81%D1%82%D0%B2%D0%BE_%D0%BF%D0%BE_%D1%80%D0%B5%D0%BB%D0%B8%D0%B7%D0%B0%D0%BC_%D0%94%D0%B8%D1%80%D0%B5%D0%BA%D1%82%D0%B0&type=2)
* В дежурный тикет желательно записывать все задачи/вопросы/проблемы, с которыми разбирался во время дежурства.
* Ознакомиться со списком страничек "Полезные ссылки" (ниже)
* Если дежуришь в первый раз, почитай [Советы дежурному по ТС](./direct-releases-duty-first-time.md).

## Зоны ответственности { #tasks }

Ниже приведен список задач, с которыми сталкивается ТС-ный дежурный. Список отсортирован по приоритету.

### Помощь в починке прода в случае привлечения главным дежурным

Главный дежурный по продакшену может привлекать дежурных для починки багов/критов/алертов на проде. Проблемы на проде являются приоритетными по отношению к остальным.

### Релизы и их выкладка { #tasks-releases }

Дежурный тестирует релизы (intapi, api5, jobs, ess-router) от начала автоматической сборки до отдачи релиза на акцепт.
1. Новые инструкции по тестированию релизов [intapi](../guide/releases/java-intapi.md) и [ess-router](../guide/releases/ess-router.md)
2. Общая (старая) инструкция по тестированию релизов [api5 и jobs](https://wiki.yandex-team.ru/direct/development/howto/releases-java/)

Полезные ссылки:
* Настройка окружения: [{#T}](../guide/releases/before-first-java-release.md)
* [Настройка автотестов для локального запуска](../guide/initial-setup/autotests-local-setup.md)
* [Нестандартные ситуации в релизах](../releases/release-complications.md)
* Частые проблемы при разборе регрессии api5: <https://wiki.yandex-team.ru/direct/api/duty/commonproblems/>
* [{#T}](../guide/troubleshooting/autotests-does-not-working.md) и соседние страницы из раздела
* страничка про [юнит-тесты в релизе](../guide/troubleshooting/unittests-in-release.md)
* [возможные причины падений автотестов](https://wiki.yandex-team.ru/users/xy6er/izvestnye-problemy-v-avtotestax/) - временно на вики, как соберем полную информацию, то добавим в docs
* Дашборд здоровья непрода: <https://solomon.yandex-team.ru/?project=direct&dashboard=direct-np-main>

К кому обратиться в случае непонятных проблем:
* По intapi - к maxlog@ .
* По api5 - к khuzinazat@ или darkkeks@ .
* По jobs - к ppalex@ или pavelkataykin@ .
* По ess-router - к mspirit@ или pe4kin@ .

Выкладка релизов происходит в соответствии с [регламентом](../processes/regulations_deploy_releases_newci.md).
Релизы perl и dna выкладываются по такому же регламенту с принятием дежурного по проду с серверов [ppcback](../jeri/things/ppcback.md) по инструкции:
- для [perl](https://wiki.yandex-team.ru/jeri/app-duty/releases/#vykladkareliza-perl)
- для [dna](../guide/releases/dna.md#vykladka-v-prod)


### Обработка тикетов DIRECTSUP (Ежедневно 1 час) { #directsup }
Тестирование ежедневно приносят до ежедневного синка тикет **"Разбор обращений в саппорт %дата%"**.
К этому тикету прилинкованы тикеты из directsup в которых [по регламенту](support-duty.md) проведена первичная диагностика от команды QA и требуется дальнейший разбор со стороны дежурного.
В этих тикетах необходимо первоочередно:
- определить критичность
- определить массовость проблемы

{% note alert %}

Если проблема массовая или критичная - необходимо донести проблему до "Главного дежурного по продакшену".

{% endnote %}

При дальнейшем разборе тикета
- определить является ли это багом Директа или баг другого сервиса (какого?)
- отписать в комментариях процесс разбора со ссылками на логи/код/сервисы и выгрузками - это позволит при дальнейшем разбирательстве, а также при передаче тикета/проблемы следующему дежурному.

За жизнью в тикете QA приглядывают и реагируют на вопросы и комментарии. Можно, при желании, сделать встречу с дежурным тестировщиком и разбирать тикеты вместе.
Также можно посмотреть доку [zbp дежурства](https://wiki.yandex-team.ru/direct/development/zbp-duty/)

### Поддержка ТС { #tasks-ts }

Под поддержкой ТС понимается обеспечение надежности тестовой среды: реагирование на проблемы, выяснение их причин и обеспечение починки (либо отката проблемных тикетов), ответственность за тестовые среды во время [плановой недоступности ДЦ](../jeri/howto-minus-dc.md).
За чем следует следить:
* Светофор - левый верхний график на [мониторе](https://radar.qart.yandex-team.ru/autotests/trunkApiMonitor.html)
* Графики каждого приложения на [дашборде](https://grafana.yandex-team.ru/d/FE_fiR8Wz/direct-java-apps?orgId=1&from=now-1h&to=now&refresh=1m&var-app=app_java-intapi&var-env=testing&var-project=direct-test&var-host=All)
* Непродовый [дашборд](https://solomon.yandex-team.ru/?project=direct&dashboard=direct-np-main)

Частая причина таймаутов, 500-х ошибок на ТС - избыток кампаний, групп, баннеров у клиентов, используемых для автотестов.
Удалить кампании у клиента можно через веб-интерфейс или по [инструкции](../guide/troubleshooting/maximum-number-of-campaigns.md).

### Разбор регрессий { #tasks-regressions }

Под разбором регрессии понимается выяснение причин падений тестов, которые не выполнились после их перезапуска.
После выяснения причин отнести проблему ответственному с целью починки или починить самому.
Если проблема некритичная (например проблема в самом тесте), то отписать в релизный тикет, что падение релиз не держит,
чтобы ответственный за релиз мог продолжить тестирование.

Дежурный разбирает:
1. Perl-регрессию, куда его призывает робот. Подробнее [тут](../reference/qa/regression-perl.md)
2. Web-регрессию, если она не сошлась. Призывает QA, ответственный за релиз.


### Улучшение релизной инфраструктуры { #tasks-infrastructure }

Например: улучшение инструментов, документации, шумящих тестов. За конкретными задачами можно обратиться к [collapsus@](https://staff.yandex-team.ru/collapsus).
Данными улучшениями стоит заняться если не осталось незакрытых регрессий и проблем с ТС.
* [Борда задач по улучшениям](https://st.yandex-team.ru/agile/board/16386)
* [Новый тикет на улучшение](https://st.yandex-team.ru/createTicket?queue=DIRECT&affectedApps%5B%5D=none&boards%5B%5D=16386&priority=2&type=2)
