# Регламент дежурства

При заступлении на дежурство подразумевается "полная занятость", т.е. задачи по дежурству делаются в первую очередь в максимальном приоритете. Наша цель - надежно работающий сервис, быстрая починка багов, стабильная ТС, плавная и быстрая доставка кода в прод.

Распределением нагрузки между дежурными занимается **main** дежурный(с ролью ["Главный дежурный по продакшену"](./main-duty.md)). Этот же дежурный является "on call" дежурным, но может передать звонки/призывы, при необходимости, на второго дежурного(с ролью "Дежурный по продакшену").
Для более удобного распределения и понимания кто чем занимается необходимо пользоваться [Дашбордом дежурств](https://st.yandex-team.ru/dashboard/67567).

Пункты ниже примерно расположены в порядке важности и срочности реагирования.

## Координация аварий
От дежурных ожидается умение и взятие под контроль нештатных ситуаций, которые требуют скоординированной починки, возможно со смежными сервисами. Подробнее в [доке по координации](./duty-incidents-coordination.md)

## Разбор "звонящих" мониторингов с эскалацией
Алёрты в чат [Direct.Monitoring.Calls](../reference/chats.md#Direct-Monitoring-Calls). Эскалируются в звонки. На них требуется немедленное реагирование. На отдельные автоматически стартуют инцидентные протоколы(заводится чат, создается тикет)

## Разбор мониторингов с sre дашборда
Во время дежурства основным дашбордом наблюдения за сервисом является [SRE дашборд](https://solomon.yandex-team.ru/?project=direct&dashboard=direct-group-sre-tv).
Необходимо поглядывать за графиками на предмет резких скачков для 500к, загруженности баз, таймингов или резких падений для количества запросов. В левом углу есть блок с джаглерными проверками "direct-healt", в котором собраны агрегаты с основными алертами подсистем сервиса.
Общее состояние этого блока транслируется в заголовок "мониторингового" [чата](https://t.me/joinchat/BV5nDFZESvl3Sfu5lsIhLg).
Также есть [страничка со ссылками](https://wiki.yandex-team.ru/direct/dash/) на дашборды отдельных подсистем для более детального анализа. Подробнее в [доке по разбору алертов](./duty_alerts_manipulations.md)

## Обработка тикетов, необходимых для поддержания продакшена
Такие тикеты возникают достаточно редко, но откладывать их не стоит, т.к. от них напрямую зависит стабильность/работоспособность сервиса. Например:
- Добавить по реплике в каждый шард mysql
- Увеличить/уменьшить количество подов приложений в деплое
- Раскладывание/обновление секрета
- Переключение на другую часть соседнего сервиса
- [Учения](../jeri/howto-drills.md) / [прогрузки](../jeri/overloading.md)

## Ведение/Выкладка релизов
- [Сборка](../guide/releases/release-newci.md#sborka-reliza)
- [Ведение релиза на ТС](./direct-releases-duty.md)
- [Приемка релиза к выкладке](../processes/regulations_deploy_releases_newci.md#priemka-otvetstvennym-app-duty)
- [Выкладка релиза](../processes/regulations_deploy_releases_newci.md#vykladka-relizov)

## Обработка тикетов DIRECTSUP (Ежедневно 1 час)
Обработка сложных обращений, пришедших через поддержку. Первичная оценка критичности и массовости. Классификация по сервисам и зонтам. Подробнее в [документации](./direct-releases-duty.md#directsup)

## Заполнение SPI тикетов
К окончанию дежурства необходимо заполнить все SPI тикеты, созданные за время дежурства. Полностью заполнять самостоятельно может не получиться, лучше призвать причастного к аварии и добиться от него заполнения, т.к. у него больше контекста и понимания аварии.
[Дока](incidents/spi-ticket)

## Обработка запросов из "единого окна"
`#TODO`

## Обработка отложенных действий
Отложенные действия - тикеты, которые необходимо сделать, но в моменте их выполнение может быть невозможно или неактуально. Находятся по компоненте `app-duty-postponed-action` [фильтр](https://st.yandex-team.ru/issues/?_o=updated+DESC&components=%5B78327%5D&resolution=%5B%22empty%28%29%22%5D)

## Опционально:
- Разбор беклога
- Инфраструктурные улучшения
- Накатывание необязательных обновлений
