[Руководство по использованию фичей](howto-code.md) <br/>
# Фичи


## Жизненный цикл фичи { #lifecycle }

1. Добавление фичи в java-код в enum [FeatureName](https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal/base-model/src/main/java/ru/yandex/direct/feature/FeatureName.java) - первоисточник информации о фиче. Аналогичный enum со списком фичей на фронтенде генерируется из кода бэкенда.
2. Реализация бизнес-логики, зависящей от бинарного состояния фичи (включена/выключена).
3. Добавление фичи в базу. Именно там будут храниться её настройки.
4. Автоматическое создание тикета на фичу, в котором автоматика будет отражать изменение настроек и публиковать уведомления.
5. Использование фичи. Изменение её основных настроек, влияющее на то, для каких пользователей она принимает состояние "включена", а для каких - "выключена".
6. Удаление всех использований фичи из кода (фронтенда и бэкенда).
7. Удаление фичи из базы.
8. Закрытие тикета.

Подробнее о добавлении, использовании в коде и удалении фичей читайте в [инструкции](howto-code.md).

## Временные и постоянные фичи { #temp_permanent }

По типу жизненного цикла фичи делятся на два типа: временные и постоянные. Тип указывается в java-кода в качестве первого аргумента енума [FeatureName](https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal/base-model/src/main/java/ru/yandex/direct/feature/FeatureName.java) - [FeatureType](https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal/base-model/src/main/java/ru/yandex/direct/feature/FeatureType.java).

Временные фичи (`FeatureType.TEMP`) - это такие фичи, которые вводятся для плавной выкладки новой функциональности на пользователей через процент. Их так же можно выдавать конкретным пользователям. Они подлежат удалению после включения на 100% в продакшене.

Постоянные фичи (`FeatureType.PERMANENT`) - это такие фичи, которые служат только для включения определённой части функциональности конкретным пользователям и не предназначены для включения на процент.

## Ответственный за фичу { #responsible }

У каждой фичи есть "ответственный". Его необходимо указать при добавлении фичи в базу ([инструкция](howto-code.md#add-db)). В его область ответственности входит:
- Выделение ресурсов для своевременного удаления фичи.
- Своевременное поддержание соответствия состояния фичи на разных средах, в том числе выделение ресурсов для актуализации тестов фронтенда.
- Контроль состояния фичи. Он решает, кому (или на какой процент) и когда можно включать фичу (это, разумеется, не значит, что только он может менять настройки или подтверждать каждое включение фичи разработчиками).
- А так же прочие вопросы, связанные с фичей.

По умолчанию ответственным за фичу становится ответственный за проект, в рамках которого добавляется фича.

{% note info "Сроки удаления фичи" %}

Фича должна быть полностью удалена не позднее чем через месяц после включения на 100% пользователей.

{% endnote %}

{% note info "Сроки актуализации фичи на ТС" %}

Фича должна быть включена на ТС не позднее чем через неделю после включения на 100% пользователей в продакшене.

{% endnote %}


## Ведение фичи в трекере { #tracker }

### Дэшборд { #tracker-dashboard }

[Дэшборд по фичам в Директе](https://st.yandex-team.ru/dashboard/47190)


### Основной тикет { #tracker-main }

После создания фичи в базе в течение примерно 10 минут автоматика создаёт тикет с [ответственным](#responsible) в качестве исполнителя и наблюдателями, указанными при добавлении.

В тикете выставляется компонент `FeatureFlag`.

Проставляются теги:
- при включении фичи на 100% - `dead_feature`;
- при истечении срока, в который фича должна быть удалена - `dead_feature_expired`;

Пишутся комментарии:
- об изменении общих настроек фичи (процент, роли, публичность и другие);
- о включении и выключении фичи конкретным пользователям;
- с напоминаниями о необходимости удалить фичу;
- с автоматически созданным тикетом на включение фичи на ТС.


### Тикет на включение фичи на ТС { #tracker-ts }

Если автоматика обнаруживает фичу, которая включена в продакшене на 100%, а в тестинге - нет, она создает дополнительный тикет на включение фичи на ТС и линкует его к основному.

Проставляются теги:
- при создании - `ts-feature`;
- при истечении срока, в который фича должна быть включена на ТС - `ts_feature_expired`.
