# Функциональное тестирование DNA

## Что это такое
В данной статье функциональными тестами будем называть те тесты, в которых проверяется живое приложение **DNA**, путём автоматизированного открытия приложения в веб-браузере и выполнения какого-либо сценария и/или визуальной проверки с помощью сравнения скриншотов элементов интерфейса с эталоном.

Соответственно, функциональное тестирование — это всё, что касается функциональных тестов — написание тестов, запуск тестов, инфраструктура, в которой эти тесты запускаются

## Где и когда

Функциональные тесты запускаются:

- автоматически в среде CI (Continuous Integration) на каждый коммит в мастер и ограниченный набор тестов на каждый коммит в открытых пул-реквестах
- автоматически в процессе сборки релизов приложений **DNA** и **java-web**
- вручную разработчиками при починке тестов в пул-реквестах перед влитием их в мастер
- вручную дежурным по тестам всегда и везде

## Тест-кейсы { #test-cases }

Тесты-кейсы написаны typescript-кодом в виде инструкций для тест-раннера [Hermione-js](https://github.com/gemini-testing/hermione) и хранятся в репозитории с приложением [**DNA**](https://github.yandex-team.ru/direct/dna/tree/master/tests/hermione/suites)

В **DNA** тесты разбиты на три группы по признаку _"тяжести"_:

- `B2B` — легковесные тесты, оказывающие минимальную нагрузку на тестовую инфраструктуру Директа (основной тестовый стенд test-direct.yandex.ru и соответствующие БД) и наименее подверженные нестабильности во внешних факторах.
В этих тестах в основном используются заранее подготовленные сущности, сравнение результатов происходит в основном скриншотами для обеспечения надежности таких тестов.
Запускаются в пул-реквестах
- `frozen` — аналогично B2B, но бэкенд директа подменяется на заранее подготовленные дампы, что обеспечивает еще более сниженную нагрузку на тестовую инфраструктуру и еще более высокую надежность тестов. Эти тесты выделены в отдельный набор, так как они обязательны в пул-реквестах, в отличие от B2B
- `functional` — тяжёлые тесты, оказывающие высокую нагрузку на тестовую инфраструктуру Директа.
В таких тестах могут создаваться новые сущности (нагрузка на БД и зависимость от внешнего фактора — [steps-proxy](#steps-proxy)).
Из-за тяжести эти тесты в пул-реквестах не запускаются

## Описание тестовых сценариев в yml-файлах { #test-cases-in-yml }
Все тестовые сценарии должны быть описаны в yml-файлах. Это относится как к уже написанным тестам, так и к тем, которые планируется написать.

### Зачем это нужно
Описание сценариев в yml-файлах нужно, чтобы синхронизировать тесты с [Testpalm](https://testpalm2.yandex-team.ru/dna) при помощи [palmsync](https://github.yandex-team.ru/search-interfaces/infratest/blob/master/packages/palmsync/docs/quick-start.md). Также, описанные в yml сценарии, на которые ещё не написаны тесты – это подробное описание задачи на написание этих тестов.


### Команды
- `npm run palmsync:validate` – запускает валидацию yml-файлов в DNA. Проверяется синтаксис yml-файлов и соответствие тестовых файлов их yml-описаниям. Проверка соответствия проверяет только то, что для теста есть описание с тем же названием в нужном файле. Сам сценарий не проверяется.
- `npm run palmsync:sync` – запускает синхронизацию тестов с [Testpalm](https://testpalm2.yandex-team.ru/dna). Для запуска потребуются [установленные из секретницы секреты Искорки](https://github.yandex-team.ru/twilight/twilight-secrets#установка). Запускать синхронизацию с Testpalm рекомендуется только из мастера.

### CI
Для проверки соответствия тестов их yml-описаниям в пулл-реквестах автоматически запускается проверка `Palmsync validate test yml`.
Если в вашем ПР упала эта проверка – нужно пойти в логи sandbox-таски, посмотреть найденные валидатором ошибки и исправить соответствующие тесты или yml-файлы.

### Написание
[Пример файла](https://github.yandex-team.ru/direct/dna/blob/master/tests/hermione/suites/frozen/editors/cpaStrategyAlerts.view.hermione.yml)

### Основные правила
- файл yml и тестовый файл должны лежать в одной папке и называния должны отличаеться только расширением (пример названия файла: для `textCamaigns.hermione.ts` — `textCamaigns.hermione.yml`)
- В yml-файлах используется синтаксис yaml ([подробнее тут](https://github.yandex-team.ru/search-interfaces/infratest/blob/master/packages/palmsync/docs/yaml-files.md))
- Поле `feature` в yml-сценарии соответствует верхнему `describe` в тестовом файле
- Дальнейшее описание повторяет иерархию вложенности `describe` `it` из тестового файла
- Описание сценария строится из полей  `-do` `-assert`
- Поле `file` – путь до скомпилированного в js тестового файла. Заполняется при наличии тестов.
- Поле `tags` – тэги для фильтрации в Testpalm. Можно указать как для всего сьюта, так и на любом уровне вложенности вплоть до отдельных кейсов. Тэг `not automated` проставляется в Testpalm автоматически, его добавлять не нужно.

## Подготовка данных для тестирования

Подготовка данных для тестов может быть двух типов:

- on-demand — новые данные для тестов готовятся непосредственно перед запуском конкретного теста, например, при каждом новом запуске создается новая рекламная кампания.
Тесты, подготавливающие данные таким образом относятся к категории `functional`
- заранее подготовленные зафриженные данные — это дампы бэкендных ответов, которые подготавливаются на этапе написания тестов.
Эти данные не меняются от прогона к прогону, даже если в тестах были использованы on-demand данные, так как запросы на on-demand-подготовку данных тоже дампятся и фризятся.
Тесты, использующием зафриженные дампы, относятся к группе `frozen` и обязательны для влития пул-реквестов

### Steps-proxy (степы) { #steps-proxy }

Steps-proxy — это rest-api приложение ([ссылка на приложение](https://deploy.yandex-team.ru/stage/direct-apisteps-proxy)), позволяющее создавать определённые сущности (такие как кампании, группы, объявления) в директе, менять этим сущностям статусы, удалять их и т.п. Данное приложение создано специально для подготовки тестовых данных ([как работать со steps-proxy](#steps-proxy-how-to)) 

### Steps2 (новые степы)

Steps2 — аналогично steps-proxy приложение предназначено для подготовки тестовых данных, но написанное на новых технологиях и лучше задокументированное. Находится в процессе развития ([описание API](https://test-direct.yandex.ru/test-steps/docs/swagger-ui.html))

### Clement-js (дампы запросов в API)

Clement-js — это специальный proxy-сервер ([ссылка на документацию](https://a.yandex-team.ru/arc/trunk/arcadia/frontend/projects/infratest/packages/clement)), перехватывающий запросы веб-приложения **DNA** в java-web API Директа.
У clement'а есть три режима работы — transparent-proxy (проксирование запросов без изменений), режим записи и режим чтения.
В режиме записи все запросы сохраняются в виде дампов, и отдаются в ответ на запрос в режиме чтения без проксирования.
Соответственно, для подготовки данных для тестов нужно снять дампы бэкенда в режиме записи ([как работать с clement-js](#clement-js-how-to)) 

## Как работают тесты под капотом

### Простой режим 

Рассмотрим запуск тестов командой ([подробнее про запуски](#run-tests))

```
npm run hermione
```

Этой командой запускается таск-раннер [Archon](https://github.yandex-team.ru/search-interfaces/infratest/tree/master/packages/archon#archon), который в свою очередь запускает ряд параллельных процессов:

- tunneler ([документация на вики](https://wiki.yandex-team.ru/search-interfaces/infra/infrasre/duty/tunneler/)) — это клиентская часть сервиса, который предоставляет динамически сформированный URL для тестируемого приложения на домене yandex.ru (для Директа это важно, так как мы тестируем "залогиновую" функционалность).
Запросы по этому урлу проксируются на локальный порт, указанный в параметрах запуска туннелера.
URL может выглядет так: `username-12345-tun.yandex.ru`
- clement-js первый — это прокси-сервер, запущенный на том же порту, на который перенаправляет запросы tunneler.
Перехватывает и/или перенаправляет запросы в api Директа.
Слушает некоторый случайно выбранный порт на localhost, например порт 8765
- clement-js второй — это прокси сервер, перехватывающий запросы в степы
- hermione — тест-раннер.
Собственно, запуск тестов, подготовка данных и проверка результатов происходит здесь.
  - Перед началом теста гермиона обращается в степы (если это предусмотрено сценарием теста) по адресу `localhost:8765` (через clement-второй)
  - Гермиона посылает команды в общеяндексовый сервис [selenium-grid](https://wiki.yandex-team.ru/selenium/),
где в браузерах открывается Директ и выполняется сценарий теста.
Директ открывается по динамически сформированному туннелером URL-у `username-12345-tun.yandex.ru`
  - В конце теста проиходит assert какого-либо параметра или скриншота, в результате чего тест считается прошедшим успешно или с ошибкой
  - После прохождения теста независимо от исхода удаляются подготовленные для теста данные путём обращения в степы

Схематичное изображение данного процесса представлено на диаграмме ниже:

![режим proxy](./assets/clement-proxy-mode.png)

### Режим записи

Внимание! Если вы ищете инструкцию по обновлению дампов, то вам [сюда](how-to-refresh-dumps.md).

Режим записи включается флагом `--save` ([подробнее про запуски](#run-tests))

```bash
npm run hermione -- --save
```

Данный режим отличается от простого режима тем, что проксируемые через clement'ы (первый и второй) запросы записываются в виде дампов (см. диаграмму).

Режим записи предполагается запускать на этапе разработки теста, или для обновления дампов в пул-реквестах или в рамках [test-duty](https://wiki.yandex-team.ru/users/dima117a/test-duty/)

![режим записи](./assets/clement-write-mode.png)


### Режим чтения

Режим чтения включается флагом `--play` ([подробнее про запуски](#run-tests))

```bash
npm run hermione -- --play
```

В данном режиме запросы, перехваченные clement'ами (первым и вторым) не проксируются, а ответы берутся из заранее подготовленных дампов (см. диаграмму). 

Режим чтения предназначен для запуска тестов в среде CI.

![режим чтения](./assets/clement-read-mode.png)

## Как запускать тесты { #run-tests }

```bash
# простой запуск
npm run hermione

# запуск веб-сервера гермионы
npm run hermione gui

# запуск в режиме записи
npm run hermione -- --save

# запуск веб-сервера в режиме записи
npm run hermione gui -- --save
# запуск в режиме чтения
npm run hermione -- --play

# запуск frozen набора тестов гермионы
npm run hermione -- --set frozen
# или
npm run hermione:frozen

# запуск B2B набора тестов гермионы
npm run hermione -- --set b2b
# или
npm run hermione:b2b

# запуск functional набора тестов гермионы
npm run hermione -- --set functional

# выборочный запуск тестов, отфильтрованных регуляркой
npm run hermione -- --grep 'Название теста'

# запуск гермионы на локальном selenium-сервере
npm run hermione:standalone

# запуск гермионы в сендбоксе
npm run hermione:sandbox
# или
npm run hermione:sandbox-b2b # B2B набор
# или
npm run hermione:sandbox-func # functional набор

```


## Зависимости

Для запуска тестов на локальном селениуме в системе должны быть установлена Java Development Kit 8. Фронтенд разработчикам для этого было бы удобно воспользоваться сервисом [SdkMan](https://sdkman.io/).

Остальные зависимости устанвливаются стандартным для node-js способом `npm ci`. Для запуска тестов на удаленном selenium-grid'е этого достаточно.

{%note warning %}

Этот и последующие разделы в процессе написания и ещё дорабатываются.

{% endnote %}

## PageObjects
Лежат в `tests/page-objects`.
[Page Object Pattern](http://internetka.in.ua/selenium-page-object/) — шаблон проектирования, служит для разделения 
логики выполнения тестов от реализации. В идеале, в тестах должны использоваться только PageObjects.

Плохо:
```javascript
it('Открываем попап c типом кампании "Тексто-графическое обьявление"', asynс function () {
    await this.browser
        .waitForExist('.add-campaign-control')
        .click('.add-campaign-control')
        .waitForExist('.campaign-types-list__title=Динамические объявления')
        .click('.campaign-types-list__title=Динамические объявления')
        .waitForExist('.frame-edit-popup_loaded');
});
```

Хорошо:
```javascript
it('Открываем попап c типом кампании "Тексто-графическое обьявление"', asynс function () {
    await campaignEditPopup.open(campaignsTypes.text);
});
```

## Как работать со steps-proxy { #steps-proxy-how-to }
Код, который делает запросы в steps-proxy лежит в [`tests/steps`](https://github.yandex-team.ru/direct/dna/tree/master/tests/hermione/steps).

Это набор классов для создания данных на бетах. Они общаются по http с сервисом `api-steps-proxy.qloud.yandex-team.ru`.
Код сервиса можно посмотреть тут [directapi-steps](https://a.yandex-team.ru/arc/trunk/arcadia/direct/qa/directapi-steps).

К сервису нет документации. Сейчас чтобы добавить новый метод к нам в steps нужно:

1. Открыть исходный код и найти публичные методы помеченные аннотацией @steps.
2. Понять какие аргументы принимает метод (найти декларацию аргументов, выписать все необходимые поля).
3. Сформировать запрос. В запросе указываем имя метода которых хотим вызвать и задаем аргументы с которыми хотим позвать метод. 

Есть тикет с запросом на более удобное API: DIRECT-78302.

## Как работать с Clement-js { #clement-js-how-to }

### Запуск с локальным selenium
Запускаем локальный selenium.
```
npm run selenium
```

После этого можно запускать тесты:

#### Запустить все тесты на ТС
```
npm run hermione:standalone
```
#### Запустить все тесты в интерактивном режиме
```
npm run hermione gui
```
#### Запустить все тесты скриншотами
**Рекомендуется использовать для снятия/переснятия скриншотов**
```
npm run hermione:b2b
```
#### Запустить все тесты скриншотами локально
Возможны отличия в скриншотах от удаленных запусков из-за отличающегося разрешения экрана. **Этой командой нельзя пользоваться для переснятия скриншотов**
```
npm run hermione:b2b-standalone
```

#### Запустить все тесты на конкректной бете (адрес беты задается через переменные окружения)
```
BETA_PORT=10942 npm run hermione:standalone
```

#### Запустить все тесты на ТС и в случае если какой-то тест упадет — перезапускать его 3 раза
```
RETRY=3 npm run hermione:standalone
```

#### Запустить определенный тест по имени:
```
npm run hermione:standalone -- --grep='Колонки страницы кампаний'
```

#### Запустить тесты в headless режиме:
```
HEADLESS=true npm run hermione:standalone
```

#### Запустить с подробными логами:
```
LOG_LEVEL=debug npm run hermione:standalone
```

### Запуск на гриде яндекса
#### Все тесты
```
npm run hermione:ci
```
#### Только тесты скриншотами
```
npm run hermione:b2b-ci
```

## Отчеты
После выполения тестов, генерируется html репорт в папке `__reports/report-hermione:ci`

### Реиспользование отчетов
Отчеты из Sandbox (и TeamCity) можно использовать повторно для прогона упавших тестов/переснятия скриншотов.
<!-- [Подробнее](./reuse-report.md) -->

### Разбираем причину падения теста
Если упал тест, то можно:

1. Посмотреть на логи в консоли.
2. Посмотреть на скриншот приклепленный в репорте allure.
3. Запустить и посмотреть глазами что происходит.
4. Найдя подозрительное место в коде написать там `await this.browser.debug();`. 
Это откроет [debug REPL](https://webdriver.io/docs/api/browser/debug)
В нем можно взаимодействовать с браузером через API гермионы и понять какое условие не выполняется.
5. Использовать дебаггер nodejs.

Варианты ошибок:

1. Ошибка hermione — браузер не может выполнить какое-то действие, не выполняется условие, и т.п.
2. Ошибка степов которые создают тестовые данные. В этом случае в консоли видено описание ошибки что именно пошло не так.
3. Не создаётся бета на ppcdev5.

### Работа со скриншотами в hermione
#### Требования 

* Нужен git lfs. Как его поставить, можно узнать здесь https://wiki.yandex-team.ru/search-interfaces/git-lfs/

#### Способы получения скриншотов

* из сборки в teamcity выгрузить артефакты, нажав на вкладке `Artifacts` кнопку `Download all (.zip)`. В полученном архиве надо взять папку `report-hermione:ci` и заменить ей локальную папку `__reports/report-hermione:ci`.
* собрать бету с бранчем, и к запуску тестов добавить `BETA_PORT=номер беты`.

#### Как переснять скриншоты
```
npm run hermione:b2b
```

1. Откроется GUI на localhost:8000. В левом верхнем углу нажать `Run`
1. Могут быть следующие падения:
   - Если падение теста заключается в отличии снимков между `Actual` и `Expected`, необходимо убедиться в правильности полученного снимка, и нажать кнопку `Accept`. 
   - Если падения связаны с недоступностью ТС/Selenium, то необходимо дождаться работоспособности тестов, перезапустить их и убедиться в правильности прохождения.
   - Если падение связано не со снимком и не с падением среды тестирования, вероятно, проблема в самом тесте. Необходимо запустить команду `npm run hermione:b2b-standalone -- --grep="%%НАЗВАНИЕ ТЕСТА%%"` и проанализировать прохождение теста в открывающемся браузере. 
1. Перезапустить тест, нажав  `retry only failed`, и дождаться позеленения. Если тест красный, вернуться к п.2

## CI
Интеграционные тесты запускаются для каждого пул реквеста в Sandbox. 
Для прогона тестов используется одна из специальных бэт, которые умеют использовать собранную статику DNA по её хэшсуммам.

## Используемые технологии
[hermione](https://github.com/gemini-testing/hermione)

[Webdriver.IO](https://webdriver.io/docs/api)
