# Понятия и определения

## Определения { #main-concepts }

**Функциональные тесты** — те тесты, в которых проверяется живое приложение **DNA**, путём автоматизированного открытия приложения в веб-браузере и выполнения какого-либо сценария и/или визуальной проверки с помощью сравнения скриншотов элементов интерфейса с эталоном.

**Функциональное тестирование** — это всё, что касается функциональных тестов — написание тестов, запуск тестов, инфраструктура, в которой эти тесты запускаются.

**Тестовый сценарий** - это описание начальных условий, входных данных, действий пользователя и ожидаемого результата. В **DNA** тестовые сценарии описываются в `yml`-файлах. Перекрёстная ссылка: ([подробнее о тестовых сценариях](tests-yml.md)).

**Steps (степы)** - специаллизированное API, которое используется для операций с API-сущностями директа (такими как кампании, группы, объявления). Это rest-api приложение ([ссылка на приложение](https://deploy.yandex-team.ru/stage/direct-apisteps-proxy)), позволяющее создавать определённые сущности (такие как кампании, группы, объявления) в директе, менять этим сущностям статусы, удалять их и т.п. Данное приложение создано специально для подготовки тестовых данных ([как работать со steps-proxy](tests-write.md#on-demand)) 

**Steps2 (новые степы)** — аналогично Steps данное приложение предназначено для подготовки тестовых данных, но написанное на новых технологиях и лучше задокументированное. Находится в процессе развития ([описание API](https://test-direct.yandex.ru/test-steps/docs/swagger-ui.html))

**On-demand данные** - новые данные для тестов готовятся непосредственно перед запуском конкретного теста, например, при каждом новом запуске создается новая рекламная кампания. Такие данные готовятся при помощи steps-proxy [степы](tests-write.md#on-demand). Тесты, использующием зафриженные дампы, относятся к группе `frozen` и обязательны для влития пул-реквестов.

**Дамп** - заранее подготовленные зафриженные данные бэкендного ответа, которые подготавливаются на этапе написания тестов. Эти данные не меняются от прогона к прогону, даже если в тестах были использованы on-demand данные, так как запросы на on-demand-подготовку данных тоже дампятся и фризятся.

**Clement-js** — это специальный proxy-сервер ([ссылка на документацию](https://a.yandex-team.ru/arc/trunk/arcadia/frontend/projects/infratest/packages/clement)), перехватывающий запросы веб-приложения **DNA** в java-web и [степы](tests-write.md#on-demand). С помощью данного proxy-сервера производится запись и чтение дампов. Перекрёстная ссылка: [как работают тесты под капотом](tests-under-the-hood.md).

## Группы функциональных тестов в DNA { #tests-groups }

В **DNA** тесты разбиты на группы по признаку _"тяжести"_:

- `frozen` — легковесные тесты, оказывающие минимальную нагрузку на тестовую инфраструктуру Директа и наименее подверженные нестабильности во внешних факторах. В этих тестах используются заранее подготовленные сущности, сравнение результатов происходит в основном скриншотами для обеспечения надежности таких тестов. Запускаются в пул-реквестах.
- `functional` — тяжёлые тесты, оказывающие высокую нагрузку на тестовую инфраструктуру Директа.
В таких тестах могут создаваться новые сущности (нагрузка на БД и зависимость от внешнего фактора — [steps-proxy](tests-write.md#steps-proxy)). Из-за тяжести эти тесты в пул-реквестах не запускаются.

## Где и когда выполняются функциональные тесты { #where-and-when }

Когда выполняется | Перечень тестов | Где посмотреть в репозитории
--- | --- | ---
Автоматически в среде `CI (Continuous Integration)` на каждый коммит в `мастер` | `hermione_b2b`, `hermione_frozen`, `hermione_functional` | [Ссылка](https://github.yandex-team.ru/direct/dna/blob/master/.trendbox.yml#L205-L213)
Aвтоматически в среде CI (Continuous Integration) на каждый коммит в открытых пул-реквестах | `hermione_b2b`, `hermione_frozen` | [Ссылка](https://github.yandex-team.ru/direct/dna/blob/master/.trendbox.yml#L190-L202)
Aвтоматически в процессе сборки релизов приложений **DNA** и **java-web** | `hermione_b2b`, `hermione_frozen`, `hermione_functional` | [Ссылка](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/dna-utils/bin/dna-utils#L35)
Вручную разработчиками при починке тестов в пул-реквестах перед влитием их в мастер | -- | [Команды для запуска тестов](tests-run.md)
вручную дежурным по тестам всегда и везде | -- | [Команды для запуска тестов](tests-run.md)
