
## Как работают тесты под капотом

Все запросы веб-приложения **DNA** в java-web перехватыватываются [**Clement-js** (clement)](tests-main-concepts.md#main-concepts).

У `clement` есть три режима работы:
- [transparent-proxy или простой режим (проксирование запросов без изменений)](#transparent-proxy),
- [режим записи](#write),
- [режим чтения](#read).

### Простой режим { #transparent-proxy }

Рассмотрим запуск тестов командой ([подробнее про запуски](tests-run.md))

```
BETA_PORT=TS npm run hermione -- --grep <TEST_NAME>
```

Этой командой запускается таск-раннер [Archon](https://github.yandex-team.ru/search-interfaces/infratest/tree/master/packages/archon#archon), который в свою очередь запускает ряд параллельных процессов:

- tunneler ([документация на вики](https://wiki.yandex-team.ru/search-interfaces/infra/infrasre/duty/tunneler/)) — это клиентская часть сервиса, который предоставляет динамически сформированный URL для тестируемого приложения на домене yandex.ru (для Директа это важно, так как мы тестируем "залогиновую" функционалность).
Запросы по этому урлу проксируются на локальный порт, указанный в параметрах запуска туннелера.
URL может выглядет так: `username-12345-tun.yandex.ru`
- clement-js первый — это прокси-сервер, запущенный на том же порту, на который перенаправляет запросы tunneler.
Перехватывает и/или перенаправляет запросы в api Директа.
Слушает некоторый случайно выбранный порт на localhost, например порт 8765
- clement-js второй — это прокси сервер, перехватывающий запросы в степы
- hermione — тест-раннер.
Собственно, запуск тестов, подготовка данных и проверка результатов происходит здесь.
  - Перед началом теста гермиона обращается в степы (если это предусмотрено сценарием теста) по адресу `localhost:8765` (через clement-второй)
  - Гермиона посылает команды в общеяндексовый сервис [selenium-grid](https://wiki.yandex-team.ru/selenium/),
где в браузерах открывается Директ и выполняется сценарий теста.
Директ открывается по динамически сформированному туннелером URL-у `username-12345-tun.yandex.ru`
  - В конце теста проиходит assert какого-либо параметра или скриншота, в результате чего тест считается прошедшим успешно или с ошибкой
  - После прохождения теста независимо от исхода удаляются подготовленные для теста данные путём обращения в степы

Схематичное изображение данного процесса представлено на диаграмме ниже:

![режим proxy](./assets/clement-proxy-mode.png)

### Режим записи { #write }

**Внимание! Если вы ищете инструкцию по обновлению дампов, то вам [сюда](how-to-refresh-dumps.md).**

Режим записи включается флагом `--save` ([подробнее про запуски](tests-run.md))

```bash
OVERRIDE_HASHSUMS=1 npm run hermione -- --grep <TEST_NAME> --save
```

Данный режим отличается от простого режима тем, что проксируемые через clement'ы (первый и второй) запросы записываются в виде дампов (см. диаграмму).

Режим записи предполагается запускать на этапе разработки теста, или для обновления дампов в пул-реквестах или в рамках [test-duty](https://wiki.yandex-team.ru/users/dima117a/test-duty/)

![режим записи](./assets/clement-write-mode.png)


### Режим чтения { #read }

Режим чтения включается флагом `--play` ([подробнее про запуски](tests-run.md))

```bash
OVERRIDE_HASHSUMS=1 npm run hermione -- --play
```

В данном режиме запросы, перехваченные clement'ами (первым и вторым) не проксируются, а ответы берутся из заранее подготовленных дампов (см. диаграмму). 

Режим чтения предназначен для запуска тестов в среде CI.

![режим чтения](./assets/clement-read-mode.png)
