# Глоссарий Директа

Также см. [общеяндексовый словарь внутренних терминов](https://wiki.yandex-team.ru/hr/mag/slovar/).

## chassis { #chassis }
Chassis, оно же "Шасси" — приложение для выполнения релизных или околопродакшеновых задач, построенное на общих директовых технологиях, но работающее в изолированной от продакшена инфраструктуре.

Содержит в себе простой веб-сервис и шедулер для выполнения задач (Hourglass как в Jobs, с некоторыми ограничениями).

[Код в аркадии](https://a.yandex-team.ru/arc/trunk/arcadia/direct/apps/chassis), собирается и выкладывается приложение [автоматически через NewCI](https://a.yandex-team.ru/projects/direct/ci/releases/timeline?dir=direct/apps/chassis&id=deploy-layer-release).

## CPC { #cpc }
CPC — буквально cost per click. Цена клика — сумма, которую платит рекламодатель контекстной системе за клик по объявлению, сделанный пользователем. Ещё этим термином называют модель оплаты для всех кампаний в Директе, кроме Медийных (пример: Текстово-графическая кампания — это CPC-кампания).


## CPC видео { #cpc_video }
СPC видео (cpc-video) —  внутреннее название типа объявления Видео в ТГО (иногда — и других типах кампаний по модели CPC)


## CPM { #cpm }
это аббревиатура от Cost Per Millenium, то есть цена за тысячу показов баннера. Ещё этим термином называют модель оплаты Медийных кампаний, или сами Медийные кампании. Так как там оплата происходит за 1000 показов, а не за клики.
В интерфейсе нельзя одновременно работать с CPM и CPC кампаниями.


## CPM видео { #cpm_video }
CPM видео (cpm_video) — внутреннее название типа объявления Видео в Медийке


## CTR { #ctr }
CTR — clicks through rate, отношение количества кликов к количеству показов объявления.


## Direct-Health-мониторинги { #direct-health-monitoring }
Формально: juggler-проверки, которые попадают в блок Direct Health на [дашборде](https://solomon.yandex-team.ru/?project=direct&dashboard=direct-group-sre-tv).
По смыслу: health-проверка — это проверка в Juggler, которая показывает состояние большого куска Директа: приложения, подсистемы, смежного сервиса.
Health-мониторинг делаем как агрегат с ```logic_or``` над содержательными проверками про соответствующую часть Директа.

Health-мониторинги заводим автоматически по следующим источникам:

- [реестр приложений](#apps-conf), поле ```health_checks```
- [реестр подсистем](#subsistems-list), поле ```health_checks```
- [реестр смежных сервисов](#backing-services-list), поле ```health_checks```


## DNA { #dna}
Буквально: **Direct New Application** — Новый интерфейс Директа.
Часть страниц Директа сейчас уже в Новом интерфейсе (пример: Инструменты, Список кампаний).
Часть ещё в Старом (пример: Страница кампании).
Преимущества DNA: скорость, возможность отображения рекомендаций, массовые действия над множеством объектов.
Все новые фичи преимущественно делаются в Новом интерфейсе.

## ErrorBooster { #error-booster }
Яндексовый инструмент для просмотра и анализа ошибок. Пришел на замену Sentry.

[Директ в ErrorBooster](https://error.yandex-team.ru/projects/direct/?filter=environment%20==%20production).
Сейчас у нас туда отправляются ошибки из фронта, java-бекендов и некоторые из perl.

## ESS { #ess }
Буквально: event sourcing system. Система для реализации бизнес- и инфраструктурной логики на основе потока изменений в данных (в противоположность текущему состоянию данных в БД).
В Директе "поток изменений" строится на основе mysql-бинлогов.
Цикл обработки выглядит так:

- приложение binlogbroker читает бинлоги, пишет в LB
- приложение ess-router читает эти бинлоги из LB, применяет правила фильтрации и раскладываем еще в кучу топиков в LB
- джобы из приложения java-jobs читают какие хотят топики и делают полезное

## LogViewer { #logviewer }
[Интерфейс](https://direct.yandex.ru/logviewer) для просмотра логов Директа.

[How to от поддержки](https://wiki.yandex-team.ru/accountdirect/logi/)

## Marty { #marty }
Дежурный администратор поиска (из дежсмены).

Реагирует по disaster—алертам, координирует общеяндексовые аварии, помогает в межсервисных авариях.
Узнать текущего marty можно в личке у [YaIncBot](https://t.me/YaIncBot) командой `/marty`.

## ppcdev { #ppcdev }
Разработческий сервер Директа.
На нём работают [беты](#beta) Директа,
установлены необходимые разработчику программы.
Серверов несколько, обычно имеют ввиду любой из:

- `ppcdev1.yandex.ru` (Мытищи)
- `ppcdev2.yandex.ru` (Сасово)
- `ppcdev3.yandex.ru` (Финляндия)
- `ppcdev4.yandex.ru` (Сасово)
- `ppcdev5.yandex.ru` (Сасово) — сервер для бет тестировщиков
- `ppcdev6.yandex.ru` (Мытищи)
- `ppcdev7.yandex.ru` (Финляндия)


## solo { #solo }
Solo — фреймворк для создания дашбордов, алертов и других объектов в Solomon и Juggler. Разрабатывается в AdFox, используется в AdFox, БК, Директе.
[Код](https://a.yandex-team.ru/arc/trunk/arcadia/library/python/monitoring/solo).

## SRE { #sre }
SRE — cокращение от Site Reliability Engineer.

В контексте процессов \[9999\] — подразумевается дежурный по продакшену сервиса.

## SRO { #sro }
SRO — сокращение от Site Reliability Operator.

В контексте процессов \[9999\] — подразумевается [Дежурная смена](https://wiki.yandex-team.ru/jandekspoisk/sepe/dezhurnajasmena/), в частности [Marty](#marty).

## ZBP { #zbp }
Буквально: Zero Bug Policy. Подход в управлении багами при разработке.
Основная суть — сокращение бэклога проблем до нуля.
В Директе есть специальное дежурство для сокращения zbp-метрики. Подробнее см. [на странице zbp-дежурства](https://wiki.yandex-team.ru/direct/development/zbp-duty/).


## АДФ { #adf }
Автоматически добавленные фразы (устар.): фразы, подобранные инструментами Дополнительные релевантные фразы и Авторасширение ключевых фраз.


## Банана (внутренняя реклама) { #internal-ads }
Внутренняя реклама (aka Банана) - отдельная версия гридов для размещения рекламы сервисов Яндекса, используется нашими маркетологами. <br/>
Роли операторов: `internal_ad_admin`, `internal_ad_manager`, `internal_ad_superreader`. Под обычным суперридером и супером внутренняя реклама тоже доступна. <br/>
Типы кампаний: `internal_distrib`, `internal_free`, `internal_autobudget`. <br/>
Типы групп: `internal`. <br/>
Типы баннеров: `internal`.

## Баннер в Метро { #geo_banner } { #metro }
Баннер в Метро — тип объявления в Медийке. Может быть картиночным или HTML5. В качестве страницы перехода используется турбо-страница со специальным гео-шаблоном. Показы происходят в приложении Яндекс.Метро.


## Баннер на поиске { #mcbanner }
Баннер на поиске — тип РК и объявления, состоящего только из картинки и кликовой ссылки.
Это Медийная реклама с оплатой за клики ([CPC](#cpc)).
Показывается на поиске Яндекса, Рамблера и Mail.ru справа от результатов поиска.
В коде упоминается как `mcbanner`.


## Баян { #bayan }
Старый инструмент размещения медийно-контекстных баннеров.
Жил по адресу ba.yandex.ru, технически являлся частью Директа (в коде упоминается как `mcb`).

[Закрыт](https://st.yandex-team.ru/DIRECT-76190) 1 февраля 2018 года.

## Бета { #beta }
Экземпляр Директа, запущенный на ppcdev для разработки и тестирования.
Состоит из рабочей копии и нескольких процессов, запущенных над нею.
Беты доступны по адресам вида
<https://8080.beta1.direct.yandex.ru>,
<https://8999.beta1.direct.yandex.ru>.
Здесь 8080, 8999 — номер беты.
Про создание бет см. [Руководство](../dev/betas/betas.md)

Существует несколько "перманентных" бет (их еще называют общими, или тестовыми, или главными):
* <https://8080.beta1.direct.yandex.ru/> — бета со сборкой прошлого релиза
* <https://8998.beta1.direct.yandex.ru/> — бета с последней ревизией trunk и БД devtest
* <https://8996.beta1.direct.yandex.ru/> — бета с последней ревизией trunk и БД dev7

## Бинлогброкер { #binlogbroker }
Приложение binlogbroker по [реестру приложений](#apps-conf).
Частный случай синхронизатора.
Читает бинлоги от баз ppcdata и ppcdict, пишет в LogBroker.
Состоит из двух процессов: просто binlogbroker и binlogbroker-json.
Простой binlogbroker пишет данные в протобуфе и их потом потребляет ESS.
binlogbroker-json пишет данные в json. Их потом вычитывает LogShatter и складывает в ClickHouse. Эти бинлоги доступны в [LogViewer](https://direct.yandex.ru/logviewer), логи binlog...v2.


## Видео (видеобаннер) { #videobanner }
Видео (видеобаннер) — тип объявления в ТГО, Медийке, РМП. Используются термины cpc-видео и cpm-видео для видеобаннеров в ТГО и Медийке соответственно. Объявление, состоящее из видеокреатива. Показы только в сетях.

## Видеодополнение { #videoadv }
Видеодополнение — дополнение к текстовому объявлению. Видеодополнение превращает текстовое объявление в короткий видеоролик, используя заголовок, текст, изображение и ссылку объявления. Видеодополнение может быть создано руками или сгенерировано автоматически.


## ГО, Графическое объявление { #GOadv }
Графическое объявление — тип объявления в ТГО, РМП, [МКБ](#mcbanner). Объявление, состоящее из картиночного креатива.


## ДО, Динамические объявления { #DOadv }
Динамические объявление, оно же ДО — тип РК. CPC. Текстовые объявления, автоматически созданные из фида или по содержанию сайта. Показываются на поиске Яндекса.


## ДК, Директ.Коммандер { #dk }
Десктоп-приложение, позволяет автономно настраивать рекламу для Яндекс.Директа.


## Зеркализатор { #mysql2yt-full }
Приложение mysql2yt-full по [реестру приложений](#apps-conf).
Частный случай синхронизатора.
Читает бинлоги от баз ppcdata и ppcdict; пишет динтаблицы в hahn и arnold. Таблицы общего назначения: для статистики, выгрузок, чего угодно.
Реплицирует все таблицы.
Данные в Hahn: [здесь](https://yt.yandex-team.ru/hahn/navigation?path=//home/direct/mysql-sync&)


## Инцидент { #incident }
Авария, нарушение нормальной работы какого-то из сервисов.
Про работу с инцидентами в Директе см. разделы Аварии в Концепциях и Руководстве.


## Ключевая фраза, ключевик { #phrase }
Ключевая фраза, она же ключевик — тип условия показа. Доступно в ТГО, РМП, МКБ, Медийке, Сделках, Продвижении контента. Фраза, несущая существенную смысловую нагрузку. Такая фраза может служить ключом при поиске информации в интернете или на странице сайта.


## Мобильное объявление { #mobadv }
Мобильное объявление — тип объявления в ТГО. Объявление с приоритетным размещением на мобильных.


## МКБ { #mkb #mcb }
Медийно-контекстный баннер.
Раньше так называли объяления [БаЯна](#bayan), сейчас — [баннеры на поиске](#mcbanner).


## МОК { #mok }

Мастер отчетов на кампанию.
Открыть можно со страницы кампании по кнопке **Посмотреть статистику**, вкладка **Мастер отчетов**.

_Под капотом_ то же самое, что и в [МОЛ](#mol).

## МОЛ { #mol }

Мастер отчетов на логин.
Открыть можно со страницы всех кампаний по кнопке **Статистика по всем кампаниям**, вкладка **Мастер отчетов**.

_Под капотом_ использует БКшную ручку [мастера-отчётов](https://a.yandex-team.ru/arc/trunk/arcadia/yabs/interface/yabs-export-scripts-fast/cgi/master-report.cgi).


## Наружная реклама, Аутдор, Outdoor { #outdoor}
тип объявления в Медийке. Объявление, состоящее из видеокреатива. Реклама в оффлайне. Показы объявления происходят на видео-щитах.


## Песочница API Директа { #direct-api-sandbox }
Инсталляция API Директа с отдельной от большого продакшена БД и замоканными соседними сервисами (Модерация, Баланс и т.п).
В Песочнице рекламодатели тестируют свои скрипты для работы с API Директа.
В коде и инструментах называется sandbox.
Не путать с <https://sandbox.yandex-team.ru>

Внешняя документация: <https://yandex.ru/dev/direct/doc/dg/concepts/sandbox-docpage/>


## Пропертя { #ppc-property }
Она же `ppc-property`. Так называют произвольное значение, хранимое в табличке `ppcdict.ppc_properties`
(в ней три поля: `name`, `value` и время последней модификации записи).
Когда пишут "пропертя такая-то", имеют ввиду запись с `name = 'такая-то'`.

Используются для:
- хранения состояния между итерациями работы кода
- изменения поведения кода без релиза

Появились раньше, чем фичи.
Отличие: одно значение на всю систему (без процентов или возможности включить на клиента).


## Радар { #radar }
<https://radar.qart.yandex-team.ru> — сервис-помощник для инженеров по тестированию команды ИРТ.
Исходники живут на [гитхабе](https://github.yandex-team.ru/qa-irt/radar).
Нужны и используются следующие функции:

- создание тикетов на регрессию и запуск тестов
- получение текущих дежурных из разных источников (ABC, duty.mtrs)
- отображение [светофоров](#traffic-light)
- страничка сравнения JSON'ов

В остальном — сервис поддерживается слабо, а заметная часть функциональности устарела.


## Реестр графиков и проверок { #megadash }

Он же "мегадашборд". <https://wiki.yandex-team.ru/direct/dash/>

Подробнее: [{#T}](../jeri/things/megadash.md)

## Реестр http-сервисов { #direct-vhosts-list }
<https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/direct-vhosts.yaml>
Используется для заведения мониторингов, при раскладывании ssl-сертификатов.
Хранит ссылки на SECAUDIT-тикеты (надо для аппрува внешних сертификатов).


## Реестр подсистем { #subsistems-list }
Список подсистем Директа с основными их свойствами.
Подсистема — большой блок логически связанной функциональности. Примеры: статистика, транспорт в БК, доставка логов.
Основные свойства подсистемы: какие juggler-проверки показывают статус подстистемы; какие полезные ссылки есть про эту подсистему.
Реестр коммитится в [репозиторий](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/direct-subsystems.yaml).
Из репозитория записывается в ZK программой zk-sync (делают app-duty по запросу).
Из ZK программой zk-delivery доставляется на ppcdev-ы и другие машины Директа на файловую систему в файл ```/etc/yandex-direct/direct-subsystems.yaml```
Файл используется при заведении health-мониторингов и т.п.


## Реестр приложений { #apps-conf }
Список приложений (единиц выкладки) Директа с основными их свойствами.
Коммитится в [репозиторий](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/direct-apps.conf.yaml).
Из репозитория записывается в ZK программой zk-sync.
Из ZK программой zk-delivery доставляется на ppcdev-ы и другие машины Директа на файловую систему в файл ```/etc/yandex-direct/direct-apps.conf.yaml```
Файл используется в релизных инструментах, при заведении мониторингов и т.п.


## Реестр реплик mysql { #alldb-conf }

<https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/alldb-config.json>
Используется для заведения мониторингов, для построения [схемы репликации](https://observatorium.common.yandex.ru/storages/replication_schema) и т.п


## Реестр смежных сервисов { #backing-services-list }
Список важных для Директа смежных сервисов с мониторингами, которые показывают, насколько хорошо сервис работает для Директа.
Английское название backing services — из манифеста [12factor app](https://12factor.net/backing-services).
Реестр коммитится в [репозиторий](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/direct-backing-services.yaml).
Из репозитория записывается в ZK программой zk-sync (делают app-duty по запросу).
Из ZK программой zk-delivery доставляется на ppcdev-ы и другие машины Директа на файловую систему в файл ```/etc/yandex-direct/direct-backing-services.yaml```
Файл используется при заведении health-мониторингов.


## Реклама мобильных приложений, РМП { #rmp}
тип РК. CPC. Формат объявлений, с помощью которого можно продвигать приложения для iOS и Android.


## Реклама в помещениях, Indoor, индор {#indoor}
тип объявления в Медийке. Объявление, состоящее из видеокреатива. Реклама в оффлайне. Показы объявления происходят на экранах в торговых и бизнес-центрах, супермаркетах, салонах красоты, аптеках и т. д.


## Репликатор { #b2yt }
Приложение b2yt по [реестру приложений](#apps-conf).
Частный случай синхронизатора.
Читает бинлоги от баз ppcdata и ppcdict; пишет динтаблицы в seneca-nnn. Эти таблицы потом использует новый интерфейс.
Реплицирует не все таблицы.
Данные в Сенеке: [здесь](https://yt.yandex-team.ru/seneca-sas/navigation?path=//home/direct/mysql-sync&)


## Ротор { #rotor }
Сервис скриншотов.
В Директе используется в канвасе для изготовления превью смарт-баннеров.

Вики Ротора: <https://wiki.yandex-team.ru/rotor/>


## Светофор { #traffic-light }
Небольшой [пак smoke-тестов](https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=53427b42e4b08984236588ab) в AQuA,
проверяющий живость тестовой среды perl-Директа. Запускается каждые 20 минут.

Также светофором называют [страницу](https://radar.qart.yandex-team.ru/autotests/trafficLightsMonitor.html) в [радаре](#radar),
отображающую результаты пяти последних запусков "светофорных" тестов для разных окружений.


## Синхронизатор { #synchronizator }
Общее название для любых приложений, которые читают mysql-бинлоги и пишут их куда-нибудь дальше.


## Синхронизатор пользологов { #java-alw }
Приложение **java-alw** по [реестру приложений](#apps-conf),
также известное как: **UserActionLogWriter**, **UALW** или просто **ALW**.
Частный случай синхронизатора.
Читает бинлоги от баз `ppcdata` и `ppcdict`, пишет в Clickhouse `ppchouse:alw`.
Эти данные используются в "Истории изменений" в интерфейсе пользователя.


## Смарт-баннеры, смарты { #smart}
тип РК. CPC. Интерактивные баннеры с динамическим контентом. Их можно нацелить на пользователей, которые смотрели товары на сайте или интересовались похожими товарами. Смарт-баннеры показываются в сетях (РСЯ и внешние сети) и на поисковых площадках.


## Текстовое объявление { #textadv }
_в интерфейсе: текстово-графическое_ — тип объявления в ТГО, РМП. Объявление будет состоять из заголовка, текста объявления и ссылки на рекламируемый сайт.


## Текстово-графические объявления, ТГО { #tgo}
тип РК. CPC. Универсальные объявления, которые подходят для рекламы большинства товаров и услуг. Объявления показываются в результатах поиска и в сетях, на десктопах, планшетах и мобильных телефонах.

## Фишки { #fishki #chips }
Они же `chips`, они же `YND_FIXED` — условная единица денег, равная 30 рублям (**с НДС** равным 18%).
Использовалась в рекламе до поддержки мультивалютности. Из интерфейса Директа у.е. убрали. "Фишечных" клиентов перевели на нормальные валюты. В БК всё ещё оперируют фишками для подсчёта денег

