# Внешний инструмент Screen

## Общие сведения

Зачем нужен:

- **мультиплексирование** — аналог табов в браузере: внутри одного окна терминала (xterm, iterm, gnome-terminal и т. д.)
можно запускать несколько консольных программ (обычно шеллов) и быстро переключаться между ними, вместо того, чтобы запускать каждую в отдельном окне.
Лучше табов в терминале, т. к. это можно делать на удалённой машине, соединившись по ssh один раз.
- **долгоживущие сессии** — запущенные в screen'е программы не привязаны к терминалу, в котором работает screen, и не теряются и продолжают работать,
если пропадёт соединение с удалённой машиной или закроется окно терминала.

Запускать **screen** имеет смысл на удалённой машине (ppcdev\*), чтобы состояние сохранялось там, когда с машиной теряется соединение.


## Запуск новой сессии

Делается на сервере один раз до следующей перезагрузки сервера.

`screen` — запустить новую "безымянную" сессию. Грубо говоря, сессия — это процесс, который хранит состояние.  
(продвинутый вариант) `screen -S <name>` — запустить новую сессию с именем.

Внутри screen-а новый screen не запускать не надо, если не знаешь, зачем это точно надо и как с этим работать.


## Подключиться к запущенному screen-у

Делается каждый раз, как заходишь ssh-ем на сервер.  

`screen -d -r` — подсключиться к уже запущенному screen-у  

`screen -ls` — вывести список существующих сессий. Новой сессии не создаст.  

`screen -d -r <name>` — присоединиться к существующей сессии, предварительно отсоединив её из терминала, если нужно

{% note info "Примечание" %}

если сессия на машине только одна, то screen -d -r без аргументов присоединится к этой единственной сессии.

{% endnote %}


## Внутри screen:

Все команды начинаются с Ctrl-a.

`Ctrl-a c` — создать новое окно.
В новом окне запускается новый шелл.

`Ctrl-a Shift-a` — переименовать текущее окно: в строке состояния внизу появится промпт, в котором можно ввести новое название.

Чтобы закрыть окно, нужно выйти из запущенного в нём шелла: нажать `Ctrl-d` _или_ выполнить команду `exit`.


## Screen как GUI мультиконсоль
Для того, чтобы всегда видеть список открытых табов и переключаться между ними по `Alt+<` и `Alt+>` отредактируйте файл `~/.screenrc` (если нет, то надо создать):
```
# Look and feel
caption always "%{= bb}%{+b w}Screen: %n | %h %=%t %c"
hardstatus alwayslastline "%-Lw%{= BW}%50>%n%f* %t%{-}%+Lw%<"

# Our warning of activity
activity "Activity in %t(%n)"

# Left Right meta key mods
#ALT-,. and ALT-<>
bindkey "^[<" eval number !echo $WINDOW-1|bc
bindkey "^[>" eval number !echo $WINDOW+1|bc
bindkey "^[," prev
bindkey "^[." next

nethack on
```


## Перемещение по окнам:

`Ctrl-a <пробел>` — следующее окно.

`Ctrl-a <backspace>` — предыдущее окно.  
Перемещение циклическое, т. е. окно, следующее за последним — это первое (нулевое).

`Ctrl-a "` — показать список окон. Можно выбрать окно стрелками.

`Ctrl-a Ctrl-a` — перейти на предыдущее активное окно

`Сtrl-a <цифра>` — перейти на окно с номером от 0 до 9


## Как выйти:

`Ctrl-a d` — отсоединить сессию от терминала: интерфейс screen-а пропадёт и мы вернёмся в шелл, в котором мы запускали команду screen, но сессия останется, потом можно присоединиться к ней с помощью `screen -d -r`)

`Ctrl-a \` — завершить сессию (пропадет насовсем). Для завершения сессии также можно закрыть все окна.


## Прокрутка:

`Ctrl-a <ESC>` — войти в "режим копирования" (если название "copy mode" сбивает с толку, считайте его историческим — он может использоваться для копирования текста, но для терминалов в графическом интерфейсе это неактуально, так как можно и так любой текст скопировать мышью)

Перемещение в этом режиме — `стрелками`, `PgUp`, `PgDown` (в iterm, по-видимому, не работает PgUp, PgDown)

Чтобы выйти, нужно нажать ещё раз. В статусной строке (внизу), появится сообщение "Copy mode aborted"


## Как включить прокрутку мышью:

`.screenrc` — файл с пользовательскими настройками screen, должен лежать в домашней директории.  
Изменения в .screenrc затрагивают только сессии, создаваемые после этого изменения.  
Заклинание, которое нужно туда поместить, чтобы работал скролл мышью:  
`termcapinfo xterm* ti@:te@`

`Ctrl-a ?` — показать справку.


## Ссылки:

[http://aperiodic.net/screen/start](http://aperiodic.net/screen/start) — разные туториалы, в пересечении в целом дают то, что указано здесь

[http://www.gnu.org/software/screen/manual/screen.html](http://www.gnu.org/software/screen/manual/screen.html) — официальное руководство. Для обучения не очень годится, можно использовать как справочный материал. Всё на одной html-странице, так что удобно искать нужное по ключевым словам.

В поисковых запросах для увеличения релевантности лучше писать "gnu screen" вместо "screen".
