# Выпускаем опасную задачу

Статус документа: дорабатывается, но пользоваться уже можно. 

Вопросы пишите lena-san@

## Теория, мотивация { #theory }

Про задачу стало понятно, что в ней делаются опасные изменения.  
Как выпускать задачу в продакшен, чтобы получить поменьше проблем? 

Регламент применим и к фронтовым, и к бекендным задачам. 

## Общий порядок { #general-order }

1. Подготовиться до релиза
2. Сделать релиз правильно
3. Сделать что надо после релиза

По умолчанию ответственный за все &mdash; разработчик задачи.

### Подготовиться до релиза { #pre-release }

1. Собраться, чтобы обговорить задачу.  
Состав (полезно учесть: [кто в чем специалист](../../reference/who-knows.md)): 
   - кто-нибудь из бекенда
   - кто-нибудь из фронтенда (если задача фронтовая или в java-web)  
   - кто-нибудь из тестирования (спросить у sudar@, кого правильно звать)
   - кто-нибудь из app-duty  
2. На встрече проговорить:
   - что поменялось в задаче
   - чего опасаемся
   - в частности, увеличивается ли нагрузка
   - как стоит тестировать
   - все ли что можно спрятано за фичами
   - какие показатели сможем смотреть после релиза (телеметрия)
   - какие варианты действий для предположительно вероятных проблем в продакшене
3. Записать в отдельный тикет:
   - какие показатели смотреть после релиза
   - варианты действий для вероятных проблем
4. Разметить продуктовый тикет (который будет в коммит-сообщении):
   - в заголовке написать метку `[DANGER]`
   - проставить тег `dangerous_task`

### Сделать релиз правильно { #release }

1. По возможности сделать релиз маленьким, "из одной этой задачи"
2. В названии релизного тикета написать `DANGER` или восклицательные знаки
3. Когда релиз начнет тестироваться, написать заинтересованным:
   - в админский чат, что вот этот релиз будет опасный, и что телеметрия и планы B, C, D в таком-то тикете (п.3 из дорелизной подготовки)
   - написать в Тревожный чат "JFYI: скоро будет выкладываться такая-то опасная задача, если есть вопросы -- задавайте пожалуйста в личке. cc @nooneqwerty @YuliyaYarchuk"

{% note warning "Минимизируй сообщения в Тревожном чате" %}

Тревожный чат -- для объявлений о проблемах, не для штатной переписки.  
Поэтому устраивать обсуждение задачи в Тревожном чате не надо.  
Если появляются вопросы &mdash; переходите в личку, в чат задачи, новый чат и т.п.

{% endnote %}

### После релиза { #post-release }

1. Смотреть на телеметрию из тикета
2. Если в первые сутки после релиза в продакшене обнаруживается функциональная проблема &mdash; звать на всякий случай разработчика опасной задачи


## Частные случаи, особенности { #special-cases }

TBD

## Ссылки { #links }

- [Кто в чем специалист в Директе](../../reference/who-knows.md)
- TODO: выборка опасных задач по тегу
