# Разработка документации на ppcdev

**Детальность инструкции:** высокая. 

**Для кого:** в основном для тестировщков, которые работают на Windows. Заниматься настройкой и поддержкой сборки на Windows не хотим, рекомендуем пользоваться ppcdev-ами.
Но вообще для всех желающих, кому почему-либо не нравится собирать документацию локально.

Описанный здесь вариант — протестированный, но не единственно возможный. 
Если ты знаешь, как работает селективный чекаут, `ya make`, `arc` и хочешь работать с документацией на ppcdev по-другому — пожалуйста, делай как нравится.

Если не указано иное, все делаем на ppcdev. 

## Штатный цикл разработки (регулярно) { #write-docs }

Предполагается, что инструменты и рабочая копия уже подготовлены по [инструкции ниже](#prepare).

1. Перейти в каталог `arcadia` на "документационной" бете:  
`cd /var/www/beta.<login>.NNNNN`  
Можно перейти в какой-нибудь внутренний каталог, если удобно
2. Обновить рабочую копию:  
`direct-mk svn-up-docs`
3. Поредактировать файлы:  
`vim arcadia/direct/docs/...`
4. Собрать документацию:  
`direct-mk build-docs`
5. Запустить просмотр:  
`direct-mk serve-docs`
6. Посмотреть в браузере `http://NNNNN.beta1.direct.yandex.ru` (`serve-docs` написал точный url)  
Если редиректит на https: включить инкогнито или пойти на .com.tr
7. Остановить просмор: `Ctrl-C`
8. Если надо еще что-то исправить: goto 3.
9. Если добавлял новые файлы: `svn add direct/docs/...`
10. Проверить изменения (команда без пробела, это наша функция на ppcdev): `svndiff`
11. Закоммитить: `commit`
12. Обновиться (сокращенный вариант, только чтобы выровнять ревизию с репозиторием):  
`svn up direct/docs`

Если нужны примеры разметки: <https://docs.yandex-team.ru/docstools/examples>

## Конец регулярной и начало одноразовой инструкции

{% note warning "Инструкции ниже для регулярной работы не требуется" %}

Она нужна примерно один раз, чтобы настроить инструменты и сделать рабочую копию с документацией.

{% endnote %}

## Подготовка инструментов и рабочей копии (однократно) { #prepare }

### Скачай программу ya

**Цель этого пункта: на ppcdev для тебя работает утилита ya.**

Сделать один раз на каждом ppcdev, где хочешь собирать документацию. 

Проверь, доступна ли программа ya. Запусти: 
```sh
type ya
```
Если пишет `ya is ...` — уже все хорошо, переходи к следующему пункту.

Если пишет `ya not found` — продолжай. 

Если `ya is aliased to ...` — скачивать `ya` не обязательно, но надо добавить каталог, в котором она лежит, в `$PATH`.
Будем дергать `ya` из `direct-mk`, алиасы не сработают. 

Сделай:
```sh
mkdir -p ~/bin
cd ~/bin
svn export svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/ya
ls ya
```

Если последний `ls` пишет, что не находит файл — это проблема, зови на помощь. 

Проверь, попадает ли `ya` в `$PATH`:

```sh
cd ~
type ya
```

Если пишет `ya is ...` — уже все хорошо, переходи к следующему пункту. 

Если пишет `ya not found` — продолжай. 

Сделай:
```sh
echo 'export PATH=~/bin:$PATH' >> ~/.bashrc
source ~/.bashrc
```

Проверь, что ya теперь находится:
```sh
type ya
```

Если пишет `ya is ...` — все хорошо, переходи к следующему пункту. 

Если пишет `ya not found` — это проблема, зови на помощь.


### Зачекаути рабочую копию 

**Цель этого пункта: у тебя есть все нужные файлы, чтобы собрать документацию.**

Выбери номер беты, которую займешь под документацию:
```sh
cd /var/www
direct-create-beta --get-port-only
```

Вторая команда должна вывести свободный номер для твоей беты, его будем обозначать NNNNN.

{% note info "Если пишет `no free ports available for <login>`" %}

Справка по резервированию портов: [здесь](../../dev/betas/betas.md#beta-ports).  
Если не работает — зови на помощь.

{% endnote %}


Аккуратно составь название каталога: ```beta.<login>.NNNNN```. 

Создай каталог:
```sh
mkdir beta.<login>.NNNNN
```

Сделай `ls`. Каталог NNNNN должен быть похож на все остальные каталоги бет. 
Если видишь что-нибудь странное, непонятное — зови на помощь. 

Перейди в каталог:
```sh
cd beta.<login>.NNNNN
```

Зачекаути нужные файлы:
```sh
direct-mk checkout-docs
```

### Посмотри на файлы документации

```sh
tree arcadia/direct/docs
```

Что тут к чему:

`toc.yaml` — оглавление. В готовой документации находится слева.
Каждую новую страницу надо руками вписать в нужное место оглавления. 

Файлы с расширением `.md` — страницы документации. 


### Отредактируй что хочешь

Для тестирования инструментов этот пункт можно пропустить. 

TODO: рекомендации, как это удобнее всего делать. Может быть, монтировать и пользоваться локальными редакторами.


### Запусти сборку документации

Запусти:
```sh
direct-mk build-docs
```

Если это первый запуск, будет работать пару минут. Повторные запуски будут быстрее. 

Если закончилось с угрожающими сообщениями — зови на помощь. 


### Посмотри на готовую документацию

Запусти:
```sh
direct-mk serve-docs
```

Эта команда выведет url, по которому можно смотреть документацию в браузере 
(url как у беты: http://NNNNN.betaN.direct.yandex.ru).

Если все прошло как надо — вместо беты будет видна документация. 

Частая проблема: редиректит на https и вместо доки — 502 ошибка. 
Против этого помогает (делать что-нибудь одно на выбор):

- включить в браузере режим инкогнито
- вместо .ru использовать другой домен, например .com.tr

Когда перестаешь смотреть документацию, прибей программу на ppcdev: `Ctrl-C`. 


### Сделай коммит

**Цель этого пункта: закоммитить сделанные изменения.** 

Если добавлял новые файлы — добавь их в svn:
```sh
svn add <файл1> <файл2> ...
```

Посмотри изменения, которые хочешь внести:

```sh
svn diff
```

Все должно выглядить ожидаемо: есть правки, которые ты вносил и нет правок, которые не вносил, все новые файлы присутствуют в диффе и нет лишних файлов.

Если есть что-то неожиданное — зови на помощь. 

Если все хорошо, делай коммит:
```sh
commit
```

Откроется vim c небольшим текстом.
Надо в самом верху файла добавить строчку со своим коммит-сообщением. 

Пример: "Документация: инструкция по тестированию релиза", "Документация: новые термины в глоссарии". 

Сохрани файл и выйди (`:wq`). Коммит отправится на сервер. 

Если svn ругается на конфликты и т.п. — зови на помощь. 


### Дождись, что документация выложится

Минут через 5-10 после коммита правки должны стать видны в документации: <https://docs.yandex-team.ru/direct-dev/>

Если прошло полчаса, час, а правок не видно — зови на помощь. 


### Готово!

Ура, теперь ты — контрибьютер документации Директа!
Жди [ачивку](../../reference/documentation/achievements.md).


## Ссылки { #links }

- Примеры разметки: <https://docs.yandex-team.ru/docstools/examples>

