## GrUT в докере

GrUT -- работающая поверх динамических таблиц YT специальная база данных, созданная с целью стать единой базой рекламы в Яндексе.
Запустить эту базу локально не так просто, потому что она состоит из нескольких компонент: YT, orm и object_api.
Для удобства разработки в Директе был подготовлен docker-образ, в котором эти компоненты собраны вместе и запускаются одной командой на виртуальной машине или на ноутбуке.

## Ручной запуск контейнера

{% note warning %}

Следует заметить, что локальный запуск будет работать на Linux-ноутбуках и Linux-виртуальных машинах, а также на маках с процессором Intel.
На маках с процессором Apple M1 запустить контейнер локально, вероятно, не удастся.

{% endnote %}

Для того, чтобы запустить GrUT в докере, достаточно выполнить команду

```bash
docker run -ti --rm -p 1310:1310 -p 80:80 registry.yandex.net/direct/grut_local:<tag>
```

где tag -- номер версии образа, который хранится в файле

[direct/libs/test-grut/src/main/resources/ru/yandex/direct/test/grut/grut_local_docker_image.txt](https://a.yandex-team.ru/arc_vcs/direct/libs/test-grut/src/main/resources/ru/yandex/direct/test/grut/grut_local_docker_image.txt)

После того, как контейнер запустится и выполнится инициализация таблиц и очередей, контейнер станет healthy, и в него можно будет выполнять запросы в его object_api, который слушает на 1310 порту.

Или можно посмотреть клиентом yt, какие данные лежат в таблицах

```sh
yt --proxy localhost:80 select-rows "* from [//grut/db/campaigns_v2]" --format=json
```

## Использование в юнит-тестах Директа

Некоторые наборы юнит-тестов в Директе используют GrUT в докере. По умолчанию на Linux-ноутбуках и на ноутбуках Apple с процессором Intel юнит-тесты будут автоматически запускать докер-контейнер
 (аналогично тому, как это работает с MySql и Ydb в докере).

Если же у вас Apple M1 или же Apple Intel, но нет лицензии на Docker Desktop, то есть второй вариант: запуск юнит-тестов с докер-демоном, запущенным удалённо на Linux-виртуальной машине.

Для того, чтобы это сделать, нужно

1. Подготовить виртуальную машину (например, в [своей персональной квоте QYP](https://clubs.at.yandex-team.ru/infra-cloud/294) на базе образа Ubuntu Xenial)
   - установить на ней docker по [инструкции](https://docs.docker.com/engine/install/ubuntu/)  
   - авторизоваться в yandex docker registry по [инструкции](https://wiki.yandex-team.ru/docker-registry/#authorization)

2. Установить для запуска тестов переменную окружения `DOCKER_HOST=ssh://<user>@<host>`

   где  
   user -- имя вашего пользователя  
   host -- fqdn вашей виртуальной машины  

И после этого запускать тесты. Теперь все контейнеры будут запускаться на удалённой виртуальной машине.

{% note tip %}

Этот вариант хорош ещё и тем, что запущенные контейнеры не будут нагружать ноутбук.

{% endnote %}

## Пересборка докер-образа

Если вы обновили protobuf-описания в груте, то чтобы эти изменения подцепились в юнит-тестах, докер-образ нужно пересобрать.  
Для этого нужна подготовленная виртуалка с установленным docker и arc (или svn).  
Ещё нужно залогиниться в яндексовом docker registry по [инструкции](https://wiki.yandex-team.ru/docker-registry/#authorization)  
Для пересборки нужно запустить скрипт `direct/bin/rebuild_grut_local.sh`  
Он соберёт из рабочей копии всё что нужно, сформирует новый образ, запушит его в яндексовый registry и обновит файл `grut_local_docker_image.txt` в рабочей копии.  
Далее остаётся лишь закоммитить этот файлик в транк.  
Перед коммитом стоит проверить работоспособность полученного образа командой из раздела "Ручной запуск контейнера".  

## Проблемы

При возникновении проблем можно писать Игорю [elwood@](https://staff.yandex-team.ru/elwood) или в чатик GrUT.

Если тесты падают с ошибкой поднятия контейнера в духе `endpoint with name grut_local already exists in network bridge` помогает перезапуск докера на хосте.
