# Добавление секретов в конфигурацию приложений

Приложениям нужно откуда-то брать пароль, токены или другие секреты. Добавлять их в `*.conf` файлы напрямую - небезопасно,
поэтому в конфигурационные файлы добавляется только ссылка на ресурс, откуда можно будет взять секрет во время работы приложения.
А сам ресурс привозится на машину специально обученными роботами. Для добавления нового секрета нужно сделать следующее:

## Настройка деплоя секретов { #deploy-secrets }

### Для продакшена и тестовой среды { #prod-ts }

1. Определитесь с именем файла для секрета. Традиционно все файлы с секретами лежат в папке `/etc/direct-tokens` на ppcdev'ах, в тестовых и боевых средах, и в папке `~/.direct-tokens/` на локальной машине.
Можно сходить туда и посмотреть, как принято именовать файлы с секретами.
2. Попросите [дежурных](https://abc.yandex-team.ru/services/direct-app-duty/duty) завести секрет в [Секретнице](https://yav.yandex-team.ru), в котором будет храниться содержимое нужного нам секрета.
Пароль от базы, секрет tvm-приложения или OAUTH-токен от робота, например. Возьмите у дежурных идентификатор сохраненного секрета и имя ключа.

   {% note warning "Осторожнее с секретами" %}

   Постарайтесь не сохранять секрет на [paste](https://paste.yandex-team.ru/), в [трекер](https://st.yandex-team.ru) или другими подобными способами.
   Для передачи секрета дежурным, попросите их предоставить вам временный доступ на запись секрета в секретницу, а затем отозвать его.

   {% endnote %}

3. Подумайте, для каких приложений Директа может потребоваться чтение секрета, посмотрите, на каких стейджах находятся эти приложения в деплое, в [в продакшене](https://deploy.yandex-team.ru/projects/direct-production) и [на тестовой среде](https://deploy.yandex-team.ru/projects/direct-np).
4. Напишите тикет, в котором попросите добавить в спецификацию нужных стейджей доставку содержимого секрета в указанный файл. [Пример тикета](https://st.yandex-team.ru/DIRECT-157900).
5. Попросите [дежурных](https://abc.yandex-team.ru/services/direct-app-duty/duty) выполнить то, что написано в тикете.

### Для ppcdev's

1. Создайте отдельный тикет ([пример](https://st.yandex-team.ru/DIRECT-158403)), в котором закоммитьте нужные изменения файла [yav-deploy/direct-testing.conf](https://a.yandex-team.ru/arc_vcs/direct/packages/secrets/yandex-dau-secrets-direct-test/etc/yandex/yav-deploy/direct-testing.conf?from_pr=2182004&rev=r8900622):
   - Добавьте в файл новый блок из трех строк по образцу:
     ```
      [$file_name]
     owner = ppc:ppc
     /etc/direct-tokens/$file_name:0444 = $sec-id[$key]
     ```
     где `$file_name` - имя файла из пункта 1, `$sec-id` и `$key`- идентификатор секрета и имя ключа, полученные от дежурных в пункте 2 [предыдущей секции](#prod-ts).
     <br>
     Должно получиться, например, вот так:
     ```
     [yc_robot-dir-log-viewer]
     owner = ppc:ppc
     /etc/direct-tokens/yc_robot-dir-log-viewer:0444 = sec-01fndzdp8894q1g1fn8dz9h676[Oauth]
     ```
   - Сделайте пулл-реквест с поправленным файлом, пройдите ревью и дождитесь мерджа в `trunk`.
2. На ppcdev [соберите пакет](how-to-package.md#sandbox-ya-package) `yandex-dau-secrets-direct-test`.
3. Двиньте пакет в тестинг командой `beta-update dmove_testing yandex-dau-secrets-direct-test=$version -r dt`, где `$version` - номер ревизии, который вы указывали при сборке пакета на предыдущем шаге
4. Создайте тикет на выкладку пакета `yandex-dau-secrets-direct-test=$version` на ppcdev's, и разложите пакет командой `beta-update --ppcdev-all yandex-dau-secrets-direct-test=$version`. Лог команды запишите в комментарии к тикету ([пример тикета](https://st.yandex-team.ru/DIRECT-158403)). Если не получилось сделать самостоятельно, то попросите дежурных помочь.

## Настройка приложения для работы с секретом

### Настрока конфигурационных файлов

Если секрет нужен только одному приложению, то секции со ссылками на ресурсы с секретами нужно создавать в его конфигурационных файлах, `app-$environment.conf`.
Если секрет нужен многим приложениям, может быть имеет смысл создать секции в общих конфигурационных файлах [common-\$environment.conf](https://a.yandex-team.ru/arc_vcs/direct/libs-internal/config/src/main/resources),
где `$environent` - тип окружения.
<br>
Далее `*` будет означать либо `app`, либо `common` в зависимости от выбранного варианта.

#### Для секретов от TVM-приложения

1. Создайте в конфигурационном файле `*-production.conf` секцию
    ```yaml
    tvm {
      enabled: true
      app_id: $app_id
      secret: "file:///etc/direct-tokens/$file_name"
    }
    ```
   указав вместо `$app_id` идентификатор tvm-приложения и вместо `$file_name` имя файла с секретом.
2. Создайте в конфигурационном файле `*-db_testing.conf` секцию
    ```yaml
    tvm: {
      enabled: false
    }
    ```
3. Создайте в конфигурационном файле `*-development.conf` секцию
    ```yaml
    tvm {
      secret: "file://~/.direct-tokens/$file_name"
    }
    ```
   Указав вместо `$file_name` имя файла с секретом.
4. Попросите дежурных добавить секрет в секреты для локальной работы с TVM.
5. [Скачайте новые секреты](back-first-steps.md#download-tvm-secrets) для локальной работы с TVM.

#### Для прочих секретов

1. Создайте для секрета в конфигурационном файле `*-production.conf` секцию вида
    ```yaml
    $secret_section {
      enabled: true
      secret: "file:///etc/direct-tokens/$file_name"
    }
    ```
   где `$secret_section` - имя секции с секретом, а `$file_name` - имя файла с секретом. Секция `enabled` нужна для
   возможности отключения чтения секрета в средах для юнит-тестов, где читать или следить за изменениями файла с секретом будет невозможно.
2. Создайте в конфигурационном файле `*-db_testing.conf` секцию
    ```yaml
    $secret_section: {
      enabled: false
    }
    ```
    где `$secret_section` - имя секции с секретом
3. Создайте в конфигурационном файле `*-development.conf` секцию
    ```yaml
    $secret_section: {
      secret: "file://~/.direct-tokens/$file_name"
    }
    ```
   где `$secret_section` - имя секции с секретом, а `$file_name` - имя файла с секретом.
4. Если это приложение `jobs`, то добавьте в метод [JobsConfigurationTest.tuneConf()](https://a.yandex-team.ru/arc_vcs/direct/jobs/src/test-configuration/java/ru/yandex/direct/jobs/configuration/JobsConfigurationTest.java?rev=r8884459#L48) строку
   ```java
   System.setProperty("$secret_section.enabled", "false");
   ```
   где где `$secret_section` - имя секции с секретом.
   Если вы хотите, чтобы сервис все-таки поднимался в юнит-тестах с каким-то фейковым значением секрета, вместо строки, указанной выше, добавьте строку
   ```java
   System.setProperty("$secret_section.secret", "memory://$fake_value);
   ```
   где где `$secret_section` - имя секции с секретом, а `$fake_value` - требуемое фейковое значение секрета.
   <br>
5. Для приложения `java-web` похожая конструкция находится в файле [test_web_run.py](https://a.yandex-team.ru/arc_vcs/direct/web/ut-run/test_web_run.py?rev=r8789350#L39), а для приложения `java-api5` в файле [test_api5_run.py](https://a.yandex-team.ru/arc_vcs/direct/api5/ut-run/test_api5_run.py?rev=r8789350#L42)

### Код чтения секретов

Несколько советов по использованию секретов в Spring-конфигурации:

- Уважайте `enabled: false` в conf-файлах. Можно вытащить чтение секрета из конструктора клиента в отдельный метод (и пропускать его вызов) или создавать stub-реализацию бина.
- Подумайте, насколько для всего приложения критично, если секрет будет отсутствовать: будет ли уместно упасть на чтении секрета в конфиграции при старте приложения,особенно в девелоперском окружении? Или лучшим способом будет отдавать Runtime ошибки в тот момент, когда секрет нужно использовать?
<br>
Вот тут можно посмотреть [пример создания бина](https://a.yandex-team.ru/arc_vcs/direct/jobs/src/main/java/ru/yandex/direct/jobs/configuration/MySqlSlowQueryLogsConfiguration.java?rev=r8906726#L45)
в зависимости от окружения и настроек серета.

#### Если требуется только чтение секрета

В конфигурации приложения поднимайте бин, возвращающий содержимое секрета, с учетом указанных выше советов.

#### Если требуется чтение секрета и реакция на его изменение

В этом случае нужно создать сервис, который будет читать секрет из файла, и предпринимать какие-то действия, если содержимое файла с секретом изменится.

1. Создайте в [direct/libs-internal](https://a.yandex-team.ru/arc_vcs/direct/libs-internal) библиотеку, внутри которой реализуйте сервис, следящий за файлом с секретом и предпринимающий нужные действия при его изменении.
   Примеры таких библиотек есть для [tvm](https://a.yandex-team.ru/arc_vcs/direct/libs-internal/tvm), и для [cloud-iam](https://a.yandex-team.ru/arc_vcs/direct/libs-internal/cloud-iam-service).
   Сделайте пулл-реквест с кодом новой библиотеки, пройдите ревью и дождитесь мерджа в `trunk`.
2. В приложении, где требуется новый сервис, пропишите зависимость на эту библиотеку в `ya.make` файле и в терминале выполните команду `ya-idea` из папки `$ARCADIA_ROOT/direct`, где `$ARCADIA_ROOT` - корень монтирования репозитория Аркадии.
3. В конфигурации приложения поднимайте бин с сервисом, с учетом указанных выше советов.
