# Как написать эксплуатационную документацию по джобе

## Что это такое?

Эксплуатационная докуменатация по джобе призвана помочь разобраться:
- что делает джоба;
- какая именно функциональность сломалась, когда загорелся мониторинг, и как это видят пользователи;
- как наблюдать за её состоянием и как скорректировать её работу;
- какие могут быть причины поломки.

Эксплуатационная документация не имеет цели дать исчерпывающее представление об алгоритме работы джобы.

## Общие рекомендации к написанию

Сделайте документацию простой, чтобы дежурный мог быстро сориентироваться. Если джоба заслуживает документации по разработке, лучше написать её в соответствующем разделе, а здесь оставить ссылку.

Используйте точные формулировки. Например, формулировка "джоба формирует отчет в excel..." точнее, чем "джоба показывает статистику...".

Указывайте технические имена сущностей, такие как тип кампании или имя ppc-property, с помощью которой можно регулировать работу джобы.

## Шаблон документации

Шаблон в виде md-разметки в Аркануме: [Template.md](https://a.yandex-team.ru/arc/trunk/arcadia/direct/docs/reference/jobs/list/Template.md).

**Продукт/подсистема**

Желательно отвечать на языке, понятном аудитории, не участвовавшей в разработке данного продукта или подсистемы.

Например, описание вида "cpm-видео в охватных" будет понятно только тем, кто понимает что такое "охватные" и "cpm-видео". Лучше указать названия кампании и группы в интерфейсе и в базе: "Группа видеообъявлений (`phrases.adgroup_type='cpm_video'`) в медийной кампании (`campaigns.type='cpm_banner'`)"


**Роль в работе продукта/подсистемы**

Здесь ожидается увидеть короткий и ёмкий комментарий о том, что джоба делает для функционирования вышеуказанного продукта или подсистемы.

Например, описание вида "Джоба забирает свежие данные из Партнерского Интерфейса" малоинформативно, в нем не указано какие именно данные и какое значение они имеют для Директа.


**Датафлоу**

Откуда джоба берет данные, куда перекладывает, с какими системами взаимодействует. Этот пункт желательно оформлять с кликабельными ссылками. Воспринимать последовательность действий удобнее в виде списка.


**Способы наблюдения за текущим состоянием**

Список способов наблюдения (логи, графики, джагглерные проверки, ppc-property, sql/yql-запросы), по возможности с кликабельными ссылками.


**Какая функциональность пострадает от отказа джобы**

Что перестанет работать. Укажите, насколько это критично или насколько массовым будет отказ.


**Как пользователи (или команда) заметят проблему и через какое время**

Здесь имеется в виду, как они увидят это во взаимодействии с системой, как почувствуют на себе. Мониторинги не в счёт.

Например, при поломке приёма вердиктов от модерации пользователи будут видеть, что их объекты долго находятся в статусе "На модерации". Или, если сломается джоба ведения тикетов по фичам, команда не будет видеть изменения в их фичах и в моменте этого не заметит, однако кто-то может пропустить важное событие.


**Контакты разработчиков и менеджеров**

Укажите в виде списка ссылок на staff. Так же можно указать релевантных людей из смежных команд.


**Желательное время исправления в случае поломки**

За какое время стоит починить джобу, чтобы не нарушить пользовательский опыт.


**Способы регулирования работы джобы**

Ppc-property, параметры конфигурации, константы в коде. Для каждого элемента помимо описания, что он делает, укажите, в каком случае он может пригодиться. Так же можно описать стандартные способы исправления последствий отказа джобы, такие как ваншоты, запросы в YT/MySQL, однострочники. Так же по возможности указывайте ссылки.


**Известные причины поломок**

Исторические знания.


**Дополнительно: тонкости и подводные камни**

Любая полезная информация в свободной форме. Например, тикет на доработку, или чего точно не нужно делать.
