# Пропуск "плохих" объектов в ESS-процессоре

Иногда в ESS-процессоры приходят объекты, состояние которых процессор переварить не может. Соотвествующий LB-топик перестает разбираться, данные в нем начинают копиться, мониторинги звенят. Приближается апокалипсис. Такое было не раз и не два, для примера возьмем вот этот [инцидент](https://st.yandex-team.ru/DIRECTINCIDENTS-620).

Для победы над тёмными силами дежурные должны быстро выяснить причину проблемы, найти проблемные объекты и своими силами, либо с помощью специально обученного разработчика (которого еще нужно найти), запилить быстрофикс и выкатить его в прод. Но теперь в некоторых случаях можно немного упростить себе жизнь, если воспользоваться новым внутренним инструментом под кодовым названием "ESS-blacklist".

## Инструкция app-duty

1. После того, как проблемные объекты выявлены, открываем [инструмент для добавления фильтров](https://direct.yandex.ru/internal_tools/#ess_blacklist_add_tool),
    выбираем из выпадающего списка пострадавший процессор и добавляем фильтры для проблемных объектов.
    Для нашего эталонного инцидента достаточно одного фильтра, вот такого:
    ```json
    {"banner_id": "9333003788"}
    ```
    Теперь процессор будет игнорировать все объекты, у которых поле `banner_id` имеет значение `9333003788`,
    и ESS-цепочка начнет работать (если, конечно, не обнаружатся новые проблемные объекты).
    Можно в относительно спокойном режиме писать фикс. 
    При добавлении можно сразу задавать несколько фильтров для одного процессора, вводя их через запятую.

1. Когда фикс написан, проверен и выложен в продакшен, нужно удалить ранее добавленные фильтры.
Для этого есть [инструмент для удаления фильтров](https://direct.yandex.ru/internal_tools/#ess_blacklist_remove_tool).
Обратите внимание, что для удаления фильтра не требуется вписывать его значение,
а нужно найти в списке ненужный более фильтр и вставить в поле "Список ID ранее добавленных шаблонов" его ID.
Можно сразу несколько, через запятую.

1. Все "пропущенные" объекты логгируются, найти их можно по сообщению `skipped_by_logic_processor` в messages-логе.
Пример для [продакшена](https://direct.yandex.ru/logviewer/short/KyPBMFwF3YADv5), 
для [ТС](https://test-direct.yandex.ru/logviewer/short/apHhz9VQ3XBNo9).
В некоторых случаях для устранения последствий сбоя достаточно всего лишь переотправить "пропущенные" объекты (возможно, лишь некоторые из них) в ESS-цепочку.
И для этого у нас есть [специальный инструмент](https://direct.yandex.ru/internal_tools/#sending_objects_to_ess).
Вся информация, необходимая для заполнения полей (номер шарда, название logic-processor'а, объекты), есть в логе, пример которого был приведен выше.

## Как работает фильтрация

Объект считается подходящим под фильтр, если значения полей, прописанных в фильтре равны (по `Objects.equals()`) значениям соответствующих полей объекта.
При этом значения других полей объекта (тех, которые не прописаны в фильтре) не имеют значения.
Например, если бы в примере выше мы хотели "пропустить" все баннеры группы, нужно было бы добавить фильтр
```json
{"adgroup_id":"4635952818"}
```
