# Перехваты трейсинга
Это механизм, позволяющий осуществить ряд действий перед выполнением (в момент создания `TraceProfile`) профилируемого java-кода.

Доступные действия:
- сделать паузу (sleep)
- бросить TraceInterceptionActionException (Runtime исключение) с произвольным текстом
- попробовать взять семафор (отпустится при разрушении TraceProfile-объекта).

Для чего это может быть полезно — защититься от исчерпания всех тредов какой-то одной работой (например походом во внешее API):
- используя семафор
- "заглушив" полностью код хождения вовне, сразу кидая исключение

## Как это работает
Правила определяются условием на значения `trace.service`, `trace.method`, `profile.func`, `profile.tags`

Приложение в фоне подгружает из таблички в `ppcdict` правила перехватов.
При создании TraceProfile, выполняется поиск среди загруженных наиболее подходящего правила.

{% cut "Комбинации service / method / func / tags проверяются в следующем порядке:" %}

service | method | func | tags
 :---: | :---: | :---: | :---:
⨯      | ⨯      | ⨯      | ⨯
⨯      | ⨯      | ⨯      | &nbsp;
&nbsp; | ⨯      | ⨯      | ⨯
&nbsp; | ⨯      | ⨯      | &nbsp;
⨯      | &nbsp; | ⨯      | ⨯
⨯      | &nbsp; | ⨯      | &nbsp;
&nbsp; | &nbsp; | ⨯      | ⨯
&nbsp; | &nbsp; | ⨯      | &nbsp;
⨯      | ⨯      | &nbsp; | ⨯
⨯      | ⨯      | &nbsp; | &nbsp;
&nbsp; | ⨯      | &nbsp; | ⨯
&nbsp; | ⨯      | &nbsp; | &nbsp;
⨯      | &nbsp; | &nbsp; | ⨯
⨯      | &nbsp; | &nbsp; | &nbsp;
&nbsp; | &nbsp; | &nbsp; | ⨯

⨯ означает, что в перехвате задано условие на это поле
Будет использовано первое по порядку правило, в котором все отмеченные значения **точно совпали** с TraceProfile.

Этот порядок задан в [коде](https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal/traceinterception/src/main/java/ru/yandex/direct/traceinterception/entity/traceinterception/service/TraceInterceptionsService.java#L32).

Примеры:
- будет использовано первое правило из двух (точное совпадение по всем условиям):
   - `service=direct.web, method=test, func=db:read, tags=ppc:1`
   - `func=db:read`
- будет использовано первое правило (во втором правиле больше условий, но по порядку проверки оно идет ниже):
   - `func=metrika_int_api:getUsersCountersNum`
   - `service=direct.web, method=test`

{% endcut %}

Если подходящее правило нашлось, перед выполнением кода (обернутого в трейсинг) будет выполнен:
1. sleep на указанное в правиле число миллисекунд
1. брошено TraceInterceptionActionException, если в правиле указан текст исключения
1. взят семафор, если в правиле указано "количество разрешений семафора"

Фактически, sleep может быть использован вместе с исключением или семафором.

### про семафоры
{% note info "Это семафоры внутри JVM" %}

Они не учитывают другие процессы на других хостах.
В каждом учет ведется независимо.

{% endnote %}

Для каждого активного семафор в Solomon отправляются (их можно найти в `service=java-monitoring` по метке `trace_interception_semaphore`) три метрики:
- used — сколько сейчас "захвачено" разрешений семафора
- limit — максимальное количество разрешений семафора
- errors — количество ошибок взятия семафора (штук за 15 секунд)

О настройке семафоров чуть подробнее, за неё отвечают два параметра:
- **Количество разрешений семафора** — (обязательное) значение семафора (сколько потоков могут захватить его одновременно)
- **Ключ семафора** — (опциональное) человекопонятный айдишник семафора (используйте символы `[a-z_]+`)

Для того, чтобы семафор в правиле заработал — достаточно указать количество разрешений (ключ — необязательно), у каждого правила будет свой семафор.

Если указать ключ, то:
- на графиках утилизации семафора в метке trace_interception_semaphore будет указан именно он, а не id перехвата
- нескольких разных правил перехвата смогут использовать **один общий** семафор с этим ключем


## Как настроить
Для настройки во [внутренних инструментах](https://direct.yandex.ru/internal_tools/) сделаны следующие тулы:
- [Добавление правил перехвата](https://direct.yandex.ru/internal_tools/#create_trace_interceptions)
- [Редактирование действий правил перехвата](https://direct.yandex.ru/internal_tools/#edit_trace_interceptions_action)
- [Включение/выключение правил перехвата](https://direct.yandex.ru/internal_tools/#edit_trace_interceptions_status)
- [Удаление правил перехвата](https://direct.yandex.ru/internal_tools/#remove_trace_interceptions)

Условие срабатывания можно указатать только при добавлении нового правила, редактирование позволяет только изменить поведение перехвата.
