# Завести новое дежурство в ABC

Когда надо, а когда не надо заводить дежурство в ABC, в этой инструкции не обсуждаем.

## 1. "Управляющий дежурствами" { #duty-manager }

Запросить и получить для себя роль **Управляющий дежурствами**, если еще нет.

Вариант: завести дежурство руками кого-то, у кого **Управляющий дежурствами** уже есть.

## 2. Роль для участников дежурства  { #duty-scope-role }

Создать новую роль, которая показывает, кто участвует в дежурстве.

Название роли: **Участник дежурства <название дежурства>**.  
Примеры: _Участник дежурства по релизам perl_, _Участник ZBP-frontend_, _Участник ZBP-backend_ и т.п.  
Английское название в духе _Participant of DNA autotests duty_.

Как создать роль:

1. Пойти в сервис в ABC, в нашем случае [direct](https://abc.yandex-team.ru/services/direct/)
1. В шапке сервиса нажать плюс (как если бы хотели выдать роль), выбрать какого-нибудь сотрудника (лучше кого-то, кто будет участвовать в дежурстве, но это не обязательно)
1. В поле напротив имени (там может быть указана текущая роль сотрудника или заглушка "выберите роль") написать полностью название новой роли, нажать **Добавить новую роль**
1. Появится формочка. В ней написать английское название и выбрать функциональную группу: разработка/тестирование/администрирование
1. Нажать **Создать**, затем **Добавить**

## 3. Подтвердить роль { #approve-duty-scope-role }

Подтвердить роль, созданную в п.2 для сотрудника, которому там ее выдавали (=список дежурных будет непустой)

## 4. Роль для текущего дежурного { #duty-role }

Создать роль, которая будет выдаваться на время дежурства.

Название роли: **Дежурный по <название области>**.  
Примеры: _Дежурный по релизам web-dna_, _Дежурный по ZBP-frontend_.  
Английское название в духе _Perl releases duty_, _ZBP-backend duty_.  

{% note warning "Важно" %}

Функциональная группа &mdash; **Дежурство**

{% endnote %}

Процедура создания &mdash; как в п.2.

ABC ругнется, что роли из группы Дежурство выдаются только автоматом, но в этот момент роль создастся, а нам это и надо.

## 5. Открыть форму создания дежурства { #open-new-duty-form }

Пойти в [график дежурств сервиса](https://abc.yandex-team.ru/services/direct/duty/).  
Нажать **Настроить график дежурств** справа вверху  
Проскроллить вниз, нажать **Добавить дежурство**

## 6. Заполнить данные нового дежурства { #fill-new-duty-form }

Заполнить форму на новое дежурство:  
- **Код дежурства**: `direct_<коротко про дежурство по-английски>` (_`direct_zbp_duty`_, _`direct_releases_web_dna`_, _`direct_app_duty`_ и т.п.)  
- **Роль** и **роль на дежурстве** — роли из п.2 и п.4  
- **Длительность**: если дежурства по неделе, то 7 дней (не 5!)  
- **Начало дежурств**: если хочется внести историю, то можно указать дату в прошлом. Иначе ставь тот день, когда начнется первая дежурная смена

Галочки и другие параметры заполнить по собственному здравому смыслу.

## 7. Сохранить { #save }

Сохранить новое дежурство.

## 8. Довыдать роли { #request-and-approve-roles }

Запросить и подтвердить роль из п.2 всем, кто участвует в дежурстве.

## 🎉 Готово { #done }
Всё, новым дежурством можно пользоваться

## Бонус-трек — добавление нового дежурства в радар { #add-to-radar }
{% note tip "Нативная поддержка текущего дежурного в ABC" %}

Её пока нет, поэтому пользуемся своим велосипедом с [радаром](../glossary/glossary.md#radar).
Голосуй за [тикет ABC](https://st.yandex-team.ru/ABC-8540).

{% endnote %}

Это позволит видеть новое дежурство на странице со [списком всех дежурных](https://radar.qart.yandex-team.ru/release/directOnDuty.html),
давать ссылки на текущего дежурного вида `https://radar.qart.yandex-team.ru/radar-rest/onduty/redirect-to-duty-staff/<код дежурства>`
и ставить автоматом нового дежурного в QA релизных или регрессионных тикетов.

1. Открой для редактирования [enum Duty](https://github.yandex-team.ru/qa-irt/radar/blob/master/radar-service/src/main/java/ru/yandex/autotests/direct/radar/utils/duty/Duty.java#L11)
1. Напиши свою строчку по аналогии. Описание аргументов:
   1. код дежурства в радаре — он используется чтобы дать ссылку на дежурного
   1. источник дежурства — используй ABC: `DutyLoader::getCachedDutyFromAb`
   1. код дежурства в ABC — подставь код, который указал в [{#T}](#fill-new-duty-form)
   1. описание дежурства — отображается на страничке со списком всех дежурств
1. Закоммить
1. Обнови радар по [инструкции](jeri/radar-update.md)

## Полезные ссылки

- Сервис direct в ABC: <https://abc.yandex-team.ru/services/direct/>
- Дежурства в сервисе direct: <https://abc.yandex-team.ru/services/direct/duty/>
- [Справочник по дежурствам в Директе и соседних сервисах](../reference/duty.md)
- [Документация ABC про дежурства](https://wiki.yandex-team.ru/intranet/abc/features/duty/)
