# Молли — сканирование интерфейса на уязвимости

## Инструмент "Молли"

Ссылка на вики сервиса: [wiki.yandex-team.ru/product-security/molly/](https://wiki.yandex-team.ru/product-security/molly/)

Ссылка на интерфейс сервиса: [molly.yandex-team.ru](https://molly.yandex-team.ru/)

## Короткий FAQ

### Что это такое?

Это сервис от нашей Службы Безопасности, позволяющий сканировать веб-сервисы на уязвимости

### Когда использовать?

Если вы пилите какую-либо фичу, для которой есть отдельная страница в интерфейсе/есть значимые изменения в интерфейсе/появляются новые значительные элементы на странице интерфейса, то было бы хорошим кейсом воспользоваться данной тулзой

### Почему это не делает сам СИБ?

Вообще регулярные запуски в самом Молли силами СИБа (Служба Информационной Безопасности) по сервисам Яндекса есть. Но Молли не может исследовать весь наш интерфейс. Для того чтобы Молли попала в укромные уголки нашего сервиса, ее надо туда направить


## Что нужно для запуска

1. Дать честную авторизацию сервису Молли в нашем интерфейсе (логин и пароль)  
1. Направить на нужную страницу в интерфейсе (указать url с параметрами)


{% note info "Важно знать:" %}

Если указать просто домен, например test-direct.yandex.ru, то Молли обследует только те места, куда сможет залезть.
При этом она не сможет зайти и открыть даже редактирование кампании/группы или баннера.
Для того, чтобы она попала на нужную страницу, указывайте полный путь для этой страницы.
Например: _https://test-direct.yandex.ru/dna/campaigns-edit?campaigns-ids=42842357&ulogin=directrub1_

{% endnote %}


### Для запуска сканирования есть 2 основных пути

1. Через интерфейс самого сервиса Молли (простой, его зачастую будет достаточно)  
	- позволяет авторизоваться под реальным пользователем  
	- может перейти по определенному урлу и исследовать его

1. Создать таску через Сандбокс (чуть более сложный)  
	- все то же самое, только с более расширенным набором настроек


## Инструкция по запуску

### Способ 1 — через интерфейс Молли
_(простой способ)_

1. Откройте страницу управления [авторизацией](https://molly.yandex-team.ru/auth_profile)

1. Заполните необходимые поля:  
**Name** — название профиля  
**Username** — имя пользователя в Директе, под которым хотите, чтобы Молли авторизовалась  
**Password** — пароль  
**Passport Host** укажите `passport.yandex.ru`  
**Auth type** укажите `Password`   
Нажмите _Сохранить_.  

   {% cut "Скриншот с примером заполнения" %}
   
   ![screenshot](_assets/molly_auth_screenshot.png "Скриншот страницы авторизации  Molly")
   
   {% endcut %}

1. Перейдите на [главную страницу](https://molly.yandex-team.ru/) сервиса

1. Заполните необходимые поля:  
**ABC** — выберите `Директ`   
**URL** — сюда вставьте полный URL, который приведет на страницу, которую хотите исследовать  
**Scanner profile** —  выберите `Yandex`  
**Auth profile uid** — выберите профиль, который создали в первом пункте  
И нажмите Сканировать.  

   {% cut "Скриншот с заполненной формой" %}
   
   ![screenshot](_assets/molly_launch_screenshot.png "Скриншот заполненной формы на запуску Molly")
   
   {% endcut %}



### Способ 2 — запуск через Сандбокс
_(для продвинутых пользователей)_

{% note info "Перед настройкой необходимо:" %}

- получить OAuth token [тут](https://molly.yandex-team.ru/token), а затем положить его в санбоксе в vault с названием MOLLY_SANDBOX_TOKEN  
- создать [профиль авторизации](https://molly.yandex-team.ru/auth_profile), под которым молли будет логиниться в Директ

{% endnote %}

__Параметры задачи__ (значащие)

**Task type**: `MOLLY_RUN`  

**Target URL**: например `https://test-direct.yandex.ru/dna/campaigns-edit?campaigns-ids=42842357&ulogin=directrub1`

**Scan profile**: `Yandex`

**Authentication profile UID**: взять уид со [страницы](https://molly.yandex-team.ru/auth_profile) авторизации в молли

**Sandbox resource HTTP request samples format**: `SERP Sandbox (short)`


__Обоснование почему именно так__

* Молли сможет добраться до подобных страниц только вручную  
* Лучше скармливать сразу схему урл+путь+параметры, тогда молли обследует все, что найдет для этого пути  
* Параметры урла можно задавать в поле QueryString params, но тогда молли не выйдет за рамки этих параметров и покрытие будет меньше.  
Если захотите указывать все таки через это поле, то   
**Target URL**: `https://test-direct.yandex.ru/dna/campaigns-edit`  
**QueryString params**: `campaigns-ids=42842357&ulogin=directrub1`


## Разбор результатов:

{% note alert "Внимание!" %}

при любых сомнениях лучше обратиться за помощью к разработчику вашей задачи или к дежурному

{% endnote %}

1. Откройте страницу с отчетом   
	- если запускали через Молли, то прямо на месте запуска появится отчет  
	- в санбоксе ссылка на отчет в молли: `Link to resulting report(report)`  

1. Если в отчете __0__ обнаруженных уязвимостей или все обнаруженные уязвимости отмечены как "Ложное срабатывание", то __все замечательно__.  
_В противном случае идем дальше_

1. Проверьте, есть ли обнаруженная уязвимость среди заскипанных в предыдущем запуске релиза dna (запуски происходят автоматически каждый релиз), если обнаруженная неисправность есть среди заскипанных, то все хорошо и можно отдать дежурному, чтобы он вас провалидировал и скипнул ошибку.

1. Если все же неисправность новая, тем более с приоритетом normal и выше, поздравляю, вы нашли потенциальную проблему, несите ее вашему разработчику/дежурном(если это мастер).

   {% cut "Пример отчета с некоторыми комментариями" %}
   
   ![screenshot](_assets/molly_report_screenshot.png "Скриншот отчета Molly")
   
   {% endcut %}
