# Новая модерация в Директе (ESS-moderation)

{% note warning %}

Полезные ссылки:  
[Cсылка на тестовую админку модерации](https://modadvert-test.yandex-team.ru)  
[Продовая админка модерации](https://modadvert-test.yandex-team.ru)  
[Тестовая админка Толоки](https://sandbox.toloka.yandex.com)  
[Лупа на тесте](https://loupe-testing.yandex-team.ru/viewer?objectType=DIRECT_BANNER) - позволяет подробно рассмотреть информацию об объекте, в т.ч. данные модерации  

{% endnote %}

## Общая информация

### Статусы модерации
- ***ready*** - готов к отправке из Директа в Модерацию
- ***sending*** - в процессе отправки
- ***sent*** - отправлен
- ***yes*** - принят
- ***no*** - отклонен   
При создании и редактировании объявления ему выставляется статус ready, транспорт видит это событие и начинает отправлять объект на модерацию

### Транспорт в Модерацию
- это ESS-контуры на каждый тип отправляемого объекта, включаются они через настройку соответвующих пропертей
- два компонента:
  - роутер - слушает события в базе
  - процессор (живет в direct.jobs) отправляет объекты на модерацию и пишет лог ess-moderation

### Доступы
- ***Толока*** - за доступами можно обратиться к @matlash. После нужно зарегистрироваться как исполнитель, добавить логин в доверенных пользователей через аккаунт заказчика, после этого залогиниться под исполнителем. Если все хорошо, то должны появиться задания.
- ***Лупа*** - за доступами можно обратиться к @abogutskiy
- ***Админка модерации*** - запросить доступ в [IDM](https://idm.yandex-team.ru/user/ratyulenev/roles#rf=1,rf-role=uypTD7Pu#modadverttest/direct/add_verdict(fields:()),f-status=all,sort-by=-updated,f-is-expanded=true,f-role=modadverttest,rf-expanded=uypTD7Pu)
## Логи

### Стенды
- PROD-logviewer: https://direct.yandex.ru/logviewer
- TEST-logviewer: https://test-direct.yandex.ru/logviewer

### ***ess-moderation*** - лог отправляемых данных от/к модерации (находится в logviewer)
##### Как искать данные?
- ***cid*** - id кампании
- ***pid*** - id группы
- ***bid*** - id баннера
- ***action*** - request/response

##### На что смотреть?
- ***action*** - request/response
- ***data*** - полезные данные
  - ***type*** - тип банера
  - ***result*** - массив данных с результатами, где будет описан вердикт, список причин отклонения и флагов если они имеются.
  - ***minus_regions*** - список минус регионов
  - **workflow** - флоу модерации 3 вида:
    - ***common*** - ничего необычного, клиент сам отправил объект в модерацию
    - ***manual_only*** - это когда внутренняя роль в Директе, например support, переотправили в модерацию баннер с указанием, что он обязан попасть на ручную модерацию
    - ***auto_accept*** - это когда внутренняя роль в Директе, например support, переотправили в модерацию баннер с указанием, что он должен автоприняться


### ***binlog_rows_v2*** - лог изменения строк в БД (находится в logviewer)
##### Как искать данные?
 - В качестве фильтра выбираем ***table***, где указываем ***banners***
 - В ***primary_key*** указываем ***bid***(id баннера)


##### На что смотреть?
- поле ***service*** имя приложения которое обработало данные, примеры:
  - *direct.script* - перловые скрипты (старые скрипты)
  - *direct.jobs* - джавовые фоновые процессы (новый механизм)
  - *direct.web* - джавовый бэкенд, доступный через веб-интерфейс (новый механизм)
  - *direct.perl.web* - перловый бэкенд, доступный через web-интерфейс
- поле ***method*** - имя функции или фонового процесса или контроллера
- поле ***row*** - полезные данные

***Пример:***
1) Смотрим в лог и видим такую какую картину
  ![alt text](https://jing.yandex-team.ru/files/ratyulenev/2021-11-10T12:38:30Z.6c4becb.png "скрин")
direct.web использовал метод grid.addCpmAds с операцией INSERT и какими-то данными(row) - это значит что был создан cpm банер через web-интерфейс
2) Смотрим в лог и видим такую картину
 ![alt text](https://jing.yandex-team.ru/files/ratyulenev/2021-11-10T12:41:22Z.5804ee3.png "скрин")
Что новый джавовый скрипт banner.CpmBannerModerationEventsProcessor перевел баннер в статус "Отправляется в модерацию"

## Флоу тестирования (На ТС)
- Создаем кампанию
- Переходим https://test-direct.yandex.ru/internal_tools/#enable_ess_moderation
- Добавляем cid в список объектов с включенной ess-модерацией
___Т.к. на тестовых средах по умолчанию объекты только пишутся в лог, но в модерацию не отправляются, нужно изменить проперти, так чтобы объекты отправлялись в модерацию___.
- для каждого отправляемого в модерацию типа объекта есть 3 проперти:
  - ***disable_<type>_transport_old_moderation_perl*** - процент клиентов, отключенных в старом транспорте
  - ***enable_<type>_transport_new_moderation_java*** - процент клиентов, включенных в новом транспорт
  - ***restricted_<type>_transport_new_moderation*** -true/false, если true, то новый транспорт работает незаметно, не меняя статусы в базе
Где ***type*** это тип банера, например canvas, html5 и т.д.
- Отключаем старый транспорт для определенного типа банеров, для этого __disable*__ выставляем значение 100 (либо например disable = 5. теперь клиенты, у которых ClientID заканчивается на 00, 01, 02, 03, 04 будут обрабатываться только новым транспортом, т.е. можно в приницпе учесть id своего клиента и настроить не на всех)
- Включаем новый транспорт __enable*__ - выставляем значение в 100 либо на нужный процент
- Отключаем __restricted__ режим, т.е. устанавливаем значение false
- Ждем пару минут, т.к. значения пропертей применяются не сразу, а кэшируются на пару минут
- Создаем в тестовой кампании баннер
- Смотрим историю изменений в логвьюер, в binlog_rows_v2 - убеждаемсся что банер пошел нужным транспортом
- Смотрим в ess_moderation лог и убеждаемся что банер дошел до модерации
- Идем ищем созданный банер
- Кликаем на созданный банер
- Устанавливаем нужные вердикты и нажимаем применить
- Смотрим в ess_moderation лог и убеждаемся что вердикт ушел из модерации в директ
- Смотрим в binlog_rows_v2 - убеждаемся что вердикт на банер пошел нужным транспортом
- Еще можно посмотреть что записалось в таблицы

`select banners.* from banners join banners_performance using (bid) join perf_creatives using (creative_id) where bid = <bid> \G`   

`select perf_creatives.* from banners join banners_performance using (bid) join perf_creatives using (creative_id) where bid = <bid> \G`  

`select banners_performance.* from banners join banners_performance using (bid) join perf_creatives using (creative_id) where bid = <bid> \G`  

- Проверяем, что в директе отображается корректный вердикт.
---
- Если модерировать через Толоку, то нужно подождать пока банер доедет до Толоки, это происходит не сразу, а в течение 10-15 минут.
- В Толоке нужно будет пройти несколько опросов по банеру, соответствует он определнной тематике или нет, есть еще нюанс в том, что после прохождения одного опроса в зависимости от ответов может прилететь другой вопрос по этому-же банеру.
- Остальной флоу такой-же, нужно еще чекнуть вердикт в админке модерации и свериться с тем что было сделано в Толоке.


## Разная полезная и не очень информация
- Если не хочется, чтобы авто-модератор отклонял объекты во время тестирования, то можно вот в [этот](https://a.yandex-team.ru/arc_vcs/modadvert/bigmod/conf/yql/common/common_constants.sql?rev=2061366c5c916592dcd6b6336c69fb60b503a72d#L11) список добавить ID тестовой кампании. Все объекты из этих кампаний автомодератор автопринимает
- В случае копирования объектов вердикты копируются тоже, но при этом все равно посылаются в модерацию в асинхронном режиме (т.е. модерация имеет возможность поменять вердикт с задержкой)
- Основной поток ручных вердиктов модерации идет через Янг и Толоку
- Всего 5% объектов модерируется вручную, остальное - через автоматику и кластеризацию.
- Автоматика может изменить свое решение на одних данных, т.к. информация о внешнем мире вокруг нее могла измениться.
- У клиентов "Тира 0" и "Тир 1" работает автоакцепт объявлений, но банер все-равно попадает на ручную модерацию. Итоговый вердикт модератора главнее автоакцепта. 
