# Управление модерацией на своей бете

Рассмотрим на примере отправки на модерацию indoor баннера.<br/>
Отправка в модерацию объектов происходит после выполнения события, которое требует модерации.
Например, нажать кнопку "перемодерировать" на странице просмотра кампании.<br/>
Отправка на модерацию осуществляется процессорами ess.
Процессор — это обработчик конкретного типа заявки (напр. `indoor`, `outdoor` баннер или `outdoor` операторы).
Каждый процессор в коде помечен тегом `@EssConfig`, который связывает с процессором определенный ess-конфиг.

Чтобы протестировать на бете отправку конкретного типа объекта, напр. `indoor` баннера, нужно знать название
ess-конфига и выполнить действия из пункта [**Запуск на бете**](#run-on-beta).<br/>
События на модерацию могут приходить из разных источников, такие как `perl`, `java-web`, `java-api5`.
Важно понимать что тестировать и инициализировать на бете соответствующие сервисы.<br/>
Например, через `perl` выполняется переотправка баннера на модерацию (в октябре 2020 года часть ГО-баннеров уже
отправляется через ess, дальше будет больше, это нужно иметь в виду).
Через `java-web` выполняется изменение некоторых типов баннеров (`indoor`, `outdoor`) и новый интефейс.

## Запуск на бете {#run-on-beta}

Предполагается, что перловая бета уже создана (командой `direct-create-beta`) и все действия происходят в корне беты

#### Выставить специальный тег
```bash
beta-ctl set-from-json java_properties='{"tracing.tags.ess": "12029"}'
```

#### Инициализировать java:

Для полноценного тестирования (изменение содержимого группы, dna) через интерфейс на бете необходимо инициализировать
следующие сервисы:
```bash
direct-mk java-init -- -a ess_chain,jobs,web
```

Приложение `java-web` скачивается, компилируется и запускается.
По окончанию выполнения команды запросы из интерфейса Директа будут выполнятся через `java-web` на бете.<br/>
Инициализация приложений `ess_chain` и `jobs` происходит отлично от `web` или `api5`:<br/>
Скачивается код и происходит компиляция. Но само приложение НЕ запускается.<br/>
Запуск процесса отправки в модерацию описан ниже.<br/>
Иногда можно опускать инициализацию `java-web`, если проверяется только perl.

#### Перезапуск беты

`direct-mk beta-postupdate` — позволяет инициализировать тег в перле

#### Запустить процесс отправки заявок в модерацию

{% cut "1 способ: Сначала готовим данные к отправке в модерацию, затем отправляем через внутренний инструмент:" %}

Сначала готовим данные и отправляем в модерацию в интерфейсе.
Затем идем во внутренние инструменты и в разделе "Модерация" находим инструмент ["Отправить на модерацию"](https://8080.beta1.direct.yandex.ru/internal_tools/#send_to_ess_moderation).
Вводим `ess-tag`, длительность работы процесса и время изменения объектов
(изменения, сделанные раньше этого времени, будут проигнорированы) и жмем "Отправить".

{% endcut %}

{% cut "2 способ: Сначала готовим данные к отправке в модерацию, потом запускаем процесс вручную:" %}

Сначала готовим данные и отправляем в модерацию в интерфейсе.

Затем запускаем процесс отправки:<br/>
`direct-mk run_ess_chain -- --ess-config CpmIndoorBannerModerationConfig -t 60 --read-data-after "2020-07-16 15:00:00" --ess-tag 12029`<br/>
Процесс обработает только те изменения, которые сделаны примерно после указанного времени.
Если время выбрано достаточно точно, то нет необходимости запускать процесс на длительное время (параметр `t`),
обычно достаточно 1 минуты.

Значения параметров:

  * `-t` — время работы процесса в секундах
  * `--read-data-after` — отправлять только те объекты, которые изменились после указанного времени
  * `--ess-tag` — должен быть тот, который был указан при сборке беты

{% note info "Список ess-конфигов модерации:" %}

  - ContentPromotionBannerModerationConfig
  - CpmAudioBannerModerationConfig
  - CpmBannerModerationConfig
  - CpmIndoorBannerModerationConfig
  - CpmOutdoorBannerModerationConfig
  - и другие

Все возможные значения параметра `ess-config` можо узнать у разработчиков.

{% endnote %}

Можно указывать сразу несколько конфигов, вот так:
```bash
direct-mk run_ess_chain -- --ess-config CpmIndoorBannerModerationConfig CpmOutdoorBannerModerationConfig -t 60 --read-data-after "2020-07-16 15:00:00" --ess-tag 12029
```

Можно отправить сразу все типы объектов:
```bash
direct-mk run_ess_chain -- --ess-group moderation -t 60 --read-data-after "2020-07-16 15:00:00" --ess-tag 12029
````

Кроме moderation, есть еще группа `banner_moderation` — включает только то, что относится к баннерам
(сейчас почти все, что есть, относится к баннерам; не относится к ним только модерация `banner_pages` и
проверка доступности для `content_promotion`). В будущем могут появиться и другие.

{% endcut %}

{% cut "3 способ: Запускаем процесс руками и, пока он работает, отправляем данные на модерацию:" %}

`direct-mk run_ess_chain -- --ess-config CpmIndoorBannerModerationConfig -t 3000 --read-new-data --ess-tag 12029`<br>
Процесс будет обрабатывать только те изменения, которые сделаны примерно с момента старта процесса.
Поэтому в параметре `t` (время работы процесса в секундах) нужно указывать достаточно большое значение,
чтобы успеть создать/поменять объявления.

Значения параметров:

  * `--read-new-data` — читать ли запросы с текущего момента
  * `-t` — как и во втором способе, время работы процесса в секундах
  * `--ess-tag` — как во втором способе
  * `--ess-config`/`--ess-group` — как во втором способе

{% endcut %}


Подробная инструкция запуска любого [процесса](https://a.yandex-team.ru/arc/trunk/arcadia/direct/apps/event-sourcing-system/full-ess-chain/README.md).

## Запуск локально разработчиком

Описано в инструкции
[по ссылке](https://a.yandex-team.ru/arc/trunk/arcadia/direct/apps/event-sourcing-system/full-ess-chain/README.md).<br/>
Дополнительно нужно в `Vm options` добавить
`-Dmoderation_service.tvm.secret="file://~/direct-tokens/tvm2_direct-binlog2moderation-test"`.
Содержимое `~/direct-tokens/tvm2_direct-binlog2moderation-test` берем из
`/etc/direct-tokens/tvm2_direct-binlog2moderation-test` с любого ppcdev-а.

**Также** поменять значение `moderation_service->tvm` на `enabled` в `common-development` конфиге.

## Интерфейс модерации

Интерфейс работы с заявками расположен [тут](https://sandbox.toloka.yandex.ru/tasks).

![](https://jing.yandex-team.ru/files/aleran/%D0%A1%D0%BD%D0%B8%D0%BC%D0%BE%D0%BA%20%D1%8D%D0%BA%D1%80%D0%B0%D0%BD%D0%B0%202019-09-27%20%D0%B2%2014.10.43.png)

Следует использовать суперридера.
Если **нет доступа** до dev-процесса, то его можно получить, написав `@dalexandro` логин, на который нужны права.

При переходе в задание отображается присланная заявка в виде json и поле для ввода вердикта.
Ответ заполняется в виде json-а. Модерация подсказывает поля, которые можно отправить в Директ:

![](https://jing.yandex-team.ru/files/aleran/%D0%A1%D0%BD%D0%B8%D0%BC%D0%BE%D0%BA%20%D1%8D%D0%BA%D1%80%D0%B0%D0%BD%D0%B0%202019-10-03%20%D0%B2%2011.18.57.png)

Изменяя значения, можно протестировать разные кейсы, например,
принятие/отклонение баннера, отображение причин отклонения, флаги.

Поля:

  - `verdict`: `Yes` — принять, `No` — отклонить
  - `reasons`: Идентификаторы причин
  - `minus_regions`: Минус регионы, 225 — Россия
  - `flags`: Различные флаги. Отображаются в интерфейсе директа на странице кампании
  - `brand_text` и `advertised_item`: Данные о модерируемом объекте

Нирвана [тут](https://hitman.yandex-team.ru/projects/direct_dev_nirvana/?jobCreationTimeQuery=MONTH&jobPage=1&pageSize=20).

## Получение вердиктов в Директе

#### Запуск на бете

Если jobs не инициализировался ранее, то
```bash
direct-mk java-init -- -a jobs
```

{% cut "1 способ: Запустить процесс приема вердиктов модерации через внутренний инструмент:" %}

Затем идем во внутренние инструменты и в разделе "Модерация" находим инструмент ["Получить вердикты модерации"](https://8080.beta1.direct.yandex.ru/internal_tools/#receive_from_ess_moderation).
Вводим `ess-tag`, длительность работы процесса и время **отправки** объектов
(объекты, **отправленные в модерацию** позднее этого времени, будут проигнорированы); жмем "Получить".

{% endcut %}

{% cut "2 способ: Запустить процесс приема вердиктов модерации командой:" %}

```bash
direct-mk run_receive_moderation
```

Команда по умолчанию запускается со следующими параметрами:<br>
Значение `ess-tag` равен номеру беты вне зависимости от тега, выставленного через `set-from-json`.<br/>
`job` равен стандартной джобе получения вердиктов `ReceiveModerationResponseJob`. <br/>
Все возможные параметры описаны в следующем разделе.

{% endcut %}


#### Запуск локально разработчиком

Обычным образом из IDEA запускаем `DebugReceiveModerationJobRunner`<br/>
Доступные параметры:

  * `--job` — название джобы получения вердиктов. Запускатор работает с любой джобой, которая наследуется от
  `BaseReceiveModerationJob` Сейчас это `ReceiveModerationResponseJob` или `ReceiveModerationErrorResponseJob` или
  `ReceiveModerationUnparsedResponseJob`. Основная джоба — `ReceiveModerationResponseJob`;
  * `--read-data-before-minutes` — Если заявка была отправлена в модерацию раньше указанного времени
  (`now() — read-data-before-minutes`), то такой вердикт будет отфильтрован. По умолчанию равно 30 минут;
  * `-t` время работы runner-а в секундах. По умолчанию равно 60 секунд;
  * `--ess-tag` тег для фильтрации вердиктов;
  * `--cid` фильтрует по идентификатору кампании;
  * `--pid` фильтрует по идентификатору группы;
  * `--bid` фильтрует по идентификатору баннера;

P.S. все условия фильтрации объединяются по **И**

В `VM Options` добавляем
```
-Dyandex.environment.type=development
-Dmoderation_service.tvm.secret="file://~/direct-tokens/tvm2_direct-binlog2moderation-test"
```

В `Program arguments` прописываем соответствующие аргументы, пример:
```
--job ReceiveModerationResponseJob
--read-data-before-minutes 60
--ess-tag 12029
-t 3000
```

`--read-data-before-minute` — имеет особенность на dev контуре модерации. Время  в ответе (unixtime) копируется из
запроса (т.е это не время отправки ответа), надо это учитывать.

Поменять значение `moderation_service->tvm` на `enabled` в common-development конфиге.
Файл `~/direct-tokens/tvm2_direct-binlog2moderation-test` скачивается скриптом `./bin/download_secret_for_local_use.py`
