# Тестирование задач

Тестирование задач происходит в рамках отдельных проектов, к которому прикрепляется каждый тестировщик. <br>
В рамках работы над проектом тестировщик должен выполнить следующие обязательные шаги:<br><br>

## Анализ требований

**Тест-план.** <br>
Должен быть заведен и сделан тикет на тест-план. В нем описаны области проверок, которые необходимо выполнить по данному проекту. Описаны инструменты, которыми эти проверки будут выполняться. При необходимости, описать, какие условия и/или тестовые данные нужны, чтобы эти проверки можно было выполнить (роли, доступы, тестовые сайты и т.д.)
<br><br>
**Вопросы по реализации.** <br>
В том же тикете на тест-план или отдельно сформулировать список вопросов по реализации функционала: как с точки зрения поведения пользователей (например, специфичные пользователи или условия работы), так и с точки зрения возможной технической реализации (например, как и где данные будут храниться на бэкенде).

## Участие в процессе разработки

**Мониторинг состояния проекта.** <br>
Участие во встречах, в синках, в обсуждениях. Умение в любой момент времени сказать, на какой стадии сейчас разработка проекта, оценить примерные сроки готовности и потенциальные риски.
<br><br>
**Тест-ревью.** <br>
В задачах, в которых разработке нужна помощь в написании проверяемых сценариев, тестировщик проводит тест-ревью. Смотрит на кейсы, которые проверил/хочет проверить разработчик, дополняет их. При необходимости, подключается и тестирует самостоятельно. Помогает с поиском и подготовокой тестовых данных.

## Тестирование

**Тестирование в продакшене.** <br>
Проверки того, что разрабатываемый функционал корректно работает: доступен, работает без ошибок. Тестирование может начинаться еще до момента полной готовности реализуемого функционала. Важно понимать, что бОльшая часть уже готова и не будет существенно видоизменена (как со стороны фронтенда, так и со стороны бэкенда).
<br><br>
**Догфудинг.** <br>
Работа с фичей в продакшене с подходом, близким к работе реальных пользователей. Запуск и остановка рекламных кампаний с разрабатываемым функционалом, отслеживание статистики, "отлов" потенциальных неудобств в повседневной работе, с которыми могут столкнуться пользователи при ежедневной работе с фичей.
<br><br>
**Работа с багами.**<br>
Заведение багов, их приоритезация, мониторинг починки багов, отслеживание общего количество багов по задаче.
<br><br>
**Критичные баги и SPI.**<br>
В случае появления критичных проблем в новой функциональности, которые привели к SPI, подключаться к диагностике, починке и разбору этих SPI.

## Регрессия

**Написание YML.** <br>
Написание и коммит YML с регрессионными проверками, которые будут проводить асессоры по новому разработанному функционалу.
<br><br>
**Работа с автотестами.** <br>
При наличии навыков самостоятельное написание автотестов. Если таких навыков нет, то заведение тикетов на написание автотестов на разработчика. Обсуждение с разработкой какие сценарии какими автотестами лучше проверять.
<br><br>
**Документация.** <br>
Подготовка документации, которая поможет в дальнейшем поддерживать реализованный функционал (с помощью docs, wiki, Miro и т.д.)
<br><br>
**Рассказ о новом функционале.** <br>
Провести лекцию/встречу/рассказ для остальной команды тестирования о новом функционале. Оставить ссылки на "артефакты" имеющиеся после готовности предыдущих пунктов, чтобы любой человек из команды мог быстро погрузиться в нюансы задачи.
<br><br>

--
<br>
В случае неактуальности информации на данной странице можно обращаться к [Олегу Судареву](https://staff.yandex-team.ru/sudar)
