# Автоматические чек-листы в релизах

Для релизов Java-приложений у нас предусмотрены автоматические чек-листы. Они создаются и обновляются приложением Шасси
по расписанию.

{% note info "Автоматика настойчива" %}

Если исправлять состояние автоматических галок руками, то автоматика изменения перезатрёт. Если очень хочется, то надо
сначала отключить автоматическую проверку чек-листа.

{% endnote %}

Список автоматических проверок включает в себя:
- Юнит-тесты — в связанных тикетах не осталось не закрытых тикетов с именем "Запуск юнит-тестов в релизе `<ключ релиза>`"
- Автотесты — в связанных тикетах не осталось не закрытых тикетов с именем "Запуск и анализ регрессионных автотестов в релизе `<ключ релиза>`"
- Тикеты "Тестировать" — в очереди тикетов на тестирование ничего не осталось, запрос в трекер выглядит так:
  ```
  Status: "Beta-tested", "Awaiting Release"
  AND "Affected Apps": <ключ приложения>
  AND "Tested Apps": !<ключ приложения>
  AND Relates: <ключ релиза>
  ```
- Тикеты "Разобраться" — в очереди подозрительных тикетов ничего не осталось, запрос в трекер выглядит так:
  ```
  (
  Status: !Closed AND Status: !"Beta-tested" AND Status: !"Awaiting Release"
  OR "Affected Apps": empty()
  OR Status: Closed AND "Affected Apps": <ключ приложения> AND "Tested Apps": !<ключ приложения>
  ) AND Relates: <ключ релиза>
  AND (Queue: DIRECT OR Queue: DIRECTMIGR)
  ```
- devtest/dev7 — на соответствующих средах установлено приложение версии текущего релиза. Проверяются только стейджи
  деплоя, которые доступны приложению в соответствии с [реестром приложений](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/direct-apps.conf.yaml)

{% note tip "Если надо отключить автоматику" %}

Тег `auto_checklist_off` можно выставить релизу руками. Это позволит отключить автоматическую проверку чек-листа,
если по каким-либо причинам есть необходимость проверять и проставлять все пункты вручную.

{% endnote %}
