# Релиз DNA

[Метатрекер](https://javadirect-dev.yandex-team.ru/metatracker/?app=dna&release_id=-1)  

## Если собираешь в первый раз { #first-release}
 
- [Разложить ssh (если нет) и gpg ключи](https://wiki.yandex-team.ru/direct/Development/howto/packages/#podgotovka)

## Предварительно { #until-release}

- Сборка релизов dna и web происходит автоматически с 6 до 11 утра по будням. Посмотреть расписание можно командой `dt-autorelease-ctl -a dna show`
Если сборка упала, то можно запустить сборку вручную по инструкции ниже

- Если нужно запустить сборку в другое время
  - Перед самой сборкой предупредить в [релизный чат]({{chat-direct-release}}),
если сборка в нештатное время: `Через пять минут/полчаса минут начинаю сборку релизов web и dna`.
  - Запустить сборку роботом `dt-autorelease-ctl -a dna force` [Подробнее](../../releases/concepts-create-release-auto.md#dt-autorelease-ctl)


## Ручная сборка { #new-release }

- Зайти в консоли на ppcdev, на котором разложен ключ
- `direct-dna-release --help` — вывод всех команд, которые умеет direct-dna-release
- `direct-dna-release --new`

{% note tip "Если сборка упала" %}

Если сборка упала, то продолжить с места падения можно командой `direct-dna-release --continue NNNN`.
Где NNNN — это номер нового релиза. Например, `0.265.0`

{% endnote %}
- ввести пароль от гитхаба, если возникнет окошко

{% note warning "Если сборка упала и continue не помогает" %}

Если сборка падает намертво и непонятно, что пошло не так, можно попросить кого-то из разработчиков посмотреть логи.
[Как посмотреть лог сборки](#release-log)

{% endnote %}
- Перед началом тестирования
    - Посмотреть, что ТС обновилась на нужную версию: [Версионика](https://direct-dev.yandex-team.ru/versionica/property?project=&reqid=&group=&host=&property=yandex-direct-dna%24&host_group=zknode%3A%2Fdirect%2Fnp%2Ftest%2Fhosts%2Fdirect-web). Нужная группа хостов уже указана в параметрах в ссылке. 
    - Проверить, что 8080 и 8999 обновились на нужные версии (8999 должна совпадать с версией собираемого релиза, а 8080 совпадать с версией прошлого релиза)
    `betas ppc | grep 8999` (или в волшебной палочке)
    - Релизный тикет автоматически создался скриптом сборки релиза, ставим себя в QA и переводим в RFT. 
    После этого автоматически создастся тикет на регрессию и запустятся тесты
    - Пишем в чат: `Новые релизы dna и web собраны и готовы к тестированию! Ссылки на тикеты: <web>, <DNA>.`


{% note tip "Если в новом релизе dna не планируется регрессия асессоров, то необходимо выполнить следующие шаги:" %}

1. Удалить ближайшую бронь в https://booking.yandex-team.ru/#/ перед тем, как перевести релизный тикет в тистинг
2. В релизный тикет проставить тег `no_assessors`
3. Перевести релизный тикет в тестинг
4. Если тикет на асесоров создался, то проставить в него тег `no_assessors`. И закрыть тикет на асессоров с комментарием `В этом релизе регрессия асессоров не планируется`.

{% endnote %}

## Тестирование {#testing}
- Запустить асессоров на регрессию (окно запуска смотреть тут https://booking.yandex-team.ru/#/)
- Смотрим тикеты в странных статусах (не Closed и не Beta-Tested), тикеты на отсутствующих коллегах — находим ответственных
- Смотрим тикеты без QA - в них должно быть понятное описание что сделано, зачем и как тестировалось самостоятельно. Если описания нет или оно неполное - просим дозаполнить тикет. Если по описанию все равно что-то остается непонятным - идем к руководителю разработчика и просим его посмотреть все ли впорядке с задачей и может ли она ехать в прод
- Разбираемся с регрессией

{% note tip "Договорённости по регресии" %}

- В первую очередь на запуски автотестов в регрессии dna/java-web смотрит дежурный по тестам DNA. Он классифицирует падения в тестовом прогоне. 
- Всё подозрительное перепроверяется силами дежурного по тестам с привлечением при необходимости специалиста QA.
- Специалист QA валидирует информацию от дежурного по тестам. Важно, чтобы на падения в тестах взглянул тестировщик и посмотрел, что по ним написал дежурный по тестам, чтобы снизить вероятность ошибки.
- Когда все падения разобраны и тикеты на баги созданы — можно закрывать регрессию. При условии что упавшие кейсы проверены руками, фикса тестов можно не ждать.
- После успешного прохождения регрессии пишем об этом в релизный тикет: 'Регрессия автотестами успешно завершена'. Тикеты на починку тестов заводим на разработчика задачи, если понятно, откуда сломалось.
Или [на дежурного](https://abc.yandex-team.ru/services/direct/duty/?role=2040&months=1)

{% endnote %}

- Если есть баги — назначать на разработчика задачи, если понятно откуда, и [на дежурного](https://abc.yandex-team.ru/services/direct/duty/?role=2040&months=1), если непонятно
- Пингуем тикеты без жизни. Например, два часа тикет в собранном релизе в статусе БТ — повод прийти к человеку и спросить "как дела?".

## Molly {#molly}

-  Если все запуски завершились со статусом уязвимостей не обнаружено, то можно смело закрывать тикет
-  Если у запуска статус обнаружены уязвимости:
    -  открыть отчет по ссылке отчёт в Molly
    -  найти в отчете ошибку
    -  кнопкой "Создать тикет в ST" завести тикет и передать [дежурному](https://abc.yandex-team.ru/services/direct/duty/?role=2040&months=1) (как и баги на ТС с неизвестным происхождением)
    - после этого тикет с запуском Молли можно закрыть
-  Если запуски стабильно падают со статусом TIMEOUT, идти к [Эльдару Заитову](https://staff.yandex-team.ru/ezaitov) или [его коллегам](https://abc.yandex-team.ru/services/molly/)

{% cut "Дополнительная информация" %}

**Молли** - это тулза с автоматическим запуском в релизах, она проверяет интерфейс с точки зрения безопасности

**Падения случаются обычно по двум причинам:**
- что-то выкатили в интерфейсе в этом релизе (проблема, которую безопасники считают критичной)
- безопасники выкатили какую-то новую проверку в Молли и она начала обнаруживать проблему в интерфейсе

**Основная задача дежурного** - понять относится ли проблема к релизу, а если относится, то критична ли починка или же можно фиксить отдельно от релиза

{% endcut %}

## Хотфиксы {#hotfix}

### На ТС в текущий релиз

{% include [примечание про ОК от Леши](_includes/new-tasks-hotfixing.md) %}

- Просим разработчика смержить/черрипикнуть хотфикс в релиз, говорим номер релиза
- Собираем хотфикс: на любимом ppcdev запускаем команду
`direct-dna-release --hotfix NNNN`, где NNNN — номер релиза, который хотфиксим (например, 0.107.0)
проверяем все беты — что обновились!

Если хотфикс упал, то можно продолжить аналогично сборке релиза: `direct-dna-release --continue NNNN`  
NNNN — это номер релиза, например, `0.265.0`.   
Если и продолжение падает, или систематически хотфиксы не могут собраться с первого раза — зови разработчика-фронтендера на помощь. 


### На ТС в прошлый релиз

1. Написать в админский чат, чтобы релиз не выкладывали — если он в статусе **Можно выкатывать** (приложить ссылку на тикет).
2. Убедиться, что хотфикс нужен (почему критичен к релизу или в Прод?). Если нужен ХФ в Прод, договориться с дежурным по Проду о выкладке.
3. Собрать хотфикс в нужный релиз стандартным способом (с помощью `direct-dna-release --hotfix`)
4. Предупредить в релизный чат (direct-release) о переключении ТС на предыдущую версию релиза dna
5. Переключить ТС на предыдущую версию релиза (куда собрали хотфикс) `direct-test-update test1 yandex-direct-dna=0.191.0-4-g5b07448e3c` (вместо `0.191.0-4-g5b07448e3c` подставить своё значение, можно взять из тикета)
6. Проверить тикет на ТС
7. Переключить обратно ТС на свежую версию релиза
8. Предупредить в релизный чат о возврате текущего релиза dna на ТС
9. Написать в админский чат, что релиз снова можно выкладывать (приложить ссылку на тикет). Или попросить выкладку ХФ, если ХФ в Прод.

Пункты с 3-8 можно не выполнять, надо обсуждать с QA тикета или ответственным за релиз хотим ли проверять его на ТС.
Важно: этот же хотфикс нужно привезти во все следующие релизы dna после него.
Например: `нашли баг в 190 релизе, готовому к выкладке. На ТС есть ещё один текущий релиз 191. Значит привозим по инструкции выше в 190 релиз хотфикс, потом этот же хотфикс привозим в текущий релиз 191 как обычно.`


## Отвязка тикетов от релиза {#edit-metatracker}
Делается так: в Метатрекере нажимаем **Edit**
![screenshot with edit link](_assets/metatracker_edit.png "Metatracker")  
и ставим `--- ---` у нужного тикета.

Затем нажимаем **Fix**:
![screenshot with fix link](_assets/metatracker_fix.png "Metatracker")


## После окончания тестирования {#after-testing}

- Пишем комментарий в тикет `Таким образом релиз протестирован, новых ошибок не обнаружено` и нажимаем **Passed** в релизном тикете (тикет перейдет в статус `RM Acceptance`)
- Посмотреть на наличие зависимостей
- Если в релизе были обнаружены баги, вызвавшие необходимость откатить из релиза какую-либо задачу, то необходимо проставить в **тикет с описанием бага** тэг **revert_ts**
- Пишем в релизный чат: `Релизы dna (или dna+web) протестирован, всем спасибо!`
- Проконтролировать в Админском чате, что релиз выложен.
- Стандартная выкладка в 11:00, 14:00 и 16:00 (кроме пятницы, в пятницу в 12-30). [Первоисточник](../../concepts/releases/deploy-schedule.md).
 
{% note info "Если нужно выложить в другое время" %}

- Нужно пойти [к дежурному](https://duty.mtrs.yandex-team.ru/project/direct/duty_group_dashboard/direct-prod-1/)
- Потом написать просьбу [в админский чат]({{chat-direct-admin}}): `Выложите пожалуйста хотфикс dna ССЫЛКА НА ТИКЕТ`. Описать причину выкладки вне релизного окна с указанием тикетов.
- Проконтролировать выкладку в прод.
При этом всегда стоит посмотреть на зависимости и убедиться, что с ними всё хорошо.

{% endnote %}

## Выкладка в прод

{% note warning "Сначала принять в тикете, потом выкладывать" %}

**Проверить что релиз в Ready to Deploy, Accept должен быть нажать до того, как будет сделано direct-version-set**

{% endnote %}

Выкладка производится с продакшеновых машин, именуемых [ppcback-ами](../../jeri/things/ppcback).

Запускать команды можно без `tmux`, где надо `tmux` запустится само.

- Записать версию в ZK:

  `direct-version-set dna <версия>`

  `<версия>` берется из заголовка релизного тикета, например, для тикета [DIRECT-173564](https://st.yandex-team.ru/DIRECT-173564) она будет `0.639.0-1-yf5de0a8e0`, а для тикета [DIRECT-174126](https://st.yandex-team.ru/DIRECT-174126) &mdash; `0.642.0`.

- Сохранить предыдущую версию приложения из вывода команды на случай отката.

- Выложить нужную версию пакета:

  _откроет tmux-сессию с выкладкой на лимтест и "основной продакшен" в разных окнах_

  `dna-up-all <version>`

- После окончания выкладки убедиться, что в [версионике прописалась](https://direct-dev.yandex-team.ru/versionica/property?project=prehistoric&reqid=&group=&host=&property=yandex-direct-dna%24&host_group=c%3Adirect_frontends%2Cdirect_limtest_rtc) новая версия для всех серверов, кроме залоченных `%limtest%`.

## Откатить релиз dna в проде
для отката релиза потребуется использоваться флаг `--downgrade|-d`

Пример:
`dna-up-all <старая версия> -d`

{% cut "старый/хардкорный способ отката" %}

Пройтись экзекутером по машинкам с автоподтверждением даунгрейда:
`executer p_exec %direct_frontends_rtc apt-get install yandex-direct-dna=<старая версия> -y --force-yes`

{% endcut %}

Ещё надо откатить в zk версию

`direct-version-set dna <версия> --force`

## Как смотреть лог сборки {#release-log}

- Для начала нужно зайти по ssh на `ppcdev`, на котором проходила сборка. Если сборку запускал кто-то другой, необходимо у него узнать номер `ppcdev`, на котором он это делал. Автоматическая сборка релизов `dna` происходит на `ppcdev7` под логином `ppc`.
- Переходим в каталог `cd /tmp/temp-ttl/ttl_7d`. Почему сюда? Потому что релизные логи пишутся в данную директорию - [код](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/direct-release-tools/bin/direct-dna-release?rev=r7641830#L14).
- Далее грепаем каталог по логину того, кто собирал релиз (например, larilena): `ls -lt | grep dna-release-larilena`. Для автоматической сборки команда будет выглядеть следующим образом: `ls -lt | grep dna-release-ppc`.
- После можно увидеть все последние сборки этого пользователя за неделю - выбираем последнюю по дате/времени и заходим (либо выбираем необходимую по промежутку времени, когда была запущена сборка релиза).
- Лог сборки в файле `release.log`, в корне папки. Для просмотра лога удобно использовать команду less `less release.log`. Навигация по файлу клавишами `f` и `b` - вперед и назад на одну страницу соответственно. Для слежения за логами в реалтайме удобно использовать команду `tail -f release.log`.
- В файле `step`, в корне папки, лежит последний успешный шаг сборки. Если сборка завершилась с ошибкой, то в данном файле можно увидеть на каком шаге упала сборка. Список шагов для релиза - [ссылка](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/direct-release-tools/bin/direct-dna-release?rev=r7641830#L128-139), список шагов для хотфикса - [ссылка](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/direct-release-tools/bin/direct-dna-release?rev=r7641830#L141-142). Код самих шагов находится в [следующем файле](https://a.yandex-team.ru/arc/trunk/arcadia/adv/frontend/services/dna/scripts/release_commands.sh).
- Если не понятно, что пошло не так, и нужна помощь, полезно будет вытащить логи и сложить в [paste](paste.yandex-team.ru). Вытащить логи можно с помощью команды scp: например, `scp ppcdev7:/tmp/temp-ttl/ttl_7d/dna-release-ppc-ZGvUkP/release.log ~/Desktop/release.log`
