# Релизы и хотфиксы в NewCI

Сборка в NewCI в Директе призвана служить более простой альтернативой инструментарию `direct-release`. Конкретно, она отвечает за следующие части релизного цикла:
* назначение и отслеживание версий (с их автоматическим инкрементом)
* поддержание очереди релизов (пока старые релизы не выложены, новые не должны выкладываться; тестируется только один релиз, следующие ожидают своей очереди)
* сборка артефактов
* автоматическое обновление тестовых (ТС) и общих разработческих (devtest, dev7) сред
* заведение тикетов, их начальная разметка (заголовок, описание, компоненты)
* сбор лога изменений (changelog)
* выкладка в продакшен по кнопке

При этом всё, что касается тестирования по существу (запуск юнит-тестов, запуск регрессии, ручное тестирование, приёмка релизов) остаётся по-прежнему в Шасси (и частично в перловых скриптах).
Шасси сопровождает стадию тестирования релиза целиком (чеклист в релизном тикете, призывы ответственных людей), и только когда релиз полностью протестирован и принят к выкладке,
управление снова возвращается в NewCI, где и происходит последнее действие в жизненном цикле релиза: выкладка в продакшен.

Сейчас NewCI работает для всех java приложений Директа. Большой Директ (perl) продолжаем собирать через `direct-release`.

## Особенности сборки релизов в NewCI

* Версии нумеруются в формате `X[.Y]`, где X - мажорная версия, Y - минорная.
* Минорная версия отсутствует при сборке нового релиза и появляется при сборке хотфиксов к нему.
* `direct-release` ничего не знает про релизы, собранные в NewCI.

## Сборка релиза

1. Открываем [список релизов в NewCI](https://a.yandex-team.ru/projects/direct/ci/releases), находим нужное нам приложение.
2. Запускаем сборку релиза кнопкой `Run release` на ветке `trunk`. В качестве коммита выбираем последний коммит в trunk (по умолчанию), либо, если сборка нужна от конкретного коммита, можно указать этот коммит явно.
3. Переходим в запущенный flow и посматриваем за прогрессом. При хорошем сценарии автоматически должен быть создан тикет со списком изменений, пакет должен быть собран и разложен на тестовые среды.
4. Если в каком-то кубике произошла ошибка, то нужно посмотреть в логи sandbox-таска, которая выполнялась в рамках этого кубика.
   Если после просмотра логов есть надежда, что повторный запуск кубика поможет, то можно его перезапустить руками прямо на странице визуализации графа.
   Если же по логам понятно, что перезапуск не поможет (например, упала сборка пакета с ошибкой компиляции), то можно сделать хотфикс.

## Тестирование релиза
После сборки тикет автоматически переводится в `Ready For Test`. Перевод в статус `Testing(Тестируется)`, а после тестирования в `Passed(Прошли)` выполняется руками релиз-менеджера.
Тестирование релиза выполняется как обычно, Шасси приглядывает за процессом.

## Завершение ручного тестирования
При завершении тестирования нужно пойти в граф релиза и нажать на кубике `Manual testing finished` кнопку подтверждения.

## Выкладка релиза

Релиз выкладывается дежурными. Когда релиз протестирован и подошло время выкладки, дежурный app-duty принимает его. Затем, если считает выкладку возможной - прожимает в графе кубик "Разрешить выкладку в продакшен" - сделать это (успешно) могут только дежурные app-duty.
После этого релиз можно выкладывать. Подробнее в [регламенте выкладки](../../processes/regulations_deploy_releases_newci.md).

Для приложений, у которых включена полокационная выкладка (api5, web, intapi) после выкладки на одну локацию и убедившись, что все хорошо также надо будет подтвердить локацию, об которую останавливается выкладка.

## Откат релиза

Релиз откатывается вручную в Деплое. В NewCI ничего предпринимать не требуется.
Подробнее [в документации](../../jeri/guide/deploy.md).

## Сборка хотфиксов

* Если коммит был не в direct необходимо добавить его в таймлайн коммитов нужного приложения руками, нажав на точки в правом верхнем углу и затем "Add commit manually".

{% cut "Скриншот" %}

![no alt](https://jing.yandex-team.ru/files/pe4kin/2022-05-27T15:13:22Z.fb70c83.png "Добавить коммит вручную")

{% endcut %}

* Если релиз был собран из транка и к нему ещё не было добавлено ни одного хотфикса, то сначала нужно отвести релизную ветку(для web/api/intapi/jobs создаются автоматически при старте релиза).
   Для этого в на релизе нужно выполнить `Create a new branch`, нажав на точки возле имени релиза.
   Основные java-релизы (web, jobs, api5, intapi) автоматически собираются на отдельных релизных ветках (то есть отводить самому не нужно).

{% cut "Скриншот" %}

![no alt](_assets/newci_create_branch.png "Создать релизную ветку")

{% endcut %}

{% note alert "Создание веток для следующих собранных релизов" %}

Для web/api/intapi/jobs создаются автоматически при старте релиза.
Если есть более поздние собранные релизы, то для них также нужно создать новые ветки. Сейчас сборка хотфиксов блокируется релизами с большими номерами (детали - ниже),
а при отмене релиза без отдельной ветки пропадет удобный способ ее создать, не выискивая нужный коммит в транке. Поэтому лучше создать ветку до отмены релиза.

{% endnote %}

* Зайти в созданную ветку в интерфейсе NewCI

{% cut "Скриншот" %}

![no alt](_assets/newci_choose_branch.png "Выбрать созданную ветку" =312x129 )

{% endcut %}

* Нажать кнопку `Cherry pick`

{% cut "Скриншот" %}

![no alt](_assets/newci_cherry_pick_run_release.png "Нажать кнопку Cherry pick")

{% endcut %}

* Выбрать коммит, который нужно добавить. Опции `Enable merge` и `Publish review` влияют только на то, сколько действий придется сделать на следующем шаге.

{% cut "Скриншот" %}

![no alt](_assets/newci_choose_commit.png "Выбрать коммит")

{% endcut %}

* После выбора коммита он может просто открыться в аркануме, и тогда дополнительно с ним ничего делать не нужно, а может создастся ревью в аркануме с выбранным коммитом. Можно проверить, что это именно те изменения, которые хочется захотфиксить. После этого нужно нажать `Ship` (и опубликовать ревью, нажав `Publish`, и смерджить ревью, нажав `Merge`, если соответствующие опции не были включены при Cherry pick-е), и изменения сразу же замерджатся в релизную ветку. Ревью кода для коммита в релизную ветку не требуется, так что требование `Code review` нужно отжать.

* После добавления коммита и появления его в списке коммитов запустить сборку от последнего коммита этой ветки, нажав кнопку `Run Release`.

{% cut "Скриншот" %}

![no alt](_assets/newci_commit_in_branch.png "Коммит добавился в ветку")

{% endcut %}

* В появившемся окне галочку `Cancel other releases` проставлять не стоит, если не уверены, что не удалятся лишние релизы. Лучше вручную отменить те, которые будут мешать сборке хотфикса.

{% cut "Скриншот" %}

![no alt](_assets/newci_run_release.png "Запустить релиз с отменой остальных")

{% endcut %}

* После начала сборки релиз с хотфиксом, скорее всего, будет заблокирован предыдущим релизом из той же же ветки. Чтобы проверить так ли это, нужно кликнуть по новому релизу в интерфейсе NewCi:

{% cut "Скриншот" %}

![no alt](_assets/releases-branch.png "Открыть flow релиза")

{% endcut %}

* Откроется релизное flow, где можно будет увидеть виновника блокировки релиза:

{% cut "Скриншот" %}

![no alt](_assets/release-blocked-by.png "Посмотреть, кто блокирует релиз")

{% endcut %}

* Чтобы разблокировать релиз, нужно вернуться назад, в ветку релизов, и напротив блокирующего релиза выбрать из выпадающего списка операцию `Cancel`:

{% cut "Скриншот" %}

![no alt](_assets/cancel-button.png "Кнопка отмены резиза")

{% endcut %}

* В открывшимся окне, в качестве причины отмены релиза, нужно указать ревизию хотфикса:

{% cut "Скриншот" %}

![no alt](_assets/cancel-release-reason.png "Причина отмены релиза")

{% endcut %}

* После чего нажать кнопку `Confirm`.

{% note alert "Отмена следующих релизов" %}

Релизный граф хотфиксов [**пока**](https://st.yandex-team.ru/CI-3226) может блокироваться релизами не только с меньшими, но и с большими номерами, поэтому их придется отменить, даже если хотфикс в них добавлять не нужно.
Перед отменой таких релизов нужно не забыть создать им ветки, если они еще не были созданы. После успешной сборки хотфикса нужно перезапустить отмененные релизы в том порядке, в котором ожидается их выкладка в прод.

{% endnote %}

{% note warning "Хотфикс в прод" %}

Если сборка происходит в релиз, который уже в проде, то следует выбрать `hotfix-to-prod` флоу.

{% endnote %}

* Запустится новый релизный граф, который обновит минорную версию релиза в релизном тикете и допишет комментарий о хотфиксе. Комментарий о хотфиксе сейчас публикуется, не дожидаясь окончания сборки и обновления сред, поэтому до тестирования хотфикса нужно убедиться на графе релиза, что билд собрался и среды обновились.

### Не получается сделать cherry-pick в релизную ветку

В консоли сделать чекаут ветки релизной, сделать черипик коммита руками, решить конфликты, запушить.

Имя ветки можно найти в интерфейсе CI:
![no_alt](_assets/newci_release_branch_name.png "Имя релизной ветки")

```(bash)
arc fetch releases/direct/frontend/services/uac/v29
arc checkout releases/direct/frontend/services/uac/v29
arc cherry-pick <твой коммит>

# решаем конфликты

arc add .
arc cherry-pick —continue
arc push releases/direct/frontend/services/uac/v29
```

Если видим ошибку что не получилось запушить проверяем что у нас есть роль в idm к нужной релизной ветке. Пример: https://idm.yandex-team.ru/system/arc-vcs#role=50947126,f-role-id=50947126

## Отмена релиза (хотфикса)

В NewCI есть действие "Отменить релиз" (`Cancel release`). Отмена релиза/хотфикса приводит к тому, что версия, связанная с этой сборкой, больше не будет использоваться при последующих сборках, а коммиты,
привязанные к нему, попадут и в следующий релиз/хотфикс.

{% note warning "Привязка тикетов к релизном тикету" %}

Если отмененный релиз/хотфикс был собран в отдельной ветке, то при сборке следующего релиза на транке тикеты из отмененного релиза не попадут в новый релизный тикет, их нужно будет добавить самостоятельно; например, перенести из описания релизного тикета отмененного релиза

{% endnote %}

Из-за того, что при отменах релизов будут "пропускаться" версии, лучше этим действием не злоупотреблять. Однако, если конфиг сборки (`a.yaml`) или код тасклета
содержит баги, то без отмены релиза его не удастся поправить: сломанный релиз не сможет быть завершён успешно, а последующие сборки будут заблокированы тем, что фазы релиза (`phases`) будут оставаться занятыми.

## К кому обратиться за помощью

Вопросы про NewCI можно задавать [Сергею Бекаеву](https://staff.yandex-team.ru/pe4kin), [Игорю Костромину](https://staff.yandex-team.ru/elwood).
