# Способы оценить проблему
На этой странице собраны способы оценки пострадавших и масташба проблемы.
Пока в виде полезных выборок из логов, возможно позже появятся и другие.

Запросы в ClickHouse можно выполнять с ppcdev, открыв клиент в интерактивном режиме `dbs-sql pr:ppchouse:cloud`.
Ещё можно использовать YQL, инструкция по настройке [тут](../../guide/analytics/setup-yql.md#access-ppchouse).

## Количество ошибок { #errors-count }

### Веб-интерфейс: запросы и клиенты по ошибке из messages
Если у проблемы есть характерная _(пишется в логи только для указанной проблемы и не встречается в других случаях)_ ошибка в `messages` логе,
то [оценить количество пострадавших запросов и клиентов можно так](affected-cmd-requests-and-clients-by-messages-log.md).

### Веб-интерфейс и API: запросы и клиенты по ошибке из messages
Аналогично предыдущему, но с учётом запросов в API.
Подходит для оценки общих проблем, например ошибок получения статистики из БК.

Запрос и пример — на [отдельной страничке](affected-cmd-and-api-requests-and-clients-by-messages-log.md).

Считает те же величины, что запрос для веба, но уже в двух разбивках:

- по типу интерфейса (апи, веб, оба)
- по дате (каждая + весь период)


### Ошибки получения аудиторий в интапи Метрики
Ошибки при получении данных из Аудиторий Метрики приводят к невозможности обработать пользовательский запрос.
Это может выглядеть как "Сервис временно недоступен" или плашка "Внутренняя ошибка сервера".

Оценить время и количество таких ошибок можно по [сообщениям](metrika-audience-intapi-errors.md) из messages-лога.


### Ошибки страницы оплаты
При ошибках на стороне бекенда оценить время начала и завершения аварии можно
по [количеству 500х ошибок](payment-form-errors.md) в логах запросов веб-интерфейса.

### Ошибки подключения к БД
Время недоступности базы можно определить по ошибкам из messages-лога:
`Can't connect to`, `Can't execute the`, `Connection is not available`.

Способ и примеры запросов [описаны тут](database-connection-errors.md).


## Расчёт VDT { #calculate-vdt }
VDT — даунтайм вертикали.

В связи с заездом в 9999 нам требуется выполнять расчет VDT.  
Основная сложность — в определении участвующей фукнциональности и её веса, меньшая — в определении доли пострадавших.
Готовой таблички с весами — у нас пока нет. В этом разделе будем собирать примеры и текущие наработки.

Примеры расчетов:
- [DIRECTINCIDENTS-637 2020-07-24: 500-ки при посмотре статистики](https://st.yandex-team.ru/DIRECT-125153) — 8794 секунды  
   несколько часов происходили ошибки в разных контроллерах.
   рассчитывали по доле пострадавших клиентов, пробовали разделить веб-контроллеры на разные категории
- [SPI-16848: \[2020.11.09\] PROD-DIRECT: недоступность мастеров БД (ALL)](https://st.yandex-team.ru/SPI-16848) — 279 секунд  
   была частичная недоступность нескольких шардов, отстрел от балансера.
   считали по длительности ошибок с весами на долю заходящих клиентов этих шардов
- [SPI-17175: \[2020.11.16\] PROD-DIRECT: недоступна метабаза ppcdict (ALL)](https://st.yandex-team.ru/SPI-17175) — 206 секунд  
   лежал ppcdict, засчитали всё время
- [SPI-17695: \[2020.12.04\] PRODUCTION-DIRECT: Проблемы с получением сегментов метрики (ALL)](https://st.yandex-team.ru/DIRECT-133321) — 133 секунды  
   первый подход к расчёту здесь не подошел: веб + апи, много контроллеров, не получалось разделить сценарии редактирования/создания/просмотра. в итоге
   - [разделили методы апи по функциональностям](https://st.yandex-team.ru/DIRECT-133321#5fcf5cb1fd10332f6d9d8b53),
   считали даунтайм по долям (в штуках запросов) метода в рамках своей группы
   - решили считать сценарии по редактированию/созданию/просмотру неделилимыми
   - попробовали рассортировать [веб-контроллеры по группам функциональности](https://st.yandex-team.ru/DIRECT-133321#5fd109947cab6e3a84e02277)
   - решили считать даунтайм исходя из доли пользователей, столкнувшихся с ошибкой
   - сделан удобнее YQL из первого примера, ссылки [тут](https://st.yandex-team.ru/DIRECT-133321#5fd1ff1e5d23da5929e3a8cc)  
   если подобный способ себя хорошо зарекомендует — оформим готовые запросы для разных функциональностей
- [DIRECTINCIDENTS-733: 2020-11-13: не работает выбор Организации из Справочника](https://st.yandex-team.ru/DIRECTINCIDENTS-733#5fd76d3bd9358529d6cad5ae) — 5 секунд  
   не работал айфрейм справочника, оценивали по посещаемости в метрике
- [SPI-17774: \[2020.12.08\] PRODUCTION-DIRECT / WEB: Не подгружаются превью (ALL)](https://st.yandex-team.ru/SPI-17774#5fd7c39970ba9404b02aeb1b) — 13 секунд  
   не работал айфрейм превью, оценивали по снижению посещаемости в метрике по счетчику pcode
- [SPI-17824: \[2020.12.09\] PRODUCTION-DIRECT / WEB: 500ки в showCamp из-за неверных статусов модерации (ALL)](https://yql.yandex-team.ru/Operations/X-nUj9V90IS6BANYijXLVH95d5l_98pwX3FjYOk2hfs=) — 0.000015 секунд
   сумма даунтаймов для каждого из клиентов по ошибкам (как в SPI-17695)
- [SPI-19012: \[2021.01.18\] PROD-DIRECT / BSEXPORT: не работала отправка данных (ALL)](https://st.yandex-team.ru/SPI-19012) — 1350 — считали по оставанию экспорта ориентируясь на SLA из оферты

### Принцип расчета { #vdt-concept }
VDT считается как `длительность аварии`&nbsp;⨯&nbsp;`доля пострадавших`&nbsp;⨯&nbsp;`вес функциональности`.

В сложных авариях можем считать VDT суммой для нескольких разных весов (если их сумма превышает единицу — по 1).

В авариях, затрагивающих одновременно веб и апи:
- в простых случаях пренебрегаем пересеченим клиентов и просто складываем
- при сопоставимых и больших потерях — нужно следить, чтобы общий "вес" не превысил единицы.

#### Аварии с базой { #vdt-for-database-incident }
В инцидентах, где "всё совсем не работало" (например недоступность `ppcdict`) считать просто: вес функциональности и доля пострадавших равны единице.
Остается только определить длительность из логов — по инструкции [{#T}](database-connection-errors.md).

Для базы `ppc` долю пострадавших можно взять как "вес шарда", его расчет описан в [{#T}](../../guide/analytics/queries/share-of-active-clients-by-shard.md).
Пример подсчета с весами шардов — в [SPI-16848: \[2020.11.09\] PROD-DIRECT: недоступность мастеров БД (ALL)](https://st.yandex-team.ru/SPI-16848).

#### Функциональные поломки { #vdt-for-functional-incident }
Для аварий веб-интерфейса и API выделили следующие "верхнеуровневые" функциональности:
вес | функциональность
:--- | :---
0.2 | Создание РМ
0.2 | Редактирование РМ, в т.ч. ставки
0.1 | Просмотр РМ
0.2 | Просмотр статистики
0.3 | Оплата

Список контроллеров web, сгруппированных по верхнеуровневым функциональностям — [указан в теле YQL запроса](https://yql.yandex-team.ru/Operations/YFtYQNK3DKODV47wKZhKDAHZA-mQCW-CZa-ueXpwlM4=), еще неучтенные (и мусор) — в его результате. Список для API (без выборки новых) — есть в примерах выше.

К весу функциональности есть два уточнения:
- [договорились](https://st.yandex-team.ru/DIRECT-135123#6005ab43a5e7b12ccac20843) умножать его ещё на `1/3` или `2/3` (соответственно нашей экспертной оценке `$impact_clients_N`), чтобы улучшить субъективное восприятие оценки
- сценарии создания/редактирования и просмотра — тесто связаны для пользователя, поэтому для аварий web используем общую функционасть "работа с рекламными материалами" с суммарным весом функциональности 0.5

Долю пострадвших клиентов договорились считать так: в десятиминутных интервалах делим `число клиентов, столкнувшихися с ошибкой` на `число клиентов, использовавших любой метод из этой же верхнеуровневой функциональности`.

В совокупности: VDT считаем как сумму долей клиентов по 10ти-минутным интервалам и умножаем её на нужные веса и коэффициент impact_clients.

**Пример расчета** — [YQL](https://yql.yandex-team.ru/Operations/YCwG_fMBw4rPTYke9uPuIGtLQDs_BadTWCYWeITSMvc=).
В нём нужно поменять:
- времена начала и окончания аварии
- вес функциональности (0.5, 1 или конкретной функциональности)
- поправочный коэффициент на `$impact_clients` — 1/3, 2/3 или 3/3
- условие для выборки ошибок из messages
- список всех контроллеров "функциональности" (от которой используется вес) в приаттаченном файле

#### Background-поломки { #vdt-for-background-processes}
Фоновые процессы трудно оценивать по той же шкале, что ошибки веб-интерфейса или API.

Пробуем их считать в другой плоскости (не пытаясь получить в сумме с функциональностями интерфейса или друг с другом — единицу). Веса для транспорта придумали чуть раньше, про пользлоги/статусы/репликатор договорились на [встрече по инцидентам](https://st.yandex-team.ru/DIRECT-137783#6031177487aaad678384ea2d).

Текущий список, для которого уже придумали веса:
*(долю пострадавших клиентов нужно брать относительно всех посетителей интерфейса Директа в указанный промежуток времени)*
вес | функциональность | комментарий
:--- | :--- | :---
0.4 | отправка ставок в БК старым транспортом 
0.4 | задержка отправки данных в модерацию новым транспортом | больше чем на 90 минут
0.0019 | отставание пользологов | больше чем на 2 минуты
0.05 | отставание аггрегированных статусов | больше чем на 30 минут
0.6 | отставание/поломка репликатора

**Нормированные веса**:
*(долю пострадавших пользователей нужно брать относительно всех в этом процессе/транспорте)*
вес | функциональность | комментарий
:--- | :--- | :---
0.068 | задержка отправки данных в модерацию старым транспортом | больше чем на 90 минут
0.233 | отправка данных в БК старым транспортом | половина SLA из оферты (см SPI-19012), для данных будет 90 минут, для отключения — меньше
Структура и список весов еще будут переделаны и отдельно задокументированы. Пока подробности можно спрашивать у ppalex@.

##### Про вес задержки отправки на модерацию старым транспортом
База для расчёта (при будущих пересчетах) веса — **0.4**. Она корректируется на долю клиентов, чьи данные этим транспортом передаются к тем, над чьми данными совершают действия в веб интерфейсе.

Текущее значение `0.068` получено 24/03/2021 так:
- по логам экспорта на модерацию [определено](https://yql.yandex-team.ru/Operations/YFuIOtK3DKODV87PYcZsszN6UndQyzB-FKeALAvl60Q=) количество клиентов, чьи данные переданы за день, неделю, две, три и четыре
- по логам запросов в веб и апи определено количество клиентов, над чьими данными соверешали действия в наших интерфейсах:
    за [неделю](https://yql.yandex-team.ru/Operations/YFus2QPTTrrBdBz73fpAZUu9j9iJqv-cuzIACWqSjno=),
    [две](https://yql.yandex-team.ru/Operations/YFus9gPTTrrBdB0nBmG7-_Zx3T6ztg5MYOhtR4zd__w=),
    [три](https://yql.yandex-team.ru/Operations/YFutBwPTTrrBdB1RRa7Un0pG_WVqO-7hSAv7rBXnmoc=)
    и [четыре](https://yql.yandex-team.ru/Operations/YFuqLL94hqYIQWQ_n5cbMdwzluKEQnpTGoqu78XM2j4=)
- получились следующие доли клиентов:
    - 0.1156 — неделя
    - 0.1548 — две
    - 0.1674 — три
    - 0.1704 — четыре
- выбрана 0.17 для дальнеших расчетов и умножена на 0.4 — так получилось 0.068

При расчете аварий с транспортом предлагается брать долю клиентов как:
- число пострадавших клиентов делать на всех, чьи данные переданы транспортом
- `1/(число шардов)` или конкретное значение (расчитанное по доле активных клиентов) при полных поломках экспорта в шарде
- 1, если не работала модерация

##### Про вес для экспорта в БК старым транспортом
Оргинальное значение веса —  **0.4**. Оно отнормировано на долю клиентов за 4 недели: [клиенты веб/апи](https://yql.yandex-team.ru/Operations/YTt3PhJKfWzqRsllmF7GirAnR9s6NAG9-cGhIe-aRXg=), [клиенты в экспорте](https://yql.yandex-team.ru/Operations/YTt5mJfFt80z4hrcvTWNv-ciOhspWCfbn79V47t87wE=).
Получилось 658527 / 1132581 * 0.4 = 0.233

В Warden транспорт выделен в [отдельный сервис](https://warden.z.yandex-team.ru/c/direct__bsexport), вес которого **0.4**. [Функциональность старого транспорта](https://warden.z.yandex-team.ru/functionality/e991aeb0-4db6-4ba1-845f-a4e1e938c2da) имеет вес **0.58**, что дает в перемножении вес **0.233**. 
Меняли здесь: [DIRECT-162772](https://st.yandex-team.ru/DIRECT-162772#620669a0a78c2a417f339838)

Пример расчета YDT по графику: <https://nda.ya.ru/t/WUWFAbKl55eMsB>

## Расчёт YDT { #calculate-ydt }

YDT считается как `impact_vertical`&nbsp;⨯&nbsp;`VDT`.  
Сейчас `impact_vertical = 0.02`

### Дефолтный вес  { #default-ydt }

В случае, когда потери не существенны, а рассчет YDT затруднительный, можно использовать дефолт: **0.066**, [рекомендуемый дежурной сменой](https://a.yandex-team.ru/arc_vcs/sandbox/projects/devops/DevOpsAlert/__init__.py?rev=r9108349#L1181)
