# Ошибки запросов в API аудиторий
Этим способом можно выбрать количество неудачных запросов во внутреннее API Аудиторий Метрики.
Ошибки сгруппированы по пятиминутным интервалам.
Отдельно считаются предупреждения (новый интерфейс) и ошибки (старый).

Подсчёт идет по уникальным trace_id — это позволяет не учитывать перезапросы или дубли в логах.


## запрос в ClickHouse
[YQL](https://yql.yandex-team.ru/Operations/Xu_CDpdg8qVokxNnVZ5hGm1aqdQ-LfGgLHwZV7gOnPI=).
В запросе изменить дату на необходимую.
Можно поменять или убрать фильтрацию на число ошибок (`HAVING err >= 4 OR warn >= 10`).
```yql
SELECT toStartOfFiveMinute(log_time) AS t,
    ifnull(count(DISTINCT IF(log_level != 'WARN', trace_id, NULL)), 0) AS err,
    ifnull(count(DISTINCT IF(log_level = 'WARN', trace_id, NULL)), 0) AS warn
FROM messages
WHERE log_date = '2020-02-13'
    AND message LIKE '%audience-intapid.metrika.%'
    AND message NOT LIKE '%апрос слишком сложный%'
    AND message NOT LIKE '%res: 200 OK%'
    AND service != 'direct.script'
GROUP BY t WITH TOTALS
HAVING err >= 4 OR warn >= 10
ORDER BY t ASC
```

## пример результата
t | err | warn
:--- | ---: | ---: 
2020-02-13 10:20:00 |   10 |    0
2020-02-13 12:05:00 |   97 |    0
2020-02-13 12:15:00 |   12 |    0
2020-02-13 12:20:00 |    4 |    0
2020-02-13 12:25:00 |    6 |    0
2020-02-13 12:30:00 |  592 |  252
2020-02-13 12:35:00 | 3517 | 3188
2020-02-13 12:40:00 | 2859 | 2323
2020-02-13 12:45:00 |  330 |  307
2020-02-13 12:50:00 |  190 |  207
2020-02-13 12:55:00 |  133 |  106
2020-02-13 13:00:00 |   12 |   22
2020-02-13 13:05:00 |   83 |    0
2020-02-13 13:55:00 |   73 |    0
2020-02-13 14:00:00 |   31 |  115
2020-02-13 14:05:00 |   93 |    0
2020-02-13 14:10:00 |  932 |  616
2020-02-13 14:15:00 | 1162 | 1220
2020-02-13 14:20:00 |  130 |   99
2020-02-13 14:35:00 |  507 |  120
2020-02-13 14:40:00 | 3419 | 2963
2020-02-13 14:45:00 | 4903 | 4058
2020-02-13 14:50:00 | 1847 | 1487
2020-02-13 14:55:00 | 2096 | 1597
2020-02-13 15:00:00 | 4355 | 3707
2020-02-13 15:05:00 | 4262 | 3534
2020-02-13 15:10:00 | 4303 | 3488
2020-02-13 15:15:00 | 1923 | 1594
2020-02-13 15:20:00 | 1835 | 1349
2020-02-13 15:25:00 | 3026 | 2524
2020-02-13 15:30:00 |  497 |  429
2020-02-13 15:35:00 |  166 |  110
2020-02-13 15:40:00 |  724 |  537
2020-02-13 15:45:00 |  307 |  272
2020-02-13 15:50:00 |  134 |   79
2020-02-13 15:55:00 |  127 |  123
2020-02-13 16:05:00 |  247 |  168
2020-02-13 17:20:00 |    0 |   27
2020-02-13 18:00:00 |   16 |    4
Totals              |44960 |36600

