# Ошибки новой формы оплаты
Этот запрос выбирает количество 500-х ошибок по пятиминуткам из лога запросов к веб-интерфейсу.

## запрос в ClickHouse
[YQL](https://yql.yandex-team.ru/Operations/XuuIO1PzVN01fonid5PspuCuxHtXLP2vp9qgHVidr_0=).
В запросе заменить дату на нужную.
```yql
SELECT
    toStartOfFiveMinute(log_time) AS t,
    count(*) AS count
FROM ppclog_cmd
WHERE log_date = '2020-04-08'
    AND http_status = 500
    AND cmd IN ('payment.getBillingData', 'payment.form')
GROUP BY t
ORDER BY t ASC
```

## пример результата
t | count
:--- | ---:
2020-04-08 00:45:00 |   2
2020-04-08 05:15:00 |   1
2020-04-08 12:30:00 |   1
2020-04-08 13:55:00 |  77
2020-04-08 14:00:00 |  55
2020-04-08 14:05:00 | 198
2020-04-08 14:10:00 | 194
2020-04-08 14:15:00 | 115
2020-04-08 14:50:00 |   1
2020-04-08 14:55:00 |   4
2020-04-08 15:00:00 |   3
2020-04-08 15:10:00 |   1
2020-04-08 15:30:00 |   1
2020-04-08 18:00:00 |   3
2020-04-08 21:30:00 |   8
2020-04-08 22:00:00 |   1
2020-04-08 22:05:00 |   6
2020-04-08 22:15:00 |   3
2020-04-08 22:30:00 |   1
2020-04-08 23:30:00 |   3
