# Как устроен дашборд про инциденты
На этой странице описано техническое устройство дашборда [Директ: инциденты](https://dash.yandex-team.ru/aq299sisay946?mode=tv).
Используемые компоненты и технологии, источники данных и процессы по их подготовке.

Описание призвано повысить прозрачность и доверие, упростить поддержку дашборда.


# Общее описание
Дашборд сделан на платформе [DataLens](https://datalens.yandex-team.ru/) Яндекс.Облака.
Первоисточником данных выступает [трекер](https://st.yandex-team.ru),
собирает их несколько "задач" в приложении
[Chassis](https://a.yandex-team.ru/arc/trunk/arcadia/direct/apps/chassis)
и записывает в [Yandex Database](https://ydb.yandex-team.ru).

Схема передачи данных:

- Трекер → IncidentsReporter → YDB
- Трекер → ActionItemsReporter → YDB
- YDB → IncidentsReporter → YDB
- YDB → Подключение → Датасет (_несколько_) → Чарт (_много_) → Дашборд


# DataLens
Отвечает за отображение данных в виде графиков и таблиц.
Для этого читает данные из хранилища,
преобразовывает их (создает вычислимые колонки, такие как длительности и признаки) и
фильтрует по пользовательскому запросу (например диапазону дат).

## Объекты DataLens
В схеме передачи данных часть "Подключение → Датасет → Чарт → Дашборд" — представлена объектами DataLens.

### Дашборд
Итоговая [страница](https://dash.yandex-team.ru/aq299sisay946?mode),
на которой размещены: графики или таблицы, селекторы, текстовые пояснения.
Подробнее о дашбордах в [документации](https://cloud.yandex.ru/docs/datalens/concepts/dashboard).

Селектор — предназначен для фильтрации данных.
На странице выглядит как поле ввода.
Доступные варианты формируются по исходным данным дашборда.  
При изменении заданных значений — фильтр применяется к данным 
и происходит перерисовка графиков и таблиц, в которых эти данные задействованы.  
В качестве примера — [ссылка на дашборд](https://datalens.yandex-team.ru/aq299sisay946-direkt-incidenty?t=&state=f5ef37202183)
с заданным селектором **Источник**.

Вкладка — способ сгруппировать информацию.
Вкладки бывают как у дашборда, так и у графиков.
На странице выглядят как горизонтальный ряд кликабельных текстовых заголовоков.  
Выбранные значения селекторов действуют только в пределах вкладки дашборда.  
В качестве примера — [ссылка на дашборд](https://datalens.yandex-team.ru/aq299sisay946-direkt-incidenty?tab=lWG)
открытый на вкладке **Нужно доразметить**.


### Чарт
Визуальное представление информации из датасета: график или таблица.
Может содержать собственные условия фильтрации данных — при отображении на дашборде они применяются вместе с селекторами.
Подробнее о чартах в [документации](https://cloud.yandex.ru/docs/datalens/concepts/chart).

Примеры чартов:

- нормированный [график](https://datalens.yandex-team.ru/wizard/zgsltcisaayyv-normirovannyy-grafik-kolichestva-po-istochniku-obnaruz)
инцидентов по способу обнаружения в разбивке по месяцам
- [таблица](https://datalens.yandex-team.ru/wizard/zgsltcisaayyv-normirovannyy-grafik-kolichestva-po-istochniku-obnaruz)
тикетов, которые разметить
- [график](https://datalens.yandex-team.ru/wizard/j09bace5zphqf-grafik-kolichestva-incidentov)
количества инцидентов в раскраске по области и разбивке по две недели

### Датасет
Описывает набор данных, доступных для использования.
Подробнее о модели данных в [документации](https://cloud.yandex.ru/docs/datalens/concepts/dataset/data-model).

Датасет состоит из:

- подключения — содержит настройки для получения данных
- таблиц — какие из доступных в подключении будут использованы
- набора полей — столбцов данных и их характеристик

У каждого поля есть 3 характеристики:

- Имя — в чартах и селекторах данные будут доступны под указанным именем
- Тип — отвечает за тображения и внутренние преобразования, его можно скорректировать
- Источник поля — отвечает за содержимое поля:
это может быть значение поля из таблицы подключения
или результат, вычисленный по формуле (из других настоящих или вычислимых полей)

Вычислимые поля активно используются в дашборде для решения нескольких задач:

1. Изменение представления или формата даннных.
На примере **Время обнаружения** — оно хранится как дата с временем и приводится:
  - к дате — для отображения в таблицах
  - к дате, округленной до двух недель — для оси X графиков "по две недели"
  - к дате, округленной до начала месяца — для оси X графиков в разбивке "по месяцам"
1. Отказ от хранения избыточных данных.
Например поле **Время до обнаружения** вычисляется как разница полей **Время обнаружения** и **Время начала**.
1. Объединение данных в логические группы.
Здесь примером является поле **не размечено**, объединяющее несколько признаков
для отображения инцидентов в таблице на вкладке **Нужно разметить**.
1. Упрощение добавления новых или изменения существующих признаков.
Позволяет добавить новый селектор на базе тегов или компонентов без правки/выкладки кода и миграции хранимых данных.
Таким способом реализовано поле "Про деньги", получающееся из табличного поля со всеми тегами.

Используемые датасеты:

- [данные](https://datalens.yandex-team.ru/datasets/hy2qz0u5pe9ud-incidenty) об инцидентах
- [метрики](https://datalens.yandex-team.ru/datasets/4nf2vqafumu80-metrika-nerazmechennogo) неразмеченных инцидентов

### Подключение
Содержит информацию о параметрах доступа к источнику данных.

Все датасеты дашборда работают через подключение
[ydb-ru-prestable-robot-direct-sustain](https://datalens.yandex-team.ru/connections/4lpco64xwrk40-ydb-ru-prestable-robot-direct-sustain).
Оно использует коннектор (драйвер) CH over YDB и OAuth-токен робота **robot-direct-sustain** для авторизации.


## Права доступа
На дашборд и все связанные объекты выданы права:

- Администрирования: роботу **robot-direct-sustain** — для возможности настройки и редактирования.
Доступ к роботу есть у владелецв роли "Управляющие роботами" ABC-сервиса **direct**.
Или его можно запросить в [IDM](https://nda.ya.ru/t/l9_ZnMGi3q3P2z).
[Пароль от робота](https://yav.yandex-team.ru/secret/sec-01dpkgt349r3pvs0avmhnyrc52/explore/versions) и [токены](https://yav.yandex-team.ru/secret/sec-01dpx7w8bzrrakyetz35h1sqwn/explore/versions) лежат в секретнице.
- Просмотр (исполнение): **Яндекс** — позволяет просматривать дашборд и его графики любому сотруднику.

При добавлении в дашборд новых датасетов или чартов, нужно обновить права доступа.
Удобнее всего управлять правами на дашборд — права на связанные сущности будут добавлены автоматически.  
Как это сделать:

1. Со страницы [дашборда](https://datalens.yandex-team.ru/aq299sisay946-direkt-incidenty) перейти в **Права доступа** (под кнопкой с тремя точками)
1. Нажать кнопку **Добавить** в правом верхнем углу модального окна **Права доступа**
1. В поле **Добавить участника** вписать `robot-direct-sustain`, кликнуть по результату в саджесте или нажать `Enter`
1. В разделе **Текущий объект** изменить `Просмотр` на `Администрирование`
1. В разделе **Связанные чарты** изменить `Просмотр` на `Администрирование` (изменится сразу у всех объектов раздела)
1. В разделе **Связанные датасеты** изменить `Исполнение` на `Администрирование` (изменится сразу у всех объектов раздела)
1. В разделе **Связанные подключения** изменить `Исполнение` на `Администрирование` (изменится сразу у всех объектов раздела)
1. Нажать кнопку **Добавить** в правом нижнем углу модального окна **Добавить участника**
1. Снова нажать кнопку **Добавить** в правом верхнем углу модального окна **Права доступа**
1. В поле **Добавить участника** вписать `Яндекс`, кликнуть по результату в саджесте или нажать `Enter`
1. Сразу нажать кнопку **Добавить** в правом верхнем углу модального окна **Права доступа**


## YDB
Для дашборда используется база
[direct/test/maintenance-helpers](https://ydb.yandex-team.ru/db/ydb-ru-prestable/direct/test/maintenance-helpers/browser)
кластера **ydb-ru-prestable**.
Выбор престейбл кластера обсуловлен тем, что [ClickHouse over YDB](https://ydb.yandex-team.ru/docs/getting_started/start_chydb)
был недоступен для продакшн инсталляции в момент создания дашборда.

К базе данных предоставлено право на чтение всем разработчикам Директа (по ABC).  
Полные права (`use`) доступа выданы:

- роботу **robot-direct-sustain**
- обладателям роли **Администратор MDB** ABC-сервиса **direct**

К дашборду относятся следующие таблицы:

- [incidents](https://ydb.yandex-team.ru/db/ydb-ru-prestable/direct/test/maintenance-helpers/browser/incidents) —
данные об инцидентных тикетах
- [scoring_of_incidents_to_mark_up](https://ydb.yandex-team.ru/db/ydb-ru-prestable/direct/test/maintenance-helpers/browser/scoring_of_incidents_to_mark_up) —
замеры количества неразмеченных тикетов и полей

Все нужные таблицы TicketProcessorApp умеет создавать самостоятельно при старте приложения.
Миграции (изменения схемы) выполняются вручную через веб-интерфейс YDB.

Отладка TicketProcessorApp может быть выполнена на базе
[home/ppalex/mydb](https://ydb.yandex-team.ru/db/ydb-ru-prestable/home/ppalex/mydb/browser),
содержащей такой же набор таблиц.
Права доступа к ней нужно просить у [ppalex@](https://staff.yandex-team.ru/ppalex).
Готового дашборда / чартов и датасетов поверх этой базы — нет,
но их нетрудно сделать скопировав существующий датасет (и заменив в нем таблицы) и чарты (заменив в них датасет).



## Chassis
Многофункциональное приложение (не только про инциденты).  
Код живёт в [аркадии](https://a.yandex-team.ru/arc/trunk/arcadia/direct/apps/chassis),
собирается и выкладывается автоматически через [NewCI](https://a.yandex-team.ru/projects/direct/ci/releases/timeline?dir=direct%2Fapps%2Fchassis&id=deploy-layer-release).  
Логи пишет в messages, посмотреть их можно в продакшен
[LogViewer](https://direct.yandex.ru/logviewer/short/2sKYs6OM4rZGzY).

Для дашборда по инцидентам приложение решает несколько задач:

1. [Инкрементальный импорт](https://a.yandex-team.ru/arc_vcs/direct/apps/chassis/src/main/java/ru/yandex/direct/chassis/entity/reports/incident/IncidentsReporter.java) инцидентных тикетов.
Выполняется каждые 10 минут.  
Получает из трекера все инциденты обновленные за последний день
и сохраняет их в таблицу `incidents`.  
Импорт односторонний, поэтому удаленные (перемещены в другую очередь или отмечены компонентой `@none`) инциденты
нужно удалять из таблицы вручную.
1. [Подсчёт статистики](https://a.yandex-team.ru/arc_vcs/direct/apps/chassis/src/main/java/ru/yandex/direct/chassis/entity/reports/incident/IncidentScoringJobs.kt)
по неразмеченным инцидентам.
Выполняется каждые 90 минут.  
Устроен как `INSERT SELECT`
[YQL-запрос](https://a.yandex-team.ru/arc_vcs/direct/apps/chassis/src/main/resources/scoring_of_incidents_to_mark_up.yql),
добавляющий в таблицу `scoring_of_incidents_to_mark_up` выборку из `incidents`.  
Неочевидная особенность — текущее время подставляется из кода
(вместо `YQL::CurrentUtcDatetime()` в теле запроса), 
так как вычисленное значение кешируется в подготовленном запросе.

