# Модель аварии

## Теория { #theory }

"(Техническая) модель аварии" &mdash; это несколько типовых вопросов, которые стоит прояснить для каждой аварии.  
Эти вопросы должны помочь обрабатывать аварии более предсказуемо и надежно. 

## Модель

### Коротко

- наблюдения (жалобы, воспроизведение, логи, графики)
- механика проблемы (что приводит к неправильному поведению)
- архитектура проблемы (как распределяется по подсистемам)
- что делаем
- как проверяем

{% note info %}

Дальше идут более подробные описания каждого пункта.

{% endnote %}

### Проявления

- наблюдения (описания от пользователей)
- воспроизведение (продакшен, ТС, беты)
- логи 
- графики

Полезно для того, чтобы понять механику проблемы, решить как чинить и как проверять. 


#### Наблюдения 

Что делать: зафиксировать, что (неправильное) наблюдаем мы или пользователи. 

У проблемы может не быть надежного воспроизведения, мы можем не видеть ее
в логах и на графиках, можем не понимать ее механику.
Наблюдения есть всегда, их надо фиксировать. 

Полезно для генерации гипотез про механику и для поиска воспроизведения.


#### Воспроизведение

Что делать: увидеть конкретный экземпляр проблемы. 

Полезно уметь воспроизводить проблему на всех средах:  
1. В продакшене: для проверки после
2. На ТС: для тестирования хотфикса
3. На бете: для отладки фикса
4. limtest может пригодиться, чтобы потестировать фикс с продовыми данными


#### Логи

Что делать: увидеть поток проблемных событий в логах

Логи дают конкретные запросы для исследования и отладки плюс способ проверки, что фиксы помогают.


#### Графики

Что делать: увидеть поток проблемных событий на графике/графиках

На графиках видно масштаб и тренды, они дают способ проверки, что фиксы помогают.
После решения инцидента графики могут пригодиться, чтобы сделать новые или дотюнить существующие алерты.



#### Косвенные данные в графиках/логах

Если интересные события впрямую не логируются/не рисуются графиками,
может быть есть логи/графики, которые косвенно дают представление о проблеме?


### Механика проблемы

Что делать: разобраться, какая последовательность событий внутри системы ведет к неправильному поведению. 

Полезно для того, чтобы решить, как чинить.



### Архитектура проблемы

Что делать: представить, как проблема распределяется по структуре наших сервисов.

- какие сервисы затронуты и как?
- транспорты/обмены данными между сервисами?
- каков полный цикл жизни проблемного поведения?
- важный частный случай: порятся ли данные?

Полезно например для того, чтобы:  
- выбрать, где проще всего починить
- не потерять места, где нужны исправления
- вовремя исправить данные у себя и в соседних сервисах


### Что делаем

Что делать: собрать явный список "кто что делает прямо сейчас". 

Хорошо записать в комментарий в аварийном тикете и написать в аварийном чате.

Полезно для того, чтобы не потерять нужные действия и не дублировать работу. 


### Как проверять починку

Что делать: заранее (до починки) явно сформулировать, как будем проверять, помогли ли фиксы/миграции/конфигурирование. 

Типичные варианты: сценарии для проверки в продакшене, графики, выборки логов.

Полезно для того, чтобы после деплоя фикса не протерять недочиненное.

## Ссылки { #links }

пока пусто

