# Оформление SPI
Эта инструкция про заведение и оформление аварий Директа SPI—тикетами.

SPI — общая очередь для разбора аварий в Яндексе.
Наши аварии размечены [компонентой direct](https://st.yandex-team.ru/SPI/order:updated:false/filter?components=84635).

{% note tip %}

В описании SPI-тикетов есть подсказки по заполнению (написаны серым) — не удаляйте их.

{% endnote %}

### Как устроена эта страница?
Вначале идут разделы про создание SPI: [быстрым](#fast-create-spi) (для аварий "прямо сейчас") или [подробным](#carefully-create-spi) (при оформлении прошедшей аварии) способом.

Дальше перечислено, как заполнить аварию: [{#T}](#what), [{#T}](#timeline), [{#T}](#where), [{#T}](#details) и [{#T}](#direct-markup).
Для удобства это собрано в отдельную шпаргалку [{#T}](#after-incident) внизу страницы.

Последним идёт раздел про [{#T}](#solved-spi-fields), он отвечает на вопрос "Что ещё должно быть, чтобы закрыть тикет?".

## Завести SPI быстро { #fast-create-spi }
В чате где добавлен `@YaIncBot` (например: Дежурство в Директе, чат протокола) или в [личке с ботом](https://t.me/YaIncBot):
1. Скомандуй `/newspi direct коротко что происходит`
1. Нажми кнопку **direct/подсистема** или **direct** если сомневаешься с выбором. Там ещё есть direct_vertical — его нажимать не надо
1. Нажми кнопку **Создать SPI**

Созданным тикетом можно делиться со всеми заинтересованными.

Еще один способ (нужен VPN): открыть тикенатор по [этой ссылке](https://tickenator.z.yandex-team.ru/new-ticket/spi?parent_component=direct),
выбрать **Контур** `production`, вписать коротко что происходит в поле **Заголовок** и нажать внизку кнопку **Создать** — готово!


## Завести SPI через тикенатор { #carefully-create-spi }
Этот способ подойдёт при заведении тикета уже после завершения инцидента, в спокойной обстановке.
Для этого нужно открыть [тикенатор](https://tickenator.z.yandex-team.ru/new-ticket/spi?parent_component=direct), заполнить его поля и создать тикет.

Ниже есть [табличка с перечислением полей](#tickenator-fields), доступных к заполнению в тикенаторе.


## Опиши поломку { #what }

### Суть { #title }
Суть аварии — коротко описываем проявление инцидента как его видим, например:
- сработал такой-то мониторинг
- 500ки в апи
- тормозит экспорт в модерацию
- ошибки в статистике
- ошибки при сохранении

Пишется в **заголовке** тикета (подробнее о том, [как он формируется](#ticket-title)).
Название потом можно поменять, если по ходу разбора лучше поняли суть произошедшего.
Например заменить "сработал мониторинг XXX" на "ошибки в статистике", или "500ки в интерфейсе" на "ошибки при сохранении объявлений".

### Что во время инцидента видели пользователи { #what-saw }
Напиши как авария себя проявила для пользователей или смежного сервиса.
Если есть примерное понимание кого затронуло — укажи здесь же.

Пишется в соответствующий раздел **описания**.

### Описание { #summary }
Здесь нужно коротко (в пару предложений) и понятно (для коллег) написать что произошло и причины возникновения.

Пишется в соответствующий раздел **описания**.


## Укажи таймлайн { #timeline }
В авариях можно выделить 5 ключевых моментов (из них: mitigate и completion — необязательные).  
Короткое название — в какое поле трекера пишем — описание:
1. `begin` — [{#T}](#begin-time) — начало влияния на пользователей ("пользователи начали страдать")
1. `notification` — [{#T}](#notification-time) — обнаружение ("осознали как аварию")
1. `mitigate` — [{#T}](#mitigate-time) — значительное уменьшение влияния ("пользователи радикально меньше страдают")
1. `end` — [{#T}](#end-time) — окончание влияния на пользователей ("пользователи перестали страдать")
1. `completion` — [{#T}](#completion-time) — окончание работ по устранению аварии ("команда перестала страдать")

Обычно события развиваются именно в таком порядке, но возможны ситуации:
- `begin = end` — внешние пользователи не страдали, проблема внутренняя
- `mitigate = end` — устранили негативное влияние: сразу всё и для всех
- `completion = end` — после устранения влияния ничего дополнительно не делали и беспокойства не испытывали
- `completion < end` — система еще восстаналивалась, но мы за ней не следили
- `end < notification` — аварию заметили уже после того, как она сама прошла

В тикете есть поля с похожими названиями, но в разделе **SRO** — их заполнять или редактировать **не нужно**.

### SRE: Время начала | Begin Time { #begin-time }
Время когда инцидент начал себя проявлять на конечных и/или внутренних пользователях.  
Например стал заметен на графиках или в логах. Также может быть временем получения жалобы от пользователя или сообщения от команды.

Для мониторингов нужно учитывать задержку или порог срабатывания (вычесть из времени срабатывания).
Для багов, выкаченных с релизом или проявившимся при переключении фичи/проперти — брать время релиза/переключения (исключение: для однозначно идентифицируемых по логам ошибок — взять время первой ошибки).

### SRE: Время уведомления | Notification Time { #notification-time }
Когда дежурный принял информацию об инцидентне и начал работать над ним.

Обычно задаем по времени _ответа_ на сообщени о проблеме в чате "Дежурство в Директе".
По умолчанию подставляется время создания тикета.

### Релиз: Дата выкладки в прод | Production date { #mitigate-time }
Время купирования проблемы, при котором влияние на пользователей значительно уменьшается.
Обычно совпадает с временем окончания (влияния на пользователей).

Что сюда подходит:
- починка большей части битых данных

### SRE: Время окончания | End Time { #end-time }
Время, когда поведение пришло в норму и влияния на внешних/внутренних пользователей больше нет.

Включает в себя стабилизацию системы, например нагон отставания или разбор накопившихся очередей до типовых значений.

### Антиадблок: Конец инцидента | Incident end { #completion-time }
Время окончания работ по устранению аварии.
Обычно совпадает с временем окончания, разницей в единицы минут можно пренебречь.

Бывает больше него, когда ещё что-то делаем после устранения влияния на пользователей:
- возвращаем откаченный релиз
- открываем закрытый ДЦ
- откатываем бажный код из транка, пишем тикеты на починку, собираем дополнительную диагностику
- следим за ситуацией по логам/графикам до выезда нормального фикса

Бывает наоборот — раньше времени окончания, к примеру: удостоверились по графикам что "догоняется" и перестали следить (полагаясь на мониторинг).

### Хронология событий { #chronology }
В **описании** тикета есть соответствующий раздел — напиши в нём:
- что именно вызвало аварию (событие, выкладка, переключение фич/пропертей)
- как обнаружили (кто/где зарепортил проблему или когда отреагировали на мониторинг)
- основные этапы починки
- как и когда уведомили смежников и анонсировали во внутренних координационных чатах
- когда пользователи перестали замечать проявление проблемы / починка полностью закончилась

Для тикетов, заведенных роботом — хронологию дописываем после таблички о сработавших проверках.

{% note info "Используй следующий формат" %}

Если хронология укладывается в один день, то формат такой:
```
- 9:10 — выложили бажную задачу такую-то с релизом
- 12:15 — в дежурный чат пожаловались на проблему
- 13:00 — откатили релиз
- 14:50 — собрали и выложили хотфикс
```
Если дней несколько — выделяем их bold'ом и помещаем между списками:
```
**28.06**
- 19:30 — случилось событие
- 21:12 — заметили
**29.06**
- 13:10 — начали чинить
```

{% endnote %}

## Уточни область поломки { #where }
Указываем в какой части директа произошла авария.

### Подсистема { #service }
Отражает наше [внутреннее деление](https://warden.z.yandex-team.ru/components/direct/services) по крупным сущностям:
- `WEB` — проблемы только с веб-интерфейсом
- `API` — проблемы только в API
- `CANVAS` — конструктор креативов (часть web + подкапотные штуки)
- `COMMANDER` — Директ.Коммандер
- `BSEXPORT` — экспорт в БК (старый и новый), без учёта YT-выгрузок для аудита
- `BACKGROUND-SERVICES` — проблемы с фоновыми процессами: интапи, транспорты, экспорты _(в будущем будем выделять их в отдельные сервисы)_
- `DB-MYSQL` — аварии с БД
- `NP` — проблемы с непродакшеном (стенды, инфраструктура, командные процессы)

В тикете указывается **тегом** `service:XXX`.

Для аварий, касающихся всего Директа (например с базой) или нескольких подсистем сразу — нужно ставить **тег** `service:ALL`.
При сложностях с локализацией аварии — тоже.

### ДЦ { #dc }
В какой локации случилась авария: `all` или конкретный датацентр.

В тикете нужно поставить **тег** `dc:xxx` или `dc:all`.
Если ДЦ несколько или неприменимо — ставить `dc:all`.

### Участие внешних сервисов { #external-service }
Авария может быть связана с другими сервисами.  
В этом случае поставь тег:
- `direct:#caused_by_external_service_failure` — если сбой внешнего сервиса привёл к проблемам у нас
- `direct:#affected_external_service` — для обратных случаев — наш инцидент привел к проблемам у смежников
- `direct:#external_service` — в сложных и неоднозначных ситуациях

Также отметь тегом, с каким именно сервисом связана авария:
- `direct:@advq` — ADVQ
- `direct:@balance` — платежные сервисы (баланс, траст)
- `direct:@bm` — BroadMatch, BannerLand
- `direct:@bs` — BannerStorage
- `direct:@chats` — чат с саппортом (ABC: [Веб-мессенджер и операторский интерфейс](https://abc.yandex-team.ru/services/chatswithbusinesses))
- `direct:@directmod` — модерация
- `direct:@doccenter` — докцентр
- `direct:@grut` - GrUT
- `direct:@idm` — управлятор
- `direct:@logbroker` — Logbroker
- `direct:@lpc` — конструктор турболендингов
- `direct:@mdb` — базы в MDB
- `direct:@mds` — сервисы MDS: сам MDS, S3, Аватарница
- `direct:@metrika` — Метрика и её сервисы
- `direct:@pcode` — показывающий код (превью объявлений, прочее)
- `direct:@sprav` — справочник организаций
- `direct:@telephony` — Телефония ([коллтрекинг](https://abc.yandex-team.ru/services/internaltelephony/))
- `direct:@transfer_manager` — Transfer Manager (копирование таблиц между кластерами YT, репликация бинлогов)
- `direct:@yabs` — сервисы БК: движок, транспорт, статистика, контент-система и прочие
- `direct:@ydb` — базы в YDB
- `direct:@yt` — YT
- `direct:@zora` — сервисы Zora: сама Zora, Rotor
- если нужного тега с префиксом `direct:@` не нашлось — добавь сам или попроси [ppalex@](https://staff.yandex-team.ru/ppalex)/[maxlog@](https://staff.yandex-team.ru/maxlog)

### Баг фронта { #frontend-bug }
Инциденты из-за функциональных багов на фронтенде размечаем тегом `direct:@direct_front`.

### Окружение { #env }
В каком окружении случилась авария.
У нас пока только `prod` _(если понадобятся другие — напиши [ppalex@](https://staff.yandex-team.ru/ppalex))_.

В тикете указывается **тегом** `env:xxx`.

### Компонента { #product }
Аварии должны быть привязаны к [нашей _компоненте_](https://warden.z.yandex-team.ru/components/direct) в каталоге дежсмены — `DIRECT`.
Для этого на тикете должны быть:
- **компонента** `@direct`
- **тег** `product:PROD-DIRECT`


## Добавь подробностей { #details }

### SRE: impact { #impact }
Укажи тип влияния на пользователей:
- `internal` — на внутренних пользователей. То есть это либо проблемы инфраструктуры, не затрагивающие сервис, либо проблемы без страдания внешних пользователей
- `external` — инцидент повлиял на внешних пользователей, они заметили проблему

### Действия дежурного { #duty-actions }
В этом разделе **Описания** можно перечислить действия для устранения проблемы.

Условный пример: _искал тестировщика для воспроизведения проблемы, воспроизвели, затем привлек дежурного по фронту, он передал задачу дежурному по ZBP, тот починил, я собрал хотфикс — выложили, проверили в проде_.

Постарайтесь не дублировать сюда то, что уже написано в [{#T}](#chronology).
Если написать нечего — нормально оставить этот раздел пустым.

### Диагностика { #diag }
Добавь в этот раздел **Описания** ключевые ссылки / логи / графики — те, которые помогают понять время и масштаб проблемы.
Остальное оставь в комментариях.
Длинные ссылки или графики стоит прятать под кат с описанием.

### Рекрутмент: Описание источника | Source description { #source }
**Источник обнаружения** — откуда мы узнали о проблеме _(если источников несколько — укажи более широкий)_.  
Типовые значения (от широкого к узкому):

- `жалобы пользователей` — обращения из поддержки, комментарии в интернете
- `сигнал от смежников` — от коллег из других отделов, например: модерации или БК, эксплуатации общеяндексовой инфраструктуры
- `команда` — сотрудники [отдела Директ](https://staff.yandex-team.ru/persons/yandex_monetize_search_direct_interface?structure=show&show=structure), а также — _личные_ (не app-duty) или _случайно замеченные_ мониторинги
- `мониторинг` — уведомление от настроенного алерта


### Откатывали? { #rollback }
Поставь **тег** `rollback`, если для тушения пожара откатывались релизы.
Даже если проблема оказалась не в них.

### Дополнительная разметка { #extra }
{% note info %}

В этом разделе описаны данные, которые не имеют прямого использования, но могут быть полезны для аналитики или понимания сути инцидента в будущем.

Заполнять их или нет — на усмотрение размечающего.
Предполагаем, что долгих споров или обсуждений вокруг этих сведений не должно быть.

{% endnote %}

#### фунциональный баг? — ставь тег `direct:#functional_bug` { #functional-bug }
Код работал не так, как ожидал автор. Ошибка при этом может быть в сторонней библиотеке.  
Если код вёл себя в соответствии с ожиданиями автора, но ожидания были неверны, то это [`direct:#miscommunication`](#miscommunication).  
Проверочный критерий: проблему можно обнаружить тестированием.  
Примеры:
- не работает кнопка в интерфейсе в старых браузерах;
- сохраняли некорректные данные, потому что не было валидации;
- запрос падает при недоступности одного из кластеров.

Не сюда:
- падали, потому что пытались записать в ещё не созданный топик (это [`direct:#miscommunication`](#miscommunication));
- долгий запрос забил сonnection pool (это [`direct:#capacity_and_performance`](#capacity-and-performance));
- проблемы в многопоточности.
Теоретически их можно отлавливать тестированием или формально доказывать корректность программы.
Но на практике это неоправданно дорого.

#### недопонимание в процессе? — ставь тег `direct:#miscommunication` { #miscommunication }
Имеется в виду недопонимание, которое можно исправить, научив людей договариваться.  
Примеры:
- падали, потому что пытались записать в ещё не созданный топик (ожидали, что топик кто-то создал);
- начали отправлять в БК ресурс, который не совпал по формату с ожидаемым.

Не сюда:
- пропустили шаг в инструкции;
- не смогли договориться с ботом.

#### пугающий потенциал — тег `direct:#scary` { #scary }
Если у инцидента был потенциал развиться в значительно более серьезное происшествие
(но нам повезло и этого не случилось) — поставь этот тег.  
Подходящие ситуации:
- Инструменты или договоренности, на которые мы полагались — не сработали
- "Мы (**команда**) испугались"
- "Могло быть (гораздо) хуже, но пронесло".

#### инцидент обусловлен ограниченностью ресурсов? — ставь тег `direct:#capacity_and_performance` { #capacity-and-performance }
Проверочный вопрос: случилось бы произошедшее, если бы ресурсов (памяти, диска, скорости процессора, воркеров) было в N раз больше?  
Подходящие примеры:
- экспоненциальный по памяти вычислительный процесс при обработке запроса клиента (отставание [alw](../glossary/glossary.md#java-alw) при обработке частых изменений hierarchical_multipliers одним клиентом)
- логи, забивающие место на персистентном томе контейнера
- торги в БК тормозят, потому что мы стали задавать больше запросов
- страница в интерфейсе тормозит из-за большого размера/медленно выполняющихся скриптов
- jobs тормозят после отключения ДЦ, потому что на всё не хватает тредов

Что не подходит:
- забилась очередь из-за падающего на NPE приложения — никакое увеличение количества воркеров не поможет
- медленно разгребается очередь из-за падающего раз в 5 минут на NPE приложения — с б*о*льшими ресурсами очередь будет разгребаться быстрее, но проблема с NPE остаётся
- форк-бомба — не хватит никакого наперёд заданного количества ресурсов

#### инцидент обусловлен некорректными данными - ставь тег `direct:#data_corrupted` { #data_corrupted }
Проблема связана невалидными, неконсистентными или отсутствующими данными в базе. Примеры:
- из-за ошибочной или отсутствующей валидации сохраняли неправильные данные
- ваншотом изменили/удалили что-то не то
- разъехались данные между mysql и репликой в YT

#### проблемы сетевого стека — ставь тег `direct:#network` { #network }
Все что касается пересылки сетевых пакетов — сюда. Примеры:
- умер маршрутизатор (это еще и `direct:#hardware`);
- программные вопросы маршрутизации и балансирования трафика;
- нет дырок;
- есть дырки и сетевые доступы, которых быть не должно;
- прописаны не правильные правила файерволла (это может быть еще и `direct:@infrastructure`);

Не сюда:
- DDoS запросами (это [`direct:#capacity_and_performance`](#capacity-and-performance));

#### вызвана недавно выложенным кодом — ставь тег `direct:#recently_released` { #recently_released }
Для аварий, в которых проблему стриггерил недавно выложенный код.

#### вызвана недавними изменениями в инфре – ставь тег `direct:#recently_operated` { #recently_operated }
Недавно делались (ручные) изменения в инфраструктуре, приведшие и связанные с аварией.

#### вызвана изменением флагов — ставь тег `direct:#flags_operated` { #flags_operated }
Для аварий, вызванных изменением пропертей, включением/отключением фич.

## Оцени аварию { #direct-markup }
Директо-специфичная, оценочная часть разметки. Используем для аналитики инцидентов и дашборда.

### Влияние на клиентов { #impact-clients }
Оценка тяжести проблемы по влиянию на клиентов.  
Основные критерии тяжелой проблемы:

- про деньги (зачисления и статистика, показ не по тем ставкам или не в том объеме)
- непрозрачность (ошибка, невидимая клиенту — хуже видимой)
- стабильность проблемы (перезагрузка страницы не помогает)
- затронута основная/популярная функциональность (сохранение текстовых объявлений, доставка в БК)

Длительность ≠ тяжесть. Массовость — не учитываем, т.к. она выражается в доле пострадавших клиентов
<br/>Влияние на внутренних пользователей (менеджеров Яндекса) учитываем как на клиентов, но с меньшим весом.

Поставь один из четырёх тегов:
- `direct:$impact_clients_0_none` — без влияния на внешних пользователей:
  - отставание логов в LogViewer'е, его ошибки
  - поломки только мониторинга, но не самого процесса
  - экспорты данных из директа во внешние сервисы или хранилища, когда мы точно знаем об отсутствии влияния их на клиентов (например аудит ставок БК) или не знаем об этом совсем
  - разовый сбой, укладывающийся в "обычное время работы" этого процесса (например один-два раза не отправили уведомление о понижении позиции, но отправили на следующий запуск через 20 минут)
- `direct:$impact_clients_1_low` — низкое:
  - статистика не работает у нескольких сотен клиентов (0.5%) в течение 10-15 минут
- `direct:$impact_clients_2_mid` — среднее:
  - не работает получение статистики (мастер отчетов) у заметной части клиентов (больше 10% или 5000)
  - затронута основная функциональность (сохранение объявлений и кампаний, их отображение)
  - не работает API (меньше 10 минут)
  - задержка активизации более 2 часов по 80% перцентилю (даже в одном шарде)
  - до 1.5 часов не работает модерация сайтлинков или текстовых баннеров в _одном_ шарде
  - не работает превью объявлений
- `direct:$impact_clients_3_high` — высокое:
  - не работает оплата
  - неверное отображение остатка денежных средств
  - массовая порча данных или ставок
  - не работает весь интерфейс
  - API не работает 10 и больше минут
  - больше часа не работает модерация сайтлинков или текстовых баннеров


### Влияние на команду { #impact-team }
Тяжесть проблемы для команды (усилия и беспокойство, непредсказуемость длительности, количество участвующих в починке).  
Поставь один из трёх тегов:

- `direct:$impact_team_1_low` — низкое:
  - проблемой занимались в рабочее время
  - было понятно "что делать" или возникали умеренные сложности
  - участие эксперта ограничено консультацией, без глубокого погружения в диагностику или починку
- `direct:$impact_team_2_mid` — среднее:
  - чинили проблему ночью или в поздне вечернее время
  - были заметные сложности с диагностикой или исправлением
  - привлеченный эксперт глубоко погружен в диагностику или занят починкой
  - в починке участвовало больше 2 человек
  - участвовал кто-то не из дежурных (если это была не рутина)
- `direct:$impact_team_3_high` — высокое:
  - "весь отдел участвует в починке"
  - многодневная авария, с full-time починкой
  - ночные нетривиальные аварии
  - сочетание нескольких факторов, например несколько человек от сервиса в выходной день
  - понятно что происходит что-то ужасное, но все остальное непонятно (как сломалось и что делать)
  - "напряженная атмосфера"

У инцидентов возможны долгосрочные последствия, такие как:
потеря логов.  
Их влияние на дальнейшую работу команды тоже нужно учитывать.

### Про деньги { #money }
```
direct:$$$
```
Поставь этот тег в случаях, если у нас:

{% include [примеры](_includes/money-incident-examples.md) %}

## Проверка разметки { #direct-incident-review }
После уточнения деталей и общего согласия с разметкой — ставим на тикет тег `reviewed`.

В этот момент времени выбираем, какой разбор аварии хотим устроить (и ставим соответствующй тег):
- `review_level:unwanted` — не хотим делать разбор
- `review_level:min` — хотим обсудить минимальным составом (mokeev@, ppalex@)
- `review_level:team` — выносим на Директовый разбор аварий
- `review_level:adv` — выносим на рекламный LSR

## Разбор SPI { #solved-spi-fields }
Заключительная часть оформления (при разборе). 

В этом разделе описано что ещё и как нужно заполнить, чтобы можно было закрыть инцидент.

### Action Items { #action-items }
Секция в описании инцидента, в которую записываем задачи на устранение причин появления инцидента.
Их нужно пометить тегом `spi:actionitem` и прилинковать к иницденту.

### SRO: Incident Reporter { #incident-reporter }
Кто принёс проблему:
- `user` — наши клиенты
- `monitoring` — по сработавшему мониторингу
- `marty` — дежурная смена
- `service` — мы сами (команда Директа) заметила проблему
- `external` — проблему принесли снаружи, например написали в новостях (жалобы на фейсбуке?)

По своему смыслу эта разметка очень близка к [{#T}](#source) и наш робот старается заполнить значение автоматически.

### SRO: Incident Protocol { #incident-protocol }
По какому протоколу разобран инцидент: `green` / `yellow` / `orange` / `red`. Описания для каждого протокола есть в [ссылках](#useful-links).

В большинстве случаев для нас это `green` (зеленый протокол) — инцидент решен силами дежурных или команды.
Возможен жёлтый — к решению инцидента привлекали [marty](../glossary/glossary.md#marty) (дежсмену).

### SRO: Минус 1 ДЦ | Minus 1 DC { #minus-dc }
Поставь `Да`  в этом **поле**, если инцидент связан с аварией ДЦ, регламентными работами / учениями или подготовке к ним.

### SRE: support_line { #support-line }
Чьими силами починили (сделали так, что пользователи больше не страдают и приборы не горят):
- `unknown` — не заполнено
- `devops` — app—duty, дежурный direct—admin или по продакшену фронтенда
- `service` — вся остальная команда Директа
- `marty` — инцидент ликвидировала дежурная смена или он прошел сам
- `noc` — дежурные NOC
- `platform` — дежурные платформы

### SRE: SRE area { #sre-area }
Из-за чего сломалось. Верхнеуровневое описание локализации проблемы.

Можно указать несколько значений. Копия описания из [таблички](https://wiki.yandex-team.ru/devops/Dive-into-DevOps/incidents-attrs/):
- **human** — человеческая ошибка, не контролируемая никакой автоматикой или всё, что попадает под термин "незнание не освобождает от ответственности"
- **operations** — инцидент случился при регламентных операциях, учениях
- **release** — проблема возникла при релизе компонента
- **bug** — ошибка в коде, которая не была замечена ни в тестах, ни при релизе, а проявилась при ином стечении обстоятельств
- **service** — проблема в архитектурном устройстве сервиса или взаимодействии его с другими смежными сервисами
- **net** — аварии сетевой инфраструктуры
- **platform** — аварии платформы / проблемы во взаимодействии с облачной платформой (например неправильно посчитанные лимиты) / наведенный эффект соседнего сервиса / проблемы железа / etc
- **mds** — аварии MDS/S3
- **saas** — аварии Search as a Service
- **apphost** — аварии инфраструктуры AppHost
- **balancer** — аварии системы балансировки трафика
- **monitoring** — некорректно настроенные алерты, подземные стуки
- **external** — внешнее событие, например: новостной повод, приведший к непрогнозируемому росту нагрузки / авария внешней связности провайдеров

### SRE: Даунтайм Яндекса | Yandex Downtime{ #ydt }
Рассчитывается как [даунтайм вертикали](#vdt) умноженный на вес вертикали.
С 8 февраля в качестве эксперимента, мы считаем наши аварии по весу `0.02`.

### SRE: Даунтайм вертикали | Vertical Downtime { #vdt }
Нужно определить наш даунтайм (вес аварии, приведенный в секунды) и записать в это поле.
Методику вырабатываем на соседней странице — [{#T}](assessment/how-to.md#calculate-vdt).

## Примечания { #notes }
Здесь обобщены несколько сценариев заполнения тикета, а также упомянуты дополнительные поля.

### Поля тикенатора { #tickenator-fields }
Имя | Ссылка на описание | Пример значения
:--- | :--- | :---
Компонента | [{#T}](#product) | `direct`
Сервис | [{#T}](#service) | оставить пустым (затронуло весь директ или несколько подсистем) или выбрать значение
Контур | [{#T}](#env) | `prod`
Датацентр | [{#T}](#dc) | `dc:all`, `dc:vla`
Линия поддержки | [{#T}](#support-line) | service
Кто обнаружил проблему | [{#T}](#incident-reporter) | user
Время уведомления | [{#T}](#notification-time) | 03 декабря 2020 в 18:01
Начало проявления | [{#T}](#begin-time) | 03 декабря 2020 в 15:55
Конец проявления | [{#T}](#end-time) | 03 декабря 2020 в 18:34
Алерт/Проверка | не используем | 
Заголовок | [{#T}](#title) | недоступность мастеров БД
Описание | [{#T}](#summary) | Выполняли штатное переключение мастера метабазы перед учениями. Закрыли фаерволом старый хост, но из-за ошибки не смогли сохранить в конфигурации БД новый.
Действия дежурного | [{#T}](#duty-actions) | откатили релиз <тикет>
Протокол | [{#T}](#incident-protocol) | green
Rollback | [{#T}](#rollback) | поставить галочку, если откатывали релизы
-1 датацентр | [{#T}](#minus-dc) | поставить галочку, если связано с аварией ДЦ / регламентными работами или подготовке к ним


### Заголовок тикета { #ticket-title }
[{#T}](#notification-time), [{#T}](#env), [{#T}](#product), [{#T}](#service), [{#T}](#title) и [{#T}](#dc) — формируют собой название тикета в виде:
```text
[NOTIFICATION_DATE] ENV—PRODUCT / SERVICE: TITLE (DC)
```
Примеры:
- `[2020.11.09] PRODUCTION-DIRECT: недоступность мастеров БД (ALL)`
- `[2020.11.18] PRODUCTION-DIRECT / WEB: тест тикета с заданным сервисом (ALL)`
- `[2020.12.02] PRODUCTION-DIRECT / BACKGROUND-SERVICES: test dc (VLA)`

### Поля для base_markup_required { #base-markup-required-fields } { #basic-markup-required-fields }
Пока эти поля не заполнены — робот будет ставить на инциденте тег `base_markup_required`.
После заполнения — снимет тег в течение 20 минут.

Актуальный список — в [коде](https://a.yandex-team.ru/arc_vcs/direct/apps/chassis/src/main/java/ru/yandex/direct/chassis/entity/reports/incident/IncidentsReporter.java#L550).

Что | В тикете это | Примеры значения
:--- | :--- | :---
[Хронологию событий](#chronology) | раздел описания | 12:00 — сработал алерт на ошибки в ErrorBooster<br/>12:06 — предупредили в дежурном чатике о проблеме<br/>12:20 — придумали фикс<br/>12:45 — захотфиксили<br/>12:52 — выложили<br/>13:01 — проверили в продакшене что всё починилось
[{#T}](#what-saw) | раздел описания | У клиентов при сохранении объявлений типа NNN не сохранялись изменения, отображалось "Произошла ошибка"
[Описание](#summary) | раздел описания | Выложили задачу с багом (тикет), стали вылетать NPE при редактировании NNN типа объявлений
[Источник обнаружения](#source) | **Рекрутмент**:&nbsp;**Описание&nbsp;источника** (**Recruitment**:&nbsp;**Source&nbsp;description**) | жалобы пользователей
[{#T}](#impact-team) | тег | `direct:$impact_team_3_high`
[{#T}](#impact) | **SRE**: **impact** | external
[Время уведомления](#notification-time) | **SRE**: **Время&nbsp;уведомления** (**Notification&nbsp;Time**) | 03 декабря 2020 в 18:01
[Время окончания](#end-time) | **SRE**: **Время&nbsp;окончания** (**End&nbsp;Time**) | 03 декабря 2020 в 18:34


### Какие поля надо включить в трекере {#enable-fields}
Некоторые из используемых нами полей тикета – по умолчанию скрыты.
Нужно включить (один раз) их отображение, использовав кнопку `Выбрать поля` ( `Select fields`) в правой верхней части тикета.
Поля ищутся по их именам.
Список нестандартных (в скобках дано имя раздела):
- Описание источника (Рекрутмент)

Другие поля (использовались раньше):
- Конец инцидента (Антиадблок)
- Дата выкладки в прод (Релиз)

### Что заполнять после аварии { #after-incident }
1. Про суть аварии:
   1. Поправь [заголовок](#title) тикета если нужно
   1. Напиши [{#T}](#what-saw)
   1. [Опиши](#summary) как произошла авария
1. Запиши текстом [хронологию событий](#chronology) — это потом поможет понять, откуда взяты те или иные времена
1. Проставь времена ключевых ([шпаргалка](#timeline)) моментов в поля:
   1. Время начала проявления на пользователей — в [{#T}](#begin-time)
   1. Время окончания проявления на пользователей — в [{#T}](#end-time)
   1. Поправь (если сильно отличается) [{#T}](#notification-time)
1. Добавь подробностей:
   1. Внешняя проблема или внутренняя? (поле [{#T}](#impact))
   1. Авария из-за бага на фронте? — поставь тег `direct:@direct_front`.
   1. Запиши [источник обнаружения](#source)
   1. Напиши свои действия в [{#T}](#duty-actions)
   1. Если откатывал релизы, поставь тег `rollback`
   1. Собери ключевые графики или логи под кат в раздел [{#T}](#diag)
   1. если в аварии участвовали [внешние сервисы](#external-service) — поставь соответствующие теги
1. Оцени аварию:
   1. По [влиянию на клиентов](#impact-clients) (тег `direct:$impact_clients_...`)
   1. По [влиянию на команду](#impact-team) (тег `direct:$impact_team_...`)
   1. Если авария [про деньги](#money) — поставь тег `direct:$$$`
1. Всё готово, инцидент отлично размечен! 🎉

{% note tip "Нужна помощь?" %}

Cпрашивай в канале [#direct-incidents]({{incidents-channel}})

{% endnote %}

### Рабочее/нерабочее время { #hours }
{% note info %}

Простановка этих тегов автоматизирована.  
Если кажется, что авария должны быть размечена по-другому — поставь тег `auto_processed_working_hours` (он отключит автоматику) и разметь правильно.

{% endnote %}

Хотим понимать, насколько аварии вмешиваются в нерабочую жизнь участников. 
Для этого размечаем, на какое время пришлась починка аварии: рабочее, вечеренее, ночное, выходные. 

Проставь тикету один из тегов:

- `direct:!working_hours` &mdash; работы по аварии начались и закончились в штатное время (условно с 10 до 21 часов); если авария продолжалась несколько дней, то вечерней и ночной работы не требовалось
- `direct:!long_hours` &mdash; починка растянулась на поздний вечер (захватила время с 21 до 24 или с 7 до 10 часов)
- `direct:!night` &mdash; ночь; починка захватила время после полуночи
- `direct:!weekend` &mdash; починка захватила выходные или официальные праздники

Если авария разворачивалась ночью с субботы на воскресенье, то стоит проставить два тега: `direct:!night`, `direct:!weekend`. В остальных случаях ожидается, что будет только один тег про время. 

### Сотрудники: Дежурный | Duty { #duty }
В это поле можно записать людей (app—duty, админов, продовых дежурных по фронту), следящих и принимающих активное участие в рассмотрении инцидента (устранении пожара, разбора). Это позволит видеть статистику по людям.

### Tools: Разметивший | Marked { #marked }
В этом поле мы указываем логин (или несколько) коллег, оформлявших этот тикет.  
Нужно, чтобы исключать их из призывов на проверку правильности оформления (нет смысла проверять самого себя) и учета статистики.

## Полезные ссылки { #useful-links }
- [Тикенатор](https://tickenator.z.yandex-team.ru/)
- [Таблица разметки тикета в очереди SPI](https://wiki.yandex-team.ru/devops/Dive-into-DevOps/incidents-attrs/)
- Протоколы коориданции: [красный](https://wiki.yandex-team.ru/jandekspoisk/sepe/dezhurnajasmena/procedures/plan-jevakuacii-pri-incidente/), [оранжевый](https://wiki.yandex-team.ru/jandekspoisk/sepe/dezhurnajasmena/procedures/oranzhevyjj-protokol-reglament-i-rekomendacii-po-rabote/), [жёлтый](https://wiki.yandex-team.ru/jandekspoisk/sepe/dezhurnajasmena/procedures/zheltyjj-protokol-reglament-i-rekomendacii-po-rabote/) и [зеленый](https://wiki.yandex-team.ru/jandekspoisk/sepe/dezhurnajasmena/procedures/zelenyjj-protokol/)
- [Автоматика, которая делает часть разметки](https://a.yandex-team.ru/arc_vcs/direct/apps/chassis/src/main/java/ru/yandex/direct/chassis/entity/reports/incident/IncidentsReporter.java)
