# Плановая недоступность ДЦ (учения, регламентные работы)

Статус документа: рабочий черновик.

Предыдущий источник: <https://wiki.yandex-team.ru/jeri/dc-downtime-prepare-checklist/>

## Теория, цель руководства { #purpose }

Подготовка, вход и выход для плановой недоступности ДЦ должны делаться предсказуемо и унифицированно.

Если возникают особые обстоятельства, их обработка и фиксация для истории тоже должна быть предсказуемой и унифицированной.

Здесь фиксируем ожидания: как именно все это должно делаться.


## Оформление { #paperwork }

Как только объявили дату и отключемый ДЦ: создать тикет в DIRECTADMIN.
Заголовок: `Минус ДЦ (учения|работы): (VLA|SAS|MAN|IVA) yyyy-mm-dd`.

Дальнейшую работу, связанную с этим отключением, фиксируем и координируем в этом тикете.

В тело тикета скопировать чеклист:

```
=== Заранее
* определить, что не будет работать (ppcdev-ы, тестовые смежные сервисы и т.п.)
* решить и записать, какие эксперименты в продакшене и непродакшене надо провести во время отключения

=== Непосредственно перед
* за сутки-двое: переключиться на clickhouse в ДЦ не под работами (см https://st.yandex-team.ru/DIRECTSUP-35180#5f9682bd4608322ec7fb62f1)
* за сутки: записать, кто из дежурных app-duty отвечает за продакшен, кто из дежурных по ((https://docs.yandex-team.ru/direct-dev/duty/direct-releases-duty релизы + ТС)) отвечает за непродакшен
* за пару часов в чате https://docs.yandex-team.ru/direct-dev/reference/chats?searchQuery=direct-dev-announces#direct-dev-announces предупредить о работах.
* за полчаса-час: проверить, что продакшен мастера переключились https://observatorium.common.yandex.ru/storages/replication_schema, иначе обратиться в чат https://t.me/joinchat/CCDG-0Dje_KWvyMQ-bFMtA
* за полчаса-час: закрыть продакшеновые сервисные машины по инструкции ниже
* за полчаса-час: закрыть непродакшеновые сервисные машины по инструкции ниже


=== Как закрывать сервисные машины
Перед закрытием необходимо:
* увести трафик из закрываемого ДЦ по https://docs.yandex-team.ru/direct-dev/jeri/howto-dc-l7
* притушить анонс балансеров по https://docs.yandex-team.ru/direct-dev/jeri/howto-awacs-shutdown-announce
Закрываем через
длi прода: https://firewall.yandex-team.ru/drills/add: сеть/project _PPCNETS_, DC, время работ, exclude %%_C_MODERATE_PERL_ _C_DIRECT_NG_MOD_DATABASES_MYSQL_PROD_ _C_DIRECT_NG_MOD_DATABASES_MYSQL_MODLOG_%%
время работ лучше указать больше, чем планируется, закончить работы можно по кнопке удалить

для непрода: сеть _PPCTESTNETS_, в exclude ничего не указывать

=== Во время
* запланированные эксперименты, если есть
* ...

=== Сразу после
* ...

=== После
* открыть продакшеновые машины
* открыть непродакшеновые машины

=== Отложенные действия
* ...
```

Если становится понятно, что до, во время или после этого конкретного отключения нужны дополнительные действия — дописываем в соответствующий раздел.

Выполненные пункты отмечаем `**(DONE)**`.

Пишем в ТГ отложенные сообщения на "минус двое рабочих суток" с напоминанием "скоро отключение, вот тикет" +
немедленное сообщение "Вот тикет на отключение, напоминалка придет тогда-то".

## Действия { #actions }

### Определить, что будет не работать { #what-will-be-unavailable }
Полезно посмотреть какие вообще базы (не только MySQL есть) есть в интересующем нас ДЦ
Например погрепав `/etc/yandex-direct/alldb-config.json`
```bash
hmepas@ppcback01i:~$ grep "vla\|m\." /etc/yandex-direct/alldb-config.json
                    "host": "vla-gzud7tp95ux1ll8l.db.yandex.net",
                    "dc": "vla",
                    "host": "ppcdata8-9m.da.yandex.ru",
                    "dc": "vla",
                    "host": "ppcdata8-9m.da.yandex.ru",
                    "dc": "vla",
```

Может отваливаться ```ppcgraphite.yandex.ru```, что будет зажигать основанные на нем проверки с ```Can't parse output from script```, тикет на улучшение ситуации https://st.yandex-team.ru/DIRECTADMIN-9021

Посмотреть куда смотрит ```http://ppctest-proxy.ppc.yandex.ru:7088/``` - это запущенный на ppcdev-ах varnishd. И если ppcdev, на который смотрит этот домен попадает под учения, то поправить DNS, чтобы этот алиас указывал на ppcdev не попадающий под учения, проверим что на онном вообще поднят. Пример исправлений в DNS: [коментарий в Стартреке](https://st.yandex-team.ru/DIRECT-96242#5cb831d75bd695001f3d50bd)

(сюда дописать список, что еще где смотреть)

### Запланировать и провести эксперименты

TODO: мотивацию к каждому эксперименты + на что хотим смотреть

#### Эксперименты для продакшена

Порестартить сервис(ы) в одном из ДЦ (если этот ДЦ не последний для сервиса)

Собрать хотфикс

Выложить релиз/хотфикс


#### Эксперименты для непродакшена

Собрать релиз

Запустить автотесты


### Переключить продакшеновые mysql

[Инструкция](./guide/mysql-switch-master.md)


### Переключить непродакшеновые mysql

(TODO ссылку на инструкцию)


### Закрыть сервисные машины

(TODO ссылку на инструкцию)


## Когда ДЦ вернулся


### redis

Может развалиться Redis Cluster, т.е. будет работать без репликации. Пример инструкции по починке [коментарий из тикета](https://st.yandex-team.ru/DIRECTADMIN-8997#5fc93f993b175f4fc10fd05a)
(TODO: перенести в документацию)

## Ссылки

- Страница на вики: <https://wiki.yandex-team.ru/jeri/dc-downtime-prepare-checklist/>

