# Заведение проверок над L7 балансерами

## Получение сырых событий:
Для того, чтобы начать собирать агрегаты над сырыми событиями, нам собственно эти события и понядобятся. По умолчанию их никто не шлет. Для того, чтобы их получить, может понадобиться голован или авакс, в зависимости от типов сигналов.
### Из Голована
Метрички с балансеров исторически летят в [голован](https://yasm.yandex-team.ru/). Попасть в них можно из раздела **Monitoring** аваксового неймспейса. По метричкам можно строить в самом головане алерты, которые превращаются в сырые события в джагглере, либо(_если идти в головане до конца_) в агрегаты с оповещениями. Но мы используем свои агрегаты со своими правилами, поэтому нам достаточно сырых событий. Для генерации алертов в головане есть шаблоны алертов. Для L7 сейчас есть два шаблона( на количество [500к](https://yasm.yandex-team.ru/template/alert/direct-l7-500/) и [400к](https://yasm.yandex-team.ru/template/alert/direct-l7-400/). При заведении неймспейса в аваксе достаточно провалиться в настройки этих шаблонов и добавить свой неймспес в список ```prjs``` и нажать применить. Появится алерт и полетят сырые события с хостом ```yasm_alert``` и именем алерта в качестве сервиса, например direct-l7-400.direct-logviewer.yandex.net
### Из awacs-а
Некоторые события уже посчитаны и по ним подобраны пороги командой оркестрации и включены в базовый модуль мониторинга, предоставляемый аваксом. Например, это "железные" метрички приложения _балансер_: расход CPU/памяти/места. Для получения их в джагглере необходимо активировать в аваксе, перейдя во вкладку **Alerting** в аваксовом неймспейсе и нажав кнопку "Enable Alerting".
{% note tip %}

Автоматически создадутся пара базовых джаглерных проверок, рекомендуется по максимуму убрать их, чтоб не спамило, но в связи с ограничением интерфейса авакса, в единственной оставшейся заменить метод оповещения на email, как на наименее инвазивный.

{% endnote %}

## Создание агрегатов
Для создания агрегатов над получившимися в прошлом шаге сырыми событиями используем нащ фреймворк над juggler-sdk. Подробнее о его принципах можно почитать [тут](../howto-directadmin-juggler.md).
Основные агрегаты про продакшеновые балансеры строятся скриптом [direct.prod_slb.py](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/directadmin-juggler/checks/direct.prod_slb.py). Балансеры перечислены в этом файле. Для получения агрегатов необходимо дописать аваксовый неймспейс в свойства балансера. Например: ```'awacs_namespace': "direct-logviewer.yandex.net"```. Построятся агрегаты по сервисам с тем же именем хоста, что и был у существующих проверок.

## Проброс "до приложения" на дашборде
Чтобы проверки(агрегаты из прошлого шага) стали частью красивого дашборда про здоровье приложений их необходимо добавить либо в [реестр приложений](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/direct-apps.conf.yaml), либо [реестр подсистем](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/direct-subsystems.yaml), либо в [реестр непродакшеновых проверок](https://a.yandex-team.ru/arc/trunk/arcadia/direct/infra/direct-utils/zk-sync/confs/direct-np.yaml), если речь не про продакшн.

## Инструкция для проверок
Все заводимые проверки необходимо снабжать инструкцией: как починить, куда смотреть, к кому бежать. Подробнее [здесь](../reference/juggler-alerts.md)

