[Как написать код ваншота](howto-code.md)


# Ваншотилка

## Какие задачи решаются с помощью ваншотилки {#goals}

Вам нужен ваншот, если:

- из-за бага в продакшеновом сервисе у вас накопились ошибочные данные, требующие исправления;
- вам необходимо перейти со старой структуры хранения объектов на новую, а для этого вам нужно перенести существующие данные в новый формат;
- вы хотите иметь возможность выполнять тяжеловесную работу по требованию (по кнопке), а не по расписанию, и под присмотром второй пары глаз;
- вы хотите получить возможность выполнять определенную тяжеловесную работу до реализации полноценного фонового процесса, на более раннем этапе.

Вам не нужен ваншот, если:

- вам нужно выполнять тяжеловесную работу автоматически по расписанию — в этом случае вам подойдет джоба;
- вы хотите иметь возможность выполнять определенную логику на раннем этапе разработки, до реализации полноценного сервиса, но эта логика не тяжеловесная и ее необязательно выполнять в фоне — в этом случае вам проще будет сделать инструмент в InternalTools (в приложении java-web).


## Участие в разработке

Если вы хотите внести свой вклад в ваншотолку, если у вас есть идеи по улучшению или желание писать код — приходите к [@mexicano](http://staff.yandex-team.ru/mexicano)!

Первоначально разработка велась в этом [тикете](https://st.yandex-team.ru/DIRECT-90687).
Доработки вынесены в отдельный [тикет](https://st.yandex-team.ru/DIRECT-116582). Туда можно добавлять новые идеи в виде сабтикетов.


## Исходные требования к механизму ваншотов

_Из каких соображений ваншотилка получилось именно такой._

- стандартный флоу кода ваншотов: ветка + юнит-тесты + ревью + коммит + деплой
- запрос на апрув, апрув (вместе с входными данными) и запуск ван-шотов — отдельные действия внутри приложения (в том смысле, что не в тикетах)
- поддержка одноразовых и многоразовых запусков
- возможность передавать входные данные для запуска ван-шота (с валидацией)
- сохранение состояния для долгоиграющих джоб
- параллельное выполнение на разных шардах с возможностью раздельного управления
- остановка/возобновление запуска ваншота (как целиком, так и по отдельным шардам)
- просмотр логов отдельно по каждому запуску и по каждому шарду
- показывать в истории ссылку на ревизию, из которой запускался ван-шот
- регламент на запуск ван-шотов: ограниченное время выполнения, необходимость сохранять состояние для долгоиграющих джоб
- мониторинги долгоиграющих запусков, устаревших ваншотов
- ван-шот ведётся целиком в одном тикете — новая очередь DIRECTONESHOT (при записи ван-шота в базе создается и далее в нем отражаются важные события)


## О системе в целом

Вся система состоит из следующих частей:

1. отдельное приложение `oneshot`, которое содержит классы ваншотов и выполняет их;
2. несколько таблиц в базе `ppcdict`, содержащих информацию о ваншотах, их запусках и состоянии процесса выполнения;
3. страницы в InternalTools в приложении java-web для управления ваншотами посредством таблиц в `ppcdict` из пункта 2 (java-web не общается с ваншотилкой напрямую, только через базу).

Модуль с ваншотами имеет зависимость от ядра, поэтому в ваншотах можно и даже желательно использовать код ядра, включая спринговые зависимости.

## Приложение oneshot

### Этапы работы приложения

Работа каждого инстанса приложения состоит из следующих этапов:

1. проверка актуальности собственной версии в базе (приложение будет выполнять полезную работу только если его версия актуальна);
1. актуализация версии и списка ваншотов в базе, если инстанс имеет самую свежую версию, которая запускается впервые;
1. запуск следующих потоков:
   1. валидации параметров запуска;
   1. выполнения кода ваншотов;
   1. актуализации времени последней активности;
   1. остановки мёртвых ваншотов.

### Виды потоков

_Поток валидации параметров запуска_ находит в базе запуски, готовые к валидации входных данных (см. [флоу запуска ваншотов](#lifecycle_oneshot-launch)). Этот поток проводит валидацию внутри себя, не порождая новых потоков.

_Поток запуска ваншотов_ находит в базе запуски, готовые к выполнению, и передает выполнение в отдельный тред-пул.

_Поток актуализации времени последней активности_ записывает в таблицу [oneshot_launch_data](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshot_launch_data.html) раз в 5 секунд текущее время для всех потоков выполнения, работающих на том же инстансе.

_Поток остановки мертвых ваншотов_ находит потоки выполнения в статусе "выполняется", время последней активности которых отстает более чем на пол часа от текущего момента, и переводит их в состояние "приостановлен". Из этого состояния ваншот можно снова запустить. Такое случается, если инстанс, на котором выполнялся ваншот, неожиданно прекратил работу.

### Актуализация версии приложения и информации о ваншотах в БД

В [ppcdict.oneshots](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshots.html) хранится актуальный список ваншотов из самой свежей версии приложения (из самого свежего из запущенных инстансов).

В ppc-property `oneshot_app_current_revision` хранится самая свежая версия приложения. Она актуализируется при запуске инстанса приложения, если приложение понимает, что его версия — самая свежая.

В ppc-property `oneshot_app_last_revisions` хранится упорядоченный список N ранее запускавшихся версий приложения, где самая свежая — в конце. Эта информация нужна приложению для определения собственной свежести (об этом ниже).

Список ваншотов в базе и версии приложения в вышеуказанных ppc-property актуализируются в момент запуска приложения, если запускаемый инстанс имеет самую свежую версию и ваншоты еще не актуализированы в соответствии с этой новой версией.

Пошаговое описание алгоритма:

1. Инстанс приложения проверяет актуальность своей версии
   1. читаем текущую ревизию из файла ресурсов, в который она записана при сборке
   1. открываем транзакцию
   1. читаем содержимое специальной ppc-property, которая хранит N запускавшихся ранее ревизий (FOR UPDATE)
   1. если текущая ревизия равна последней ревизии из проперти (версия данного инстанса является актуальной), то переходим к выполнению ваншотов
   1. если текущая ревизия равна одной из предыдущих ревизий из проперти (версия данного инстанса устарела), то ничего не делаем (бесконечный цикл)
   1. если текущая ревизия не содержится в ppc_property (версия инстанса является свежее остальных инстансов), то актуализируем версию в ppc_property и переходим к актуализации списка ваншотов
   1. закрываем транзакцию (и отпускаем лок на ppc-property)
1. Актуализация списка ваншотов
   1. сканируем пакет с ваншотами и находим все классы, которые имплементируют интерфейс ваншота
   1. если есть ваншот, которого нет в таблице [ppcdict.oneshots](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshots.html) (по имени класса), то добавляем его и создаем тикет в очереди DIRECTONESHOTS
   1. если есть ваншот, который есть в таблице [ppcdict.oneshots](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshots.html), то актуализируем поля (признак удаленности, апруверы, шардированность, множественность запуска, ...)
   1. если есть запись в таблице [ppcdict.oneshots](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshots.html), для которой не найден класс ваншота, то помечаем его удаленным

**После этого на странице ваншотов становится доступна актуальная информация по ваншотам, и по существующим в коде ваншотам можно заказывать запуск.**


## Схема БД

Информация о _ваншотах_ хранится в [ppcdict.oneshots](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshots.html), она актуализируется каждый раз при запуске новой версии приложения. Актуальный список ваншотов, хранящийся в базе, можно посмотреть в [InternalTools](https://direct.yandex.ru/internal_tools/#oneshots).

Информация о _запусках ваншотов_ хранится в [ppcdict.oneshot_launches](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshot_launches.html). В этой таблице хранится только информация о запуске (и не хранится о процессе выполнения): входные параметры запуска, статус их валидации, статус подтверждения апрувером и т.п.

Информация о _ходе выполнения ваншота_ хранится в [ppcdict.oneshot_launch_data](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshot_launch_data.html). Для нешардированных ваншотов там создается одна запись, а для шардированных — по одной записи на каждый шард, так как они выполняются независимо.


## Жизненные циклы ваншота и его дочерних сущностей

### Жизненный цикл ваншота {#lifecycle_oneshot}

1. Написание кода ваншота в ветке и code-review.
2. Коммит кода ваншота в транк (уникальным идентификатором ваншота является полный путь класса).
3. Релиз новой версии приложения `oneshot`. При запуске приложение создает в таблице [ppcdict.oneshots](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshots.html) запись о новом ваншоте.
4. Один или несколько запусков ваншота на [странице ваншотов](https://direct.yandex.ru/internal_tools/#oneshots) в InternalTools (см. жизненный цикл запуска ваншота).
5. Удаление из транка кода ваншота.
6. Релиз новой версии приложения `oneshot`. При запуске приложение помечает удаленный из кода ваншот в таблице [ppcdict.oneshots](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshots.html) как удаленный.

### Жизненный цикл запуска ваншота {#lifecycle_oneshot-launch}

1. На [странице ваншотов](https://direct.yandex.ru/internal_tools/#oneshots) в InternalTools для определенного ваншота указываются входные данные и по кнопке создается объект запуска — запись в таблице [ppcdict.oneshot_launches](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshot_launches.html). После чего запуск становится виден на [странице запусков](https://direct.yandex.ru/internal_tools/#oneshot_launches).
2. _Поток валидации параметров запуска ваншота_ подхватывает запуск в состоянии _ожидает валидации_ и проводит валидацию. В результате запуск переводится либо в состояние "валиден", либо в "невалиден". Ошибки и ворнинги валидации сохраняютя в лог, так же доступный по ссылке со [страницы запусков](https://direct.yandex.ru/internal_tools/#oneshot_launches). Для невалидных запусков жизненный цикл заканчивается на этом пункте.
3. Для [безопасных ваншотов](#safe-oneshot) апрув не требуется и его можно запустить в любое время. Для других типов см. следующий пункт.
4. Апрувер (один из списка апруверов, указанный в коде ваншота) принимает или отклоняет запуск на [странице запусков](https://direct.yandex.ru/internal_tools/#oneshot_launches). Для отклоненных запусков жизненный цикл на этом заканчивается. Заапрувленный запуск не начинает выполняться в момент апрува, это требует еще одного ручного действия.
5. Заапрувленный запуск может быть затем либо отклонен, либо выполнен в любой момент времени тем же пользователем, который создал запуск.

### Жизненный цикл выполнения ваншота {#lifecycle_oneshot-launch-data}

1. На [странице запусков](https://direct.yandex.ru/internal_tools/#oneshot_launches) в InternalTools выбирается успешно провалидированный и подтвержденный апрувером запуск, и по кнопке "выполнить" для него создается один или несколько объектов выполнения в таблице [ppcdict.oneshot_launch_data](https://direct-dev.yandex-team.ru/db/ppcdict/tables/oneshot_launch_data.html). Для нешардированных ваншотов (`SimpleOneshot`) создается одна запись, а для шардированных (`ShardedOneshot`) — по одной записи на каждый шард. Каждая запись отражает независимое состояние выполнения.
2. Если ваншот сохраняет промежуточное состояние, что обязательно должен делать любой долгоиграющий ваншот (выполняющийся более 10 минут), то его можно поставить на паузу или полностью остановить. Поставленные на паузу ваншоты можно возобновить, остановленные — нельзя. В случае шардированных ваншотов такое управление доступно независимо по каждому шарду.
3. Ваншот может завершиться с исключением, тогда он перейдет в состояние "failed". Если ваншот завершился с исключением, то его можно вручную либо возобновить (или запустить с начала в случае ваншотов, не сохраняющих состояние), либо полностью остановить, после чего возобновить выполнение будет невозможно. В случае шардированных ваншотов такое управление доступно независимо по каждому шарду.
4. Жизненный цикл ваншота заканчивается на успешном выполнении или ручной отмене запуска (не паузе, а полной остановке).

## Безопасные ваншоты {#safe-oneshot}

Безопасные ваншоты отличаются от обычных тем, что не требуют подтверждения от апрувера во время запуска (см. [флоу запуска ваншотов](#lifecycle_oneshot-launch)). Такой ваншот может самостоятельно запустить один разработчик.

Основные признаки безопасности ваншота:

- Действия НЕ влекут изменений в пользовательских данных.
- Действия НЕ влекут потенциальных проблем для пользователей.
- Если возможна обработка большого количества данных, то такие действия должны выполняться с некоторой задержкой, чтобы не нагружать систему и соседние сервисы. Для определение задержки можно обратиться к коллегам, знакомым с данной областью.

Примером безопасного ваншота может служить сброс статуса синхронизации с БК при условии распределения нагрузки на БК. Пользователи не видят статус синхронизации, их объявления показываются независимо от статуса.

Вопросы, для самопроверки:

- Какие неудобства могут возникнуть у пользователей, если что-то пойдет не так?
- Что произойдет, если ваншот завершится с ошибкой во время выполнения? можно ли его перезапустить?
- Можно ли его остановить, если что-то пойдет не так?

Как сделать ваншот безопасным читайте в [инструкции](howto-code.md#choose-oneshot-type)
