[Написание кода ваншота](howto-code.md) <br/>
[Доставка ваншота в продакшен](howto-release.md) <br/>
[Запуск ваншота](howto-launch.md) <br/>

# Тестирование и отладка ваншота

Для кода ваншота доступны следующие этапы тестирования:

- юнит-тесты (включая тесты с базой)
- локальный запуск ваншота на devtest
- запуск на Бете (не рекомендуется)
- запуск на ТС (аналогично продакшену, только без подтверждения)


## Юнит-тесты

Как понять, что вам требуется написать тесты на ваншот?

- есть риск испортить пользовательские данные
- если ваншот многоразовый (это увеличивает вероятность изменения самого ваншота и его зависимостей)

На ваншот можно писать тесты с базой, такие же как в ядре и других приложениях.<br/>
Для этого воспользуйтесь аннотациями:

- [OneshotTest](https://a.yandex-team.ru/arc/trunk/arcadia/direct/oneshot/src/test/java/ru/yandex/direct/oneshot/configuration/OneshotTest.java)
- `RunWith(SpringRunner.class)`

{% note tip %}

Используйте [степы](https://a.yandex-team.ru/arc/trunk/arcadia/direct/core/src/test/java/ru/yandex/direct/core/testing/steps) для создания состояния, требуемого для теста.

{% endnote %}


## Локальный запуск ваншота на devtest

Ваншот можно запустить на разработческой машине из консоли или IDE, при этом по умолчанию он будет смотреть на базу `devtest`. Такой способ запуска не требует управления через веб-интерфейс и не требует подтверждения.

Описываемый способ запуска использует сильно урезанную версию ваншотилки и поэтому подходит для отладки и тестирования логики ваншота, но не подходит для тестирования изменений в самой ваншотилке или интеграции ваншота с ваншотилкой.

Для этого достаточно запустить main-класс [OneshotAppDebug.java](https://a.yandex-team.ru/arc/trunk/arcadia/direct/oneshot/src/main/java/ru/yandex/direct/oneshot/debug/OneshotAppDebug.java) с нужными параметрами.

Обязательные параметры:

- `-c` — полное название класса ваншота, который хотим запустить (например, `ru.yandex.direct.oneshot.oneshots.simple.TestSimpleOneshot`)
- `-i` — параметры ваншота в формате JSON.

Необязательные параметры:

- `-s` — начальный "стейт" в формате JSON, с которым запустится итеративный ваншот. Полезен, например, когда хочется продолжить ваншот с определенной итерации, а не запускать его полностью заново.
- `--shards` — номера шардов через запятую. Если ваншот — шардированный, то он запустится только на указанных шардах.

Примеры запуска:

- `-c ru.yandex.direct.oneshot.oneshots.simple.TestSimpleOneshot -i "{\"data\": 12345}" -s "{\"iteration\": 3}"` — запуск нешардированного ваншота, выполнение которого продолжается с определенной итерации.
- `-c ru.yandex.direct.oneshot.oneshots.sharded.TestShardedOneshot -i "{\"data\": 678910}" --shards 1,2,3,4,5,6,7,8,9` — запуск шардированного ваншота, который выполнится на первых девяти шардах.


## Запуск на Бете

{% note warning %}

Не рекомендуется к использованию. Применяйте, если точно понимаете, что делаете.

{% endnote %}

Запуск ваншота на бете похож на запуск в продакшене, но с важным отличием: на общей базе `devtest` (или `dev7`) может быть запущено несколько инстансов ваншотилки, которые конкурируют между собой за запуск ваншотов и при этом могут отличаться бизнес-логикой.

Соберите бету с приложением oneshot и запустите ваншотилку.

Команды:
```bash
direct-create-beta --java-svn app:oneshot,rp:<review-number>
direct-mk run_oneshot
```

Может понадобиться также собрать на бете приложение web, если изменения затрагивают внутренние инструменты (internal_tools).

Управление ваншотами осуществляется через веб-интерфейс любой беты, которая смотрит на ту же базу, при этом запуск не требует подтверждения. За более подробной информацией обращайтесь к [руководству по запуску ваншотов](howto-launch.md).<br/>


## Тестирование на ТС

На ТС механизм выполнения ваншота идентичен продакшеновому, в отличие от других видов тестовых сред. Управление ваншотами осуществляется через веб-интерфейс, при этом запуск не требует подтверждения. За более подробной информацией обращайтесь к [руководству по запуску ваншотов](howto-launch.md).<br/>

ТС позволяет протестировать:

- логику самого ваншота (при этом большое количество реальных данных клиентов может помочь выявить проблему, незаметную в тестах);
- интеграцию ваншота с ваншотилкой;
- саму ваншотилку, если в ней были сделаны изменения.

{% note warning %}

До выкладки ваншота в продакшен выполните запуск ваншота на ТС для проверки интеграции ваншота с ваншотилкой.

{% endnote %}
