# Регламент выкладки релиза в прод через NewCI

## Последовательность
- Релиз доводится дежурными ТС до выкладки
- Принимается дежурным по продакшену
- Отпускается дежурным по продакшену на выкладку в NewCI
- Выкладка дежурным по ТС/фронтовым дежурным
- Наблюдение за состоянием
- Сообщение о окончании выкладки

## Доведение до выкладки
Релиз собирается и доводится до состояния "RM Accept".
К этому моменту должны пройти все тесты, проверены все релевантные релизу тикеты, разобраны тикеты с неправильными статусами. [Автоматический чеклист](../guide/releases/autochecklist.md) - зеленый.

## Приемка ответственным app-duty
Когда релиз готов и находится в статусе "RM Accept" робот будет сообщать о нем начиная с ближайшего [окна выкладки](../concepts/releases/deploy-schedule.md).
Необходимо ответить в течение получаса о возможности(или невозможности) выкладки релиза. Для этого:
- Продакшеновый дежурный проверяет готовность релиза: чеклист/комменты, исключающие выкладку и если все хорошо - принимает релиз, нажимая RM Accept.
- Если выкладке релиза ничего не мешает, например, авария в продакшене, выкладка другого релиза, учения/работы, в том числе инфраструктурные app-duty прожимает в графе кубик "Разрешить выкладку в продакшен"(1 на скриншоте).
- Далее по графу произойдет проверка, что релиз проакцепчен(необходимо для SOX) и релиз станет доступен для выкладки любым дежурным.
- Продакшеновый дежурный, принявший релиз, пишет в Direct.Admin.Chat, что релиз <имя/тикет> можно катить, отмечая исполнителя релиза призывом.
Робот в чате сообщает о текущих идущих выкладках.
Дежурный, который ведет релиз, начинает выкладку и по окончании выкладки сообщает в чат, что релиз выложен, ответом на сообщение с разрешением выкладки.
После этого сообщения продовому дежурному необходимо обработать следующие релизы по очереди. Можно посмотреть список готовых релизов командой `/releases_for_deploy`

Main дежурный, по договоренности, может передать эту обязанность во второго дежурного по проду.

## Выкладка релизов
Релизы необходимо катить последовательно, чтобы избежать наведения ошибок друг на друга и при случае не было необходимости откатывать несколько релизов. Исключение составляют релизы oneshot logviewer alw

**Для начала выкладки необходимо нажать кнопку на кубике** "Старт выкладки" (2 на скриншоте).
Во время выкладки релизов необходимо смотреть на мониторинги:
- Мониторинги приложения (ссылка на агрегат появляется в кубике "Разрешить выкладку в продакшен"(1 на скриншоте) в виде цветного кружка; у релиза oneshot агрегата нет, поэтому ссылка будет вести на пустую страницу)
- [дашборд дежурных](https://solomon.yandex-team.ru/?project=direct&dashboard=direct-group-sre-tv):
    - графики 500к
    - времена ответов
    - агрегаты в блоке direct-health
- [звонящий чат](https://docs.yandex-team.ru/direct-dev/reference/chats#direkt-/-avtomaticheskie-monitorinngi) на предмет появления новых проверок
- [error booster](https://error.yandex-team.ru/projects/direct?filter=environment%20%3D%3D%20production&period=3h)
- messages логи в logviewer, например для [java-web](https://direct.yandex.ru/logviewer/short/E_8X4S7f56UKmj) (но обычно ошибок слишком много и проще мониторить только их кол-во в [error booster с фильтром java-web](https://error.yandex-team.ru/projects/direct?filter=environment%20%3D%3D%20production%20AND%20service%20%3D%3D%20direct.web&period=3h))
- [дашборд Hourglass](https://solomon.yandex-team.ru/?project=direct&dashboard=Hourglass) для релиза java-jobs

![no alt](https://jing.yandex-team.ru/files/pe4kin/non-per-location-deploy.png "кнопочки на скрине")

В некоторых приложениях настроена полокационная выкладка. После выкладки на одну локацию необходимо внимательно посмотреть на мониторинги и если все хорошо - последить за ошибками 15-30 минут и только затем прожать апрув локации(3 на скриншоте), в случае если все пошло плохо(зажглись алерты, написали об ошибках и пр) - привлечь app-duty для отката.

После выкладки робот автоматически закроет тикет.

![no alt](_assets/deploy_steps.png "кнопочки на скрине")

## Откат (Если все пошло плохо)
Для отката воспользоваться [докой](../jeri/guide/deploy.md), при этом необходимо поставить в известность продакшеновых дежурных и скоординировать действия с ними.
Если выехало только на одну локацию и не прожато дальше - необходимо силами продакшеновых дежурных увести трафик с этой локации до возврата рабочего кода по [инструкции](../jeri/howto-dc-l7.md) и [откатить](../jeri/guide/deploy.md) релиз


## Время выкладки релиза
Робот пишет в админском чате список релизов, готовых к выкладке. Его расписание в коде: [здесь](https://a.yandex-team.ru/arcadia/direct/apps/chassis/src/main/java/ru/yandex/direct/chassis/entity/telegram/ScheduledMessages.kt?rev=r9520870#L25).

Лучше не выкладывать релизы слишком поздно, так как ближайшие пару часов после выкладки дежурным app-duty нужно быть готовым чинить/откатывать проблемный релиз. Соответственно, примерно к 19 часам все должно быть уже закончено.
