# Диагностика perl-экспорта в БК

**Продукт/подсистема**: perl-экспорт в БК.

**Роль в работе продукта/подсистемы**  
Отправляет данные по кампаниям/группам/баннерам в БК (топик direct-banners-log логброкера).
Из логброкера данные читает CaeSaR, а также мы делаем свои логи в YTе и LogViewer'е.  
В БК из этих данных варят базы движка и он показывает рекламу на выдаче и РСЯ.

**Как пользователи (или команда) заметят проблему и через какое время**  
Клиенты замечают проблемы в течение пары-тройки часов: не стартуют или не останавливаются показы, показывается старая версия объявлений.  
Через три часа на многих кампаниях успевают закончиться деньги и это становится заметно на БКшных приборах.  

**Кого звать на помощь, если ничего непонятно**: [ppalex@](https://staff.yandex-team.ru/ppalex).

## Желательное время исправления в случае поломки
- Для масштабных проблем (затрагивающих многих клиентов) — час—два.
- Для конкретных клиентов или кампаний:
   1. в ближайшее рабочее времени (3 — 18 часов) — провести диагностику, завести тикет и потушить мониторинг _"отодвинув кампании в сторонку"_
   2. непосредственную починку — по ситуации, советоваться с [дежурным менеджером](https://abc.yandex-team.ru/services/direct/duty/?role=3739&months=1).
общее соображение такое: денежный клиент — быстрее (дни-неделя), архивные старые данные или без денег — медленнее (недели).


## Датафлоу
1. скрипт bsExportMaster.pl
   1. находит все объекты со `statusBsSynced = No`, ставит `Sending` и добавляет кампании (в которых эти объекты) в очередь — табличку `bs_export_queue`
   1. берет часть объектов из "ленивой очереди" (таблицы `bs_resync_queue`) и сбрасывает им статус в No.
1. скрипты bsClientData.pl берут из очереди подходящие (_[анти-пример](#wallet-without-orderid)_) кампании для работы.
   воркеров много (десятки), они бывают

   {% cut "нескольких типов" %}

   - **std** — обычные воркеры, берут кампании для которых нет `bs_export_specials`
   - **heavy** — нагруженные воркеры, берут только кампании у которых в `bs_export_specials` записано `par_type = heavy`. от std отличается увеличенными лимитами для выборки. попадают сюда кампании рекламодателей с очень большим числом изменений (эта логика живет в bsExportMaster)
   - **buggy** — отправляют кампании строго по одной и целиком (у остальных есть лимиты на число объектов за раз), берут только кампании с `par_type = buggy`. попадают они сюда вручную или костылями-подпорками в коде bsClientData
   - **full_lb_export** (их par_id 210—219) — фоновая отправка в логброкер (без bssoap), все что написано в этой доке — к ним **не относится**, просто они синхронизируют свою работу тоже через par_id в очереди
   - есть и другие

   {% endcut %}

1. на время обработки ставят в очереди этим кампаниям свой par_id
1. выбирают из базы данные по кампаниям, применяя сложное условие в sql-запросе
   1. если данные не выбрались (кампания не подходит к отправке по условиям), то она удаляется из очереди
   1. для выбравшихся кампаний — выбираются из базы еще больше данных, формируется запрос для отправки в БК
1. запрос отправляется в логброкер (через подпроцесс открывается push-client и мы пишем в него данные)
1. после этого запрос отправляется в bssoap
1. обрабатываем полученный из bssoap ответ:
   1. если в ответе есть ошибки по объектам: дальше их не обрабатываем, можем переложить кампанию в buggy или оставить в очереди
   1. у объектов без ошибок — обновляем данные: ставим `statusBsSynced = Yes`, пишем БКшные id (OrderID, BannerID), другие данные.
1. проверяем, все ли несинхронные объекты отправили по кампании:
   1. если да, то удаляем ее из очереди
   1. если нет, то разблокируем кампанию — ставим `par_id = NULL` ей в очереди, чтобы процесс повторился

## Способы наблюдения за текущим состоянием { #status }
- [Обзорный дашборд](https://solomon.yandex-team.ru/?project=direct&dashboard=bs-export-perl&b=6h) про экспорт, на нем:
    - данные про очередь: количество кампаний и клиентов, возраст
    - количество запросов: успешных и ошибочных, в logbroker
    - количество отправленных объектов
- [детальный дашборд](https://solomon.yandex-team.ru/?project=direct&dashboard=bs-export-queue-templated&queue=std&service=bs-export-queue&cluster=app_java-jobs&b=6h)
про конкретную очередь (**queue** в шапке можно переключать) — посмотреть состояние конкретной очереди отправки
- [логи скрипта](https://direct.yandex.ru/logviewer/#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(service~'direct.script~method~'bsClientData~prefix~'*21*25par_full_lb_export*25)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$)
   - можно фильтровать **message** по `%номер_кампании%` и затем по **span_id** прочесть весь лог итерации отправки
   - ошибки можно находить фильтрацией **message** по `Failed_to_send%`, [пример](https://direct.yandex.ru/logviewer/#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(service~'direct.script~method~'bsClientData~message~'Failed_to_send*25)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$)
- [логи отправленных данных (bsexport_data)](https://direct.yandex.ru/logviewer/#~(logType~'bsexport_data~form~(fields~(~'log_time~'data_type~'cid~'pid~'bid~'data)~conditions~(data_type~'request*20response~cid~'0)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$)
   - подставить проблемный **cid** в фильтр, чтобы посмотреть данные
   - часто помогает добавить фильтрацию по **pid** `0`, чтобы смотреть только на данные кампании (остальных очень много)
- **выборка кампаний в очередях**: [std]({{bsexport-queue-std}}),
[heavy]({{bsexport-queue-heavy}}),
[buggy]({{bsexport-queue-buggy}}),
[остальные]({{bsexport-queue-other}})
- [дополнительные логи скрипта](https://direct.yandex.ru/logviewer/#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(service~'direct.script~method~'bsClientData.errors)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$) — туда попадают ошибки из ответов и сообщения о срабатывании костылей в логике
- [бинлоги таблицы bs_export_queue](https://direct.yandex.ru/logviewer/#~(logType~'binlog_rows_fields_v2~form~(fields~(~'datetime~'source~'table~'service~'method~'primary_key~'operation~'col_name~'col_value~'col_is_null~'reqid)~conditions~(table~'bs_export_queue~primary_key~'24126015~col_name~'par_id)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$) — можно отфильтровать указав в **primary_key** номер кампании — и увидеть берут эту кампанию воркеры из очереди или нет
- лог `/var/log/yandex/cron-mailer/ppc.log` на хостах — туда падает STDERR скрипта
- лог `/var/www/ppc.yandex.ru/protected/logs/bsexport-pushclient-log.*` на хостах — здесь дебажный лог push-client от записи в логброкер

## Ручки, тулы и способы управления
- Что можно делать с кампаниями:  
   - [перекладывать кампании между разными очередями](https://direct.yandex.ru/internal_tools/#move_campaigns_to_bs_export_specials) – этот тул меняет заданную кампании очередь в `bs_export_specials`. Типовое применение: переложить в nosend, buggy или вернуть очередь "как было"
   - [переотправить в БК целиком ](https://direct.yandex.ru/internal_tools/#add_cids_to_resync_queue) через ленивую очередь (тул найдет все объекты кампаний, но сброс statusBsSynced произойдет отложенно). **указывайте приоритет "срочно"**, иначе не отправится
   - еще можно переотправить (сразу, без ленивой очереди) ссылкой "Переотправить в БК" со страницы поиска
   - еще есть [импорт файла в переотправку](https://direct.yandex.ru/internal_tools/#add_objects_to_resync_queue) и ваншот [ImportToBsResyncQueueFromYtOneshot](https://a.yandex-team.ru/arc/trunk/arcadia/direct/oneshot/src/main/java/ru/yandex/direct/oneshot/oneshots/bsresync/ImportToBsResyncQueueFromYtOneshot.java)
   - можно разблокировать кампанию в очереди (выполнить sql: `update bs_export_queue set par_id = NULL where cid IN (<ВПИШИ НОМЕРА КАМПАНИЙ ЧЕРЕЗ ЗАПЯТУЮ>)`
- настроить количество воркеров bsClientData
   - включить или отключить [ручное управление их количеством](https://direct.yandex.ru/internal_tools/#bsexport_workers_num_balancing_mode)
   - задать нужное число вокеров [std](https://direct.yandex.ru/internal_tools/#set_bsexport_std_workers_num),
   [heavy](https://direct.yandex.ru/internal_tools/#set_bsexport_heavy_workers_num),
   [buggy](https://direct.yandex.ru/internal_tools/#set_bsexport_buggy_workers_num)
- настроить обработку ленивой очереди:
   - изменить [количество объектов и условия на состояние основной очереди](https://direct.yandex.ru/registered/main.pl?cmd=internalReports&report_id=manage_bs_resync_constants)
   - [подкрутить вычисление размера очереди](https://direct.yandex.ru/registered/main.pl?cmd=internalReports&report_id=isize_props), настраиваемого предыдущим отчетом _(вам это почти наверняка не нужно)_
- [ограничить отправку кампаний под одним кошельком разными воркерами](https://direct.yandex.ru/registered/main.pl?cmd=internalReports&report_id=manage_skip_locked_wallets) — подробнее об этом описано ниже в [{#T}](#skip-locked-wallets)
- [переключить лимтесты между продом и препродом bssoap](https://direct.yandex.ru/registered/main.pl?cmd=internalReports&report_id=preprod_limtest) _(стало неактуальным после отпиливания bssoap)_

## Как дебажить { #how-to }
_Все ссылки куда смотреть указаны в разделе [выше](#status)._
1. Посмотреть на дашборд и прикинуть:
   - много ли клиентов/кампаний зацепило? если да, катили/переключали что-нибудь в момент когда началось?
   - как выглядит проблема: рост возраста очереди, есть ли ошибки отправки в логброкер
1. Попробовать локализовать проблему:
   - по виду графиков — например до конкретной очереди и затем шарда
   - по выборке кампаний из очереди — обычно это кампания с самым маленьким **queue_time**
   - для ошибок записи в логброкер / bssoap — это поможет понять где проблема – у нас (если локализуется до чего-то конкретного) или "с той стороны" (если ошибки в разных местах)
1. Выбрать конкретные кампании и дальше смотреть на их примерах

   {% note tip "Если отправляется много кампаний и непонятно, на какой конкретно скрипт падает" %}

   Можно попробовать перенести подозреваемую пачку кампаний из std или heavy очереди в buggy — тот будет отправлять их по одной.

   **Не переносите кампании** из других очередей (camps_only), либо их если их больше нескольких сотен штук.

   {% endnote %}

1. Поискать в логах скрипта по номеру кампании — с ней вообще кто-нибудь работает? Если нет:
   - это может быть [{#T}](#wallet-without-orderid) — тогда дебажить по cid общего счета
   - изредка это оказывается [{#T}](#skip-locked-wallets) — тут нет универсального рецепта: или игнорировать, или попробовать стащить кампании из разных очередей в одну
   - редко: проверить, а есть ли вобще кампания в базе (mysql), не удалена ли она или user.
     Если кампании нет — удалить из очереди в базе. Пример миграции: [DIRECTMIGR-1757: Удалить из очереди транспорта запись про удалённую кампанию](https://st.yandex-team.ru/DIRECTMIGR-1757)
1. Посмотреть логи отправленных данных по cid. Логов нет? Посмотрите еще раз логи скрипта, по конкретному **span_id**. Что там может оказаться:
   - логи обрываются — возможно мы [{#T}](#oom)
   - `No NDS known for` — [{#T}](#no-nds)
   - `Too long data given to append` — [{#T}](#long-message)
   - `ERROR sending data to push-client` — [{#T}](#logbroker-write-failed)
   - [{#T}](#bssoap-request-error):
       - `500 Status read failed: Connection reset by peer`
       - `500 Can't connect to bssoap.yandex.ru:80`
       - `500 Server closed connection without sending any data back`
       - `500 read timeout`
       - `500 addr is not a string`
       - `502 Bad Gateway`
       - `unclosed token at line 1, column 13553, byte 13553 at /usr/lib/perl5/XML/Parser.pm line 187`
       - `no element found at line 1, column 13578, byte 13578 at /usr/lib/perl5/XML/Parser.pm line 187`
    - [{#T}](#undefined-result)
    - `skip sending banner: context is synced; Banner + AdGroup will be added into resync queue` — [{#T}](#unconsisnent-banners)
    - падения нашего кода (например на десериализации json'ов из базы)
    - ошибки запросов в базу
1. Если логи есть, то в ответах (**data_type** — response) может быть [{#T}](#undone) или ErrorMessage — сообщение об ошибке.
по тексту можно найти в трекере похожие тикеты.
некоторые типовые ошибки:
    - `Context has archived banner that is being activated, but UpdateInfo hasn't been sent` — [{#T}](#unconsisnent-banners)
    - `Not enough resources for 100-days-archived banner, BannerID=72057603455333003, ExportID=9417405067` — [{#T}](#unconsisnent-banners)
    - [{#T}](#limitcur)
    - [{#T}](#negative-sum)
1. Если никаких ошибок нет, то может быть [{#T}](#big-camp)

### Что делать с кампаниями, когда раздебажили { #debug }
Создать тикет по [форме бага DIRECTSUP](https://st.yandex-team.ru/createTicket?queue=DIRECTSUP&_form=63892),
записать в него все найденные подробности.
Если починить на ходу невозможно, то переложить кампанию в nosend (неотправляемая очередь),
добавить в описание тикета **"после починки не забыть переотправить кампанию в БК и вернуть в <ХХХ> очередь"**, где ХХХ - текущая очередь (std или camps_only).

## Тонкости и известные причины поломок

bsClientData на каждой итерации пытается взять себе максимально возможное количество кампаний для отправки.
Если из-за какой-то кампании скрипт падает — это может приводить к застреванию большого числа "невиновных" кампаний так как кампании не разблокируются и на следующей итерации подхватываются заново. В такой ситуации нужно локализовать проблемную кампанию и убрать из пачки.

### отставание реплик мастербазы
Бывает, если мы отправили разом очень много кампаний (десятки тысяч и больше). Чтобы облегчить ситуацию в БК — можно уменьшать вручную число воркеров.  
Алгоритм:
1. Проверить, что работает ручное управление количеством воркеров тут: <https://direct.yandex.ru/internal_tools/#bsexport_workers_num_balancing_mode>
2. Изменить количество для нужной очереди через отчёт. Отчёты искать по фразе "Управление количеством воркеров" в <https://direct.yandex.ru/internal_tools/>. Например, [Управление количеством воркеров std](https://direct.yandex.ru/internal_tools/#set_bsexport_std_workers_num)

### неотправка кампаний под общим счетом без OrderID { #wallet-without-orderid }
Если кампания подключена к кошельку (`wallet_cid > 0`), но у кошелька (кампании с таким cid) `OrderID = 0`, то никакой воркер не возьмет эту кампанию из очереди для отправки.  
Причина в том, что в отправляемые данные нужно подставлять GroupOrderID, а поле должно либо отсутствовать (когда кампания не подключена к кошельку), либо быть заданно.

### неотправка кампаний одного кошелька разными воркерами { #skip-locked-wallets }
_Группа заказов_ — это кошелек и подключенные к нему кампании.

Если пропертя (управляется внутреннием отчетом) включена, то воркеры при выборке из очереди игнорируют кампании у которых в рамках той же _группы заказов_ данные по кампании отправляются другим воркером. В [коде](https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/BS/ExportWorker.pm?rev=r8542660#L637) можно посмотреть по skip_locked_wallets.

**Зачем этот костыль**  
БК при обработке кампании в bssoap делают лок в мастербазе на всю группу кампаний. Поэтому если им одновременно приходит запрос по разным кампаниям одной группы — то первую они обработают, а по второй ответят ошибкой (т.к. не смогут залочить).

**К чему он приводит**  
- к огромному фону UnDone (и падению общей пропускной способности), если его выключить
- ситуациям, когда кампании лежат в разных очередях (например buggy и heavy), и часть их даже не пытается отправиться (просаживая возраст этой очереди)


### нет графика НДС { #no-nds }
В messages-логе выглядит как `No NDS known for ClientID 94948961 and AgencyID 0 at /var/www/ppc.yandex.ru/protected/BS/ExportQuery.pm line 2188`.
Указаны ClientID и AgencyID кампании, у которой не получилось подтянуть график НДС.

Чей именно (клиента или агентства) график имеется ввиду:
1. если у клиента в `clients_options.non_resident = 1`  — всегда клиента
1. если AgencyID ненулевой — агентства
1. клиента

Надо посмотреть в базе (в шарде клиента) что там в базе:
- для графика клиента: `select * from client_nds where ClientID = <подставить ClientID из ошбики>;`
- для графика агентства: `select * from agency_nds where ClientID = <подставить AgencyID>`

Если нет графика агентства — какая-то дичь и караул, скорее всего сломан не только экспорт.

Если графика нет у клиента:
1. проверить по бинлогам за неделю-месяц, что графика действительно не было (там составной primary_key, нужно его указывать с процентом на конце). [пример](https://direct.yandex.ru/logviewer/#~(logType~'binlog_rows_v2~form~(from~'20210901T000000~to~'20210901T235959~fields~(~'datetime~'source~'table~'service~'method~'primary_key~'operation~'row~'reqid)~conditions~(table~'client_nds~primary_key~'94948887*25)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$) где график есть
2. если графика нет и не было, можно воспользоваться отчетом [Сбросить НДС пользователей](https://direct.yandex.ru/registered/main.P0pTVh.pl?cmd=internalReports&report_id=mass_drop_users_nds) (нужен суперридер-разработчик или супер).
у клиента удалится график (но у нас его итак нет) и он добавиться в очередь для подтягивания графика. обычно он подтягивается в течение трех-пяти минут.


### превышение размера сообщения для отправки в логброкер { #long-message }
В messages-логе выглядит так: `Failed to send data: ERROR sending data from first request (UUID: FB228A84-F482-11EB-969A-EA7645EFD506)
to logbroker, die: Too long data given to append: length is 15169127 at /var/www/ppc.yandex.ru/protected/BS/ExportWorker.pm line 5562.
| at /var/www/ppc.yandex.ru/protected/BS/ExportWorker/LogBrokerBuffer.pm line 108.`  
Эти ошибки также видно как **client_error** на [графике](https://solomon.yandex-team.ru/?graph=bsexport_requests_logbroker&legend=1&project=direct&b=6h&scale=natural&checks=%2Bclient_error) числа запросов в logbroker.

Суть такая: при отправке данных в логброкер, кампания или группа отправляются целиком в виде json.
В нашем коде зашито ограничение на его размер — 12 Мб.
Ошибка означает, что сообщение получилось длиннее и мы падаем (не пытаемся отправлять).

Как определить проблемную кампанию:
- из ошибки перейти в messages лог по span_id
- найти строчку `locked cids: ...`, взять номера кампаний
- выполнить в MySQL запрос, подставив номера кампаний
   ```sql
   SELECT cid, pid, COUNT(*) FROM banners WHERE cid IN (<подставить список>) GROUP BY 1, 2 ORDER BY 3 DESC LIMIT 15
   ```
- если число баннеров больше 100 — это скорее всего "та самая" кампания. для уверенности можно переложить ее в buggy и проверить, сохранится ли ошибка

С такими кампаниями:
- обязательно надо написать тикет (DIRECTSUP или DIRECT), чтобы в случае жалоб клиентов на проблемы с показами он находился по номеру кампании.
стоит предупредить [дежурного по продукту](https://abc.yandex-team.ru/services/direct/duty/?role=3739&months=1) менеджера что в такой-то кампании проблемы
- временно переносить в очередь **nosend** до исправления (как правило это удаление или архивация лишних баннеров)
- разобраться, откуда появились слишком большие (или много) объекты — это не единичные случаи и оно будет ломаться снова и зажигать мониторинги, также это поможет понять что/где чинить


### ошибки отправки в логброкер { #logbroker-write-failed }
Ошибка или таймаут отправки через push-client.
В логах выглядит как `ERROR sending data from first request (UUID: 88345958-F5E5-11EB-BC13-C4E6FF1BF2D1) to logbroker, die: ERROR sending data to push-client for source_id 10: process timed out at /var/www/ppc.yandex.ru/protected/BS/ExportWorker.pm line 5567`
или `ERROR sending data to push-client for source_id NN: exit status is XX`.  
Эти ошибки также видно как **server_error** на [графике](https://solomon.yandex-team.ru/?graph=bsexport_requests_logbroker&legend=1&project=direct&checks=%2Bserver_error&b=2021-08-25T21%3A46%3A10.185Z&e=2021-08-26T02%3A06%3A20.805Z&scale=natural) числа запросов в logbroker.

Если ошибки штучные — может само пройти.  
В остальных случаях собрать логи: взять UUID итерации (из сообщения об ошибке или лога скрипта),
пойти по ssh на хост на котором эта итерация была, отгрепать все строки с этим UUID из сегодняшнего лога `/var/www/ppc.yandex.ru/protected/logs/bsexport-pushclient-log.*` и с этой диагностикой обратится за помощью к команде логброкера.



### BS returned undefined result { #undefined-result }
Такую ошибку мы себе пишем в логи, когда БК ответило валидным XML, но пустым, т.е. там не оказалось структуры с ответом.

Известен небаг [DIRECT-119466: большой фон undefined result ответов экспорта](https://st.yandex-team.ru/DIRECT-119466) — что такое получаем от БК в случае, если сами
послали запрос с пустой структурой (без заказ/групп/баннеров).


### падаем по памяти { #oom }
Для проверки так это или нет — сходить по ssh на хост где бежал скрипт и изучить лог `/var/log/yandex/cron-mailer/ppc.log`.
Там будет в примерно нужное время запуск скрипта (сматчить по параметрам шарда / очереди) и сообщение `Out of memory!`

Пример когда так было – [DIRECT-82025: 29832211 убила buggy-очередь](https://st.yandex-team.ru/DIRECT-82025).

Что делать? В моменте: завести тикет, переложить проблемную кампанию в nosend, написать в тикете напоминание "не забыть вернуть кампанию в обычную очередь".
Затем дебажить (отладочными принтами, интуицией) что именно может жрет память.

Какие варианты исправлений:
- поправить код (например не размножать одинаковую большую сущность в каждый баннер, а подтягивать по id через общий словарик, как напрмер сделано для форматов картинок или визиток)
- уменьшить лимиты на количество отправлемых в пачке объектов (смотреть в коде в сторону `$BS::Export::BANNERS_LIMIT` и других)
- уменьшить количество кампаний, обрабатываемых за раз (`$BS::Export::CAMPS_LIMIT`) — акутально для ре-экспорта
- поднимать ulimit (самый плохой вариант) в параметрах запуска в кронтабе


### неполные баннера { #unconsisnent-banners }
БК ожидает, что мы пришлем баннер целиком: включенный и с условием показа.
Эти ошибки означают, что мы:
- либо послали только айдишники баннера но не его содержимое (banner.UpdateInfo = 0)
- либо прислали целиком баннер, но не отправилил данные по группе (context.UpdateInfo = 0)

Так получается из-за сложной модели данных и неконсистентности в обработке. Мы могли не пометить группу к отправке, либо что-то не промодерировано.
Или рекламодатель отключил все условия показа внутри группы.

Возможна ситуация, когда эти ошибки мы бесконечно получаем на одни и те же группы/баннеры.

Что делать:
1. найти кампанию по номеру
1. со страницы поиска кликнуть у нее в ссылку "Переотправить в БК"
1. сразу же после этого переложить кампанию в buggy-очередь

Что это даст:
- мы попробуем отправить баннеры вместе с группами (если до этого хотели отправить только что-то одно)
- попробуем отправить кампанию целиком (сразу все группы), засчет чего даже если не получится и БК все равно будет отвечать ошибками — мы их "бросим на пол" и удалим кампанию из очереди


### Attempt to increase LimitCur, but CurrencyConvertDate has come { #limitcur }
Эта ошибка на заказе говорит о том, что у сконвертированного в валюту заказа мы пытаемся увелличить доступную к открутке сумму _фишек_. В такой ситуации нужно разбираться между БК и Биллингом (смотреть полученные данные через NotifyOrder) почему "поехали" суммы.

На примере одной кампании: [DIRECTSUP-36095: застряла в экспорте в БК кампания 4713232](https://st.yandex-team.ru/DIRECTSUP-36095) + [BALANCE-37112: Обновились completion_fixed_qty/completion_money при миграции](https://st.yandex-team.ru/BALANCE-37112)


### SUMCur: The instance value is less than minimum keyword value { #negative-sum }
Мы прислали в БК отрицательное количество зачисленных на заказ денег 🤷‍♂️.

Поломка сезона 2021q2 и далее. Релевантные тикеты можно искать в связанных у [SPI-26023: [2021.06.30] PROD-DIRECT: Крупноотрицательный баланс общего счёта после подключения (ALL)](https://st.yandex-team.ru/SPI-26023), новые тоже стоит туда линковать.


Происходит при подключении клиентом общего счета, которое под капотом ломается:
- если смотреть логи общения с балансом — там можно найти что некоторые кампании не подключились к общему счету
- мы эту ошибку никак не обрабатываем, считаем что общий счет подключился и мы перешли на новую схему учета зачислений — зануляем сумму зачисленного на кампаниях под кошельком и перестаем принимать на них от баланса апдейты сум через NotifyOrder
- так как не все кампании подключились к кошельку, баланс присылает нам по кошельку меньшую сумму общих денег (на кошельке и всех его кампаниях)
- все в сумме (эта сумма и открутки на кампаниях) как раз и дают отрицательный SUMCur

Что делать:
1. найти все кампании клиента, посмотреть в каких они очередях (bs_export_specials). если есть очередь camps_only — обязательно отметить дальше в тикете, что кампании нужно возвращать именно в нее (а не стандартную очередь)
1. написать directsup тикет по проблеме, прилинковать его к SPI
1. переложить все кампании клиента в nosend. записать в тикет "после починки нужно переотрпавить <номера_кампаний> в БК и вернуть их в <указать очередь>"

### Просто большая кампания, долго отправляется { #big-camp }
Признаки _большой_ кампании:
- banners_num больше 10000 в очереди
- contexts_num больше 500
- bids_num больше 50_000

Примеры кампаний (в виде скриншотов) есть в тикете [DIRECT-66167: непозволительно долго отправляем в БК "жирные" кампании](https://st.yandex-team.ru/DIRECT-66167).
Алерты сейчас настроены так, чтобы не критовать от одного клиента/кампании.

Как убедиться, что кампания нет проблем, а кампания действительно "просто большая" и медленно отправляется:
1. поселектить из mysql в шарде кампании
   ```sql
   select statusBsSynced, count(*) from banners where cid = <XXXXX> group by 1;
   select statusBsSynced, count(*) from phrases where cid = <XXXXX> group by 1;
   select statusBsSynced, count(*) from bids where cid = <XXXXX> group by 1;
   ```
1. Подождать минут 10—15, повторить запрос.
1. Сравнить выборки между собой. Количество объектов со statusBsSynced = Yes должно увеличиваться, а Sending — уменьшаться. Через час-два, обычно, кампания таки закончит отправляться сама.
1. Если количество Yes не растет, скорее всего какая-то проблема с отправкой кампании все же есть.
