# Дайджест документации #18
За долгий перерыв накопилось многое, о чём рассказать.

Для затравки: на платформе документации сделали кнопки 👍 и 👎 (в правом верхнем углу, где ✏️) — пожалуйста, жмите их когда документация помогла (или нет).

## Мониторинг работы джоб
Множество задач выполняются в нашем продакшене. Чтобы их эскплуатация была простой и понятной — последние несколько месяцев мы ведём активную работу по документированию и настройке мониторинга:
- описали [зачем нужен мониторинг, из каких этапов он состоит](../../../concepts/dev/jobs-monitoring.md)
- сделали [инструкцию по настройке](../../../guide/dev/jobs-monitoring.md) Juggler-мониторинга в джобах
- придумали [шаблон документации по джобе](../../jobs/list/Template.md), описали по нему множество джоб _(список под катом)_
- сделали инструкцию [Как написать эксплуатационную документацию по джобе](../../../guide/dev/jobs-operation-doc.md)
- сделали страничку про [общие способы регулировки джоб](../../jobs/jobs-common.md)
- начали документировать перловые скрипты, пока только один — [ppcCampQueue](../../perl-scripts/list/ppcCampQueue.pl)

{% cut "задокументированные джобы" %}

- [AbDataPrepareJob](../../jobs/list/AbDataPrepareJob.md)
- [ActiveOrdersImportJob](../../jobs/list/ActiveOrdersImportJob.md)
- [AdImageBannerEventsProcessor](../../jobs/list/AdImageBannerEventsProcessor.md)
- [AgencyOfflineReportBuilder](../../jobs/list/AgencyOfflineReportBuilder.md)
- [AggregatedStatusesMonitorJob](../../jobs/list/AggregatedStatusesMonitorJob.md)
- [AuctionStatPrepareJob](../../jobs/list/AuctionStatPrepareJob.md)
- [AuctionStatUpdateJob](../../jobs/list/AuctionStatUpdateJob.md)
- [AutoOverdraftEmailSenderJob](../../jobs/list/AutoOverdraftEmailSenderJob.md)
- [AutooverdraftClietnsForTeaserJob](../../jobs/list/AutooverdraftClietnsForTeaserJob.md)
- [BalanceAggregateMigrationJob](../../jobs/list/BalanceAggregateMigrationJob.md)
- [BalanceInfoQueueCleaner](../../jobs/list/BalanceInfoQueueCleaner.md)
- [BannerButtonModerationEventsProcessor](../../jobs/list/BannerButtonModerationEventsProcessor.md)
- [BannerLogoModerationEventsProcessor](../../jobs/list/BannerLogoModerationEventsProcessor.md)
- [BannerstorageCreativesModerationEventsProcessor](../../jobs/list/BannerstorageCreativesModerationEventsProcessor.md)
- [BillingAggregatesExportJob](../../jobs/list/BillingAggregatesExportJob.md)
- [BillingOrderDomainsExporter](../../jobs/list/BillingOrderDomainsExporter.md)
- [BrandLiftConditionsCleanerJob](../../jobs/list/BrandLiftConditionsCleanerJob.md)
- [BrandLiftConditionsCollectorJob](../../jobs/list/BrandLiftConditionsCollectorJob.md)
- [BrandLiftConditionsDbQueueJob](../../jobs/list/BrandLiftConditionsDbQueueJob.md)
- [BrandLiftRecalcProcessor](../../jobs/list/BrandLiftRecalcProcessor.md)
- [BsExportAdGroupProcessor](../../jobs/list/BsExportAdGroupProcessor.md)
- [BsExportBannerResourcesProcessor](../../jobs/list/BsExportBannerResourcesProcessor.md)
- [BsExportBiddableShowConditionsProcessor](../../jobs/list/BsExportBiddableShowConditionsProcessor.md)
- [BsExportCampaignProcessor](../../jobs/list/BsExportCampaignProcessor.md)
- [BsExportFeedsProcessor](../../jobs/list/BsExportFeedsProcessor.md)
- [BsExportMobileContentJob](../../jobs/list/BsExportMobileContentJob.md)
- [BsExportMultipliersProcessor](../../jobs/list/BsExportMultipliersProcessor.md)
- [CampAggregatedLastchangeProcessor](../../jobs/list/CampAggregatedLastchangeProcessor.md)
- [CampQueueMonitoringJob](../../jobs/list/CampQueueMonitoringJob.md)
- [CampaignEventLogProcessor](../../jobs/list/CampaignEventLogProcessor.md)
- [CampaignStatusCorrectCheckProcessor](../../jobs/list/CampaignStatusCorrectCheckProcessor.md)
- [CanvasOperationsOnCreativesJob](../../jobs/list/CanvasOperationsOnCreativesJob.md)
- [CheckedSupportChatSyncJob](../../jobs/list/CheckedSupportChatSyncJob.md)
- [ClearOldLimitedSupportsJob](../../jobs/list/ClearOldLimitedSupportsJob.md)
- [ClientAvatarsDeleteJob](../../jobs/list/ClientAvatarsDeleteJob.md)
- [ClusterDomainExporter](../../jobs/list/ClusterDomainExporter.md)
- [ContentCategoriesOldTablesCleanerJob](../../jobs/list/ContentCategoriesOldTablesCleanerJob.md)
- [ContentCategoriesTolokaInputPrepareJob](../../jobs/list/ContentCategoriesTolokaInputPrepareJob.md)
- [ContentCategoriesTolokaOutputProcessJob](../../jobs/list/ContentCategoriesTolokaOutputProcessJob.md)
- [ContentCategoriesYacofastDataCollectorJob](../../jobs/list/ContentCategoriesYacofastDataCollectorJob.md)
- [ContentCategoriesYangInputPrepareJob](../../jobs/list/ContentCategoriesYangInputPrepareJob.md)
- [ContentPromotionAccessibilityEventsProcessor](../../jobs/list/ContentPromotionAccessibilityEventsProcessor.md)
- [ContentPromotionBannerModerationEventsProcessor](../../jobs/list/ContentPromotionBannerModerationEventsProcessor.md)
- [CpmAudioBannerModerationEventsProcessor](../../jobs/list/CpmAudioBannerModerationEventsProcessor.md)
- [CpmBannerModerationEventsProcessor](../../jobs/list/CpmBannerModerationEventsProcessor.md)
- [CpmVideoUpdateSegmentJob](../../jobs/list/CpmVideoUpdateSegmentJob.md)
- [DisplayHrefsModerationEventsProcessor](../../jobs/list/DisplayHrefsModerationEventsProcessor.md)
- [ExportAdvqHitsJob](../../jobs/list/ExportAdvqHitsJob.md)
- [ExportFreelancersProjectsToYtJob](../../jobs/list/ExportFreelancersProjectsToYtJob.md)
- [ExportTrustedRedirectsToYtJob](../../jobs/list/ExportTrustedRedirectsToYtJob.md)
- [FillClearedBannersLanguageJob](../../jobs/list/FillClearedBannersLanguageJob.md)
- [FreelancerBsRatingImportJob](../../jobs/list/FreelancerBsRatingImportJob.md)
- [FreelancerCardReceivingJob](../../jobs/list/FreelancerCardReceivingJob.md)
- [FreelancerCardSendingJob](../../jobs/list/FreelancerCardSendingJob.md)
- [FreelancerCertificatesUpdateJob](../../jobs/list/FreelancerCertificatesUpdateJob.md)
- [HomeDirectDbOperationsJob](../../jobs/list/HomeDirectDbOperationsJob.md)
- [ImageModerationEventsProcessor](../../jobs/list/ImageModerationEventsProcessor.md)
- [ImportCashbackRewardsDetailsJob](../../jobs/list/ImportCashbackRewardsDetailsJob.md)
- [ImportCryptaSegmentsJob](../../jobs/list/ImportCryptaSegmentsJob.md)
- [ImportSitelinksFromBnoJob](../../jobs/list/ImportSitelinksFromBnoJob.md)
- [ImportTargetTagsJob](../../jobs/list/ImportTargetTagsJob.md)
- [InternalBannerModerationEventsProcessor](../../jobs/list/InternalBannerModerationEventsProcessor.md)
- [InvalidYandexServicesDomainsMonitoringJob](../../jobs/list/InvalidYandexServicesDomainsMonitoringJob.md)
- [LastAvailableDateFetcher](../../jobs/list/LastAvailableDateFetcher.md)
- [MediascopePositionChangeProcessor](../../jobs/list/MediascopePositionChangeProcessor.md)
- [MediascopeSettingsRefresherJob](../../jobs/list/MediascopeSettingsRefresherJob.md)
- [MetrikaBannerUpdateProcessor](../../jobs/list/MetrikaBannerUpdateProcessor.md)
- [MoatBannersUploadJob](../../jobs/list/MoatBannersUploadJob.md)
- [MobileAppsSyncJob](../../jobs/list/MobileAppsSyncJob.md)
- [MonitorTargetsCleaner](../../jobs/list/MonitorTargetsCleaner.md)
- [OfflineAdvqKeywordsExportJob](../../jobs/list/OfflineAdvqKeywordsExportJob.md)
- [OfflineAdvqKeywordsImportJob](../../jobs/list/OfflineAdvqKeywordsImportJob.md)
- [OfflineAdvqProcessingJob](../../jobs/list/OfflineAdvqProcessingJob.md)
- [OfflineReportJob](../../jobs/list/OfflineReportJob.md)
- [ReceiveModerationErrorResponseJob](../../jobs/list/ReceiveModerationErrorResponseJob.md)
- [ReceiveModerationResponseJob](../../jobs/list/ReceiveModerationResponseJob.md)
- [ReceiveModerationUnparsedResponseJob](../../jobs/list/ReceiveModerationUnparsedResponseJob.md)
- [RecomTracerProcessor](../../jobs/list/RecomTracerProcessor.md)
- [RecommendationsApplyJob](../../jobs/list/RecommendationsApplyJob.md)
- RecommendationsMergeJob (удалено)
- [RedirectCheckJob](../../jobs/list/RedirectCheckJob.md)
- RemoveSpamFromModerationExportQueueJob (удалено 2022-06-29 из-за удаления старого транспорта модерации)
- [ResetCpmPriceCampaignFlightStatusApproveJob](../../jobs/list/ResetCpmPriceCampaignFlightStatusApproveJob.md)
- [SafeSearchTearOffPromocodesJob](../../jobs/list/SafeSearchTearOffPromocodesJob.md)
- [SendPushesJob](../../jobs/list/SendPushesJob.md)
- SendShopRatingJob _(удалена)_
- [SitelinksModerationEventsProcessor](../../jobs/list/SitelinksModerationEventsProcessor.md)
- [SspPlatformSynchronizerJob](../../jobs/list/SspPlatformSynchronizerJob.md)
- [StatRollbackEmailSenderJob](../../jobs/list/StatRollbackEmailSenderJob.md)
- [StoredVarsCleaner](../../jobs/list/StoredVarsCleaner.md)
- [SyncMarketFeedsJob](../../jobs/list/SyncMarketFeedsJob.md)
- [TakeoutUploadJob](../../jobs/list/TakeoutUploadJob.md)
- [TurbolandingsModerationEventsProcessor](../../jobs/list/TurbolandingsModerationEventsProcessor.md)
- [TurnOnAutopayJob](../../jobs/list/TurnOnAutopayJob.md)
- [UpdateBannersUnreachableUrlJob](../../jobs/list/UpdateBannersUnreachableUrlJob.md)
- [UpdateDayBudgetJob](../../jobs/list/UpdateDayBudgetJob.md)
- [UpdateFreelancerRatingsJob](../../jobs/list/UpdateFreelancerRatingsJob.md)
- [UpdateInternalMobileBannerRatingJob](../../jobs/list/UpdateInternalMobileBannerRatingJob.md)
- [UpdateMetrikaCounterGrantsJob](../../jobs/list/UpdateMetrikaCounterGrantsJob.md)
- [UpdatePagePlaceJob](../../jobs/list/UpdatePagePlaceJob.md)
- [UpdatePayForConversionPessimizedUsersJob](../../jobs/list/UpdatePayForConversionPessimizedUsersJob.md)
- [UpdatePlacesJob](../../jobs/list/UpdatePlacesJob.md)
- [UpdateStoreContentJob](../../jobs/list/UpdateStoreContentJob.md)
- [UpdateTemplatePlaceJob](../../jobs/list/UpdateTemplatePlaceJob.md)
- [UpdateTemplateResourceJob](../../jobs/list/UpdateTemplateResourceJob.md)
- [WalletsWarningsEmailSenderJob](../../jobs/list/WalletsWarningsEmailSenderJob.md)

{% endcut %}

[Напомню](https://clubs.at.yandex-team.ru/direct-dev/671), что ссылку на документацию конкретной джобы можно найти внутри ее juggler-мониторинга.


## Про автотесты
- добавили способ починки автотестов при [неподходящей версии Java](../../../guide/troubleshooting/autotests-does-not-working.md#bad-java-version)
- для автотестов DNA:
   - cделали инструкцию по [написанию storybook-тестов](../../../frontend/how-to-write-storybook-tests.md)
   - актуализировали [Функциональное тестирование DNA](../../../frontend/dna-functional-testing.md) — одностраничной версии на замену пришел целый ряд страниц:
      - [Понятия и определения](../../../frontend/tests-main-concepts.md)
      - [Тестовые сценарии](../../../frontend/tests-yml.md)
      - [Создание функциональных тестов](../../../frontend/tests-write.md)
      - [Команды для запуска тестов](../../../frontend/tests-run.md)
      - [Переменные окружения](../../../frontend/tests-env-variables.md)
      - [Как работают тесты "под капотом"](../../../frontend/tests-under-the-hood.md)
      - [Ответы на часто задаваемые вопросы](../../../frontend/tests-how-to.md)
   - старая страница переехала по оглавлению в раздел **Концепции** → **Тестирование** → **Функциональное&nbsp;Тестирование&nbsp;DNA** → **Предыдущая&nbsp;версия&nbsp;документации**

## Про релизы
- описали как и зачем [посмотреть лог сборки релиза DNA](../../../guide/releases/dna.md#release-log)
- более [строго описали, как поступать с задачами без QA](../../../guide/releases/dna.md#testing) в релизах DNA, убрали проверку заакцепченности релиза перед выкладкой
- вернули скачивание XLS в процесс [тестирования релизов LogViewer](../../../guide/releases/logviewer.md#testing)
- в [инструкции для canvas](../../../guide/releases/canvas.md) заменили автотесты на тестирование асессорами
- в инструкции по [выкладке релизов в Deploy](../../../jeri/guide/deploy.md) добавили нулевой шаг "напиши в Direct Admin Chat".
- на страничку про [выкладку релизов репликатора](../../../guide/jeri/deploy-b2yt.md#links) добавили ссылку на вики о выкладке релизов зеркализатора.
- добавили ссылок на первоисточник [расписания выкладки релизов](../../../concepts/releases/deploy-schedule.md)
- для [perl-релизов добавили в инструкцию](../../../guide/releases/perl.md#perl_slide) команды для slide: до фиксированной ревизии или свежего транка _(на самом деле похожие команды работают и в других приложениях)_
- сделали страчнику про то [как устроенна регрессия в релизах perl](../../qa/regression-perl.md)

## Алерты
- начали описывать [диагностику про экспорт в БК](../../bs-export-diag.md)
- перенесли из вики и актуализировали алерты про прием нотификаций от баланса: на [200ки](../../alerts/balance-notify-order-2xx.md) и [500ки](../../alerts/balance-notify-order-2xx.md)
- завели и описали [ErrorBooster trending errors](../../alerts/trending-errors.md) для разных бекендов
- задокументировали алерт на возраст очереди (документация удалена 2022-06-28 вместе с удалением алертов старого транспорта) и [работу мастер-процесса](../../alerts/scripts-moderate-export-master-working.md) экспорта в модерацию
- описали disaster провекри для [ppcdata](../../alerts/ppcdata_availability.md) и [ppcdict](../../alerts/ppcdict_availability.md)
- описали алерт на [отправку в Соломон метрик транспорта в модерацию](../../alerts/send-ess-moderation-metrics.md)
- задокументировали фронтовые алерты:
   - на [время отдачи опубликованных страниц Турбо-конструктора](../../alerts/lc-turbo-json-response-time.md)
   - [lpc-direct-api-submissions-send-errors-count](../../alerts/lpc-direct-api-submissions-send-errors-count.md)
   - [ошибки в ErrorBooster](../../alerts/frontend-errors.md)
   - на [замедление рендеринга страниц](../../alerts/frontend-timings-all-first-timings.md)
- в описании [downtime-db.\*](../../alerts/downtime-db.md): написали как посмотреть событие в infra и что делать, если учения отменили
- сделали [тренировочный звонящий алерт](../../../jeri/guide/test-juggler-check.md)
- описали [как для алертов ErrorBooster делать понятный сервис/хост](../../../jeri/guide/solo-name-error-booster-alerts.md)

## Аварии
- на страничке про [оценку потерь](../../../incidents/assessment/how-to.md):
   - записали (по результатам обсуждений) вес функциональности для отставаний транспорта с модерацией
   - и то, каким способ его пересчитали в приведенное значение
   - актуализирована YQLка со списком всех наших веб контроллеров
- на страничке про [оформление SPI](../../../incidents/spi-ticket.md):
   - убрали User-Action-Log: Writer из [списка подсистем](../../../incidents/spi-ticket.md#service)
   - в примерах [среднего влияния на клиентов](../../../incidents/spi-ticket.md#impact-clients) добавили "превью объявлений", уменьшили допустимую задержку на модерации
   - зафиксировали, что тег `base_markup_required` теперь требует ещё заполнения _Хронологии_, _Что видели пользователи_ и _Описания_
- на страую страничку добавили компоненту `@chats` для аварий с чатами
- на страничке [об устройстве дашборда про инциденты](../../../incidents/dashboard-data-source.md) — добавили как запросить права на робота, из под которого всё работает
- поставили ссылку на [тестинг дашборда про аварии](https://datalens.yandex-team.ru/8jwlu1mfvc3s2-direkt-incidenty-dev) на [страницу с дашбордами](../../dashboards.md#incidents)

Не про документацию, но в тему: мы закрыли очередь [DIRECTINCIDENTS](https://st.yandex-team.ru/DIRECTINCIDENTS) на заведение новых тикетов.

## Новое справочное
- чатики:
   - [solo](../../chats.md#solo)
   - [LSR рекламных технологий](../../chats.md#adv-lsr)
   - [\[Директ\] Аналитика](../../chats.md#direct-analytics)
   - канал со [всеми SPI рекламы](../../chats.md#adv-spi)
   - [дежурная смена](../../chats.md#marty)
   - уведомления об [авариях Баланса](../../chats.md#balance-incidents)
   - [Факапочная Траста](../../chats.md#trust-incidents)
   - обновили инвайт-ссылку на [БК-Директ-Метрика-Модерация всё ли хорошо?](../../chats.md#adv-services)
- определения в глоссарии:
   - [solo](../../../glossary/glossary.md#solo)
   - [ErrorBooster](../../../glossary/glossary.md#error-booster)
- "штуки":
   - [{#T}](../../../jeri/things/megadash.md)
   - [{#T}](../../../jeri/things/mmm.md)
   - [{#T}](../../../jeri/things/pt-kill.md)
- завели страничку с ["реестром" выгрузок Директа в YT](../../exports/list.md)
- записали в [_знающих_ про агрегированныые статусы](../../who-knows.md#aggregated-statuses) [Сережу](https://staff.yandex-team.ru/gukserg)
- новые дежурства: [UAC (РМП)](../../duty.md#uac), [Турбо-Конструктор](../../duty.md#turbo-constructor).

## Другие обновления { #updates }

В руководстве по [написанию кода ваншотов](../../..//oneshot/howto-code.md) добавили, что можно расширять один из подходящих базовых классов.

Подвинули страничку [{#T}](../../../dev/techtalk.md) из корня раздела **Справочник** в подраздел **Процессы**.

Завели инструкцию по [добавлению секретов в стейджы Deploy](../../../jeri/guide/yadeploy-add-secrets.md)

Переработали документацию по фичам в коде:
   - описали [Жизненный цикл фичи](../../../features/concept.md) и их сопровождение
   - перенесли (меняйте ссылки в закладках!) и переработали [инструкцию по заведению фич](../../../features/howto-code.md)
   - уточнили в ней ссылки
   - добавили раздел про удаление фичи

[{#T}](../../sources-to-read.md) — добавили чатики direct-dev-talks и рекламные об авариях, встречи Tech-Talk.

В копилке аналитических запросов — для [доли активных клиентов по шардам](../../..//guide/analytics/queries/share-of-active-clients-by-shard.md) добавили расчет по активности не только в веб, но и API.

В инструкцию по [сборке пакетов](../../../guide/dev/how-to-package.md) добавлен пример сборки пакетов в Sandbox с наложением патча из ревью.

Перенесли из вики [инструкцию по настройке executer](../../../jeri/guide/executer.md).

Добавили тикет для фидбека на [arc-беты](../../../dev/betas/betas.md).


## Для комментариев
Коммментарии к дайджесту можно оставить [у поста в этушке](https://clubs.at.yandex-team.ru/direct-dev/683).
