# Дайджест документации #19

## Про автотесты
- написали инструкцию по [Созданию модульных юнит-тестов DNA](../../../frontend/react-testing-library-tests.md)
- добавили еще пример из логов падения при [неподходящей версии Java](../../../guide/troubleshooting/autotests-does-not-working.md#bad-java-version)
- в инструкцию про [написание storybook-тестов](../../../frontend/how-to-write-storybook-tests.md):
   - добавили ссылку на [чат](../../chats.md#storybook-support) поддержки
   - написали что [нужно для переиспользования фикстуры](../../../frontend/how-to-write-storybook-tests.md#reuse-fixture)
   - подробно описали команды для [запуска storybook отдельно](../../../frontend/how-to-write-storybook-tests.md#standalone-storybook-run)
   - добавили [генерацию шаблона новой тестовой story](../../../frontend/how-to-write-storybook-tests.md#boilerplate-for-new-story)
   - а также поправили опечатки и уточнили детали
- в FAQ по тестам DNA добавили [мигающие тесты](../../../frontend/tests-how-to#flaky-test)
- в инструкцию по обновлению [тестовых дампов в DNA](../../../frontend/how-to-refresh-dumps.md#macos-troubles) добавили возможное решение проблемы на MacOS

## Про релизы
- [DNA](../../../guide/releases/dna.md):
   - в действиях [перед сборкой](../../../guide/releases/dna.md#until-release) зафиксировали, что сборка автоматизирована
   - в информции про [выкладку в нестандартное время](../../../guide/releases/dna.md#after-testing) добавили, что такие просьбы нужно сопровождать объяснением и ссылками на задачи
   - в разделе о [тестировании](../../../guide/releases/dna.md#testing):
      - указание о запуске асессоров на регреессию (что бы это ни значило)
      - указали на какого дежурного назначать непонятные баги
   - добавили раздел про [отчеты Molly](../../../guide/releases/dna.md#molly)
- заменили дежурство _регрессия perl-backend'а_ новым _Релизы + ТС_ в инструкциях для [java-web](../../../guide/releases/java-web.md) и [perl](../../../guide/releases/perl.md)
- отметили в инструкциях **ко всем релизам**, что хотфиксы новых задач в RC (тестируемые релизы) нужно обосновывать у [collapsus@](https://staff.yandex-team.ru/collapsus)
- к [перловым релизам](../../../guide/releases/perl.md):
   - добавили пометку о выполнении всех действий из-под screen
   - [рассказали](../../../guide/releases/perl.md#perl_end_ok) как себе подключить шаблон комментария о завершении тестирования
   - добавили команду, позволяющую продолжить сборку хотфикса при падении
   - признали часть шагов [устаревшими](../../../guide/releases/perl.md#perl_deprecated)
   - упомянули работу с тикетом на _ревью непродуктовых коммитов_
- из инструкции по [java-web](../../../guide/releases/java-web.md) убрали ручное обновление стабильных стендов devtest и dev7
- завели страничку о том, [что входит в новое дежурство Релизы + ТС](../../../duty/direct-releases-duty.md)

## Алерты
- документированы алерты в рамках проекта **Мониторинг неудачных реализаций** на:
   - [время выполнения запросов](../../alerts/lifeline/trace-log-time-spent-monitoring.md)
   - [непокрытое трейсингом время](../../alerts/lifeline/trace-log-time-spent-rest-monitoring.md)
   - [потребление памяти](../../alerts/lifeline/trace-log-memory-monitoring.md)
   - [потребление CPU](../../alerts/lifeline/trace-log-cpu-monitoring.md)
   - [количество читающих запросов к базе](../../alerts/lifeline/trace-log-calls-read-monitoring.md)
   - [количество пишущих запросов к базе](../../alerts/lifeline/trace-log-calls-write-monitoring.md)
   - [наличие многошардовых запросов в базу](../../alerts/lifeline/trace-log-multi-shard-monitoring.md)
   - [наличие realtime запросов в YT—кластреа Hahn/Arnold](../../alerts/lifeline/trace-log-hahn-arnold-monitoring.md)
   - [наличие неожиданных запросов во внешние сервисы](../../alerts/lifeline/trace-log-external-services-monitoring.md)
- обновили доку к алерту по экспорту на модерацию (документация удалена 2022-06-28 вместе с удалением алертов старого транспорта):
   - поправили название (алерт переименовался в `moderate_export_delay`) и описание
   - добавили еще ссылок на логи в диагностику
   - описали сценарии застревания конкретных кампаний, способ определения таких кампании
   - упомянули как управлять автоматической пессимизацией клиентов
   - отметили, что перераспределение воркеров теперь автоматическое
   - добавили YQL-запросы для просмотра состояни очереди
   - добавили ссылку на код, генерирующий алерты
   - описали кейс зависания на необслуживаемом воркере
- сделали алерт про [ошибки запросов для генерации данных в UC](../../alerts/generation-api-errors.md)
- в алертах о доступности [ppcdict](../..//alerts/ppcdict_availability.md) и [ppcdata](../../alerts/ppcdata_availability.md):
   - упомянули новую проверку режима репликации
   - актуализировали полезные ссылки, имена проверок
- сделали алерт о том, что [мастера БД не находятся в финке](../../alerts/geo-position-master.md)
- завели алерт на [ошибки запросов в метрику](../../alerts/metrika-requests-server-errors.md)

## Аварии
- удалили старую страничку про оформление аварий (в очереди DIRECTINCIDENTS)
- на страничке про [оформление SPI](../../../incidents/spi-ticket.md):
   - убрали комментарии про "компоненты" (со време двух инструкций), явно прописали все используемые теги
   - указали теги, которыми размечаем при [проверке разметки](../../../incidents/spi-ticket.md#direct-incident-review)

## Новое справочное
- чатики:
   - [Storybook Test Support](../../chats.md#storybook-support)
   - удалили _цветные инцидентые_ чаты
   - удалили _кворум по инцидентам_ (переехал в Slack)
   - добавили slack-канал [рабочей группы по инцидентам](../../chats.md#direct-incidents)
- определения в глоссарии:
   - [фишки](../../../glossary/glossary.md#chips)
   - [проперти](../../../glossary/glossary.md#pc-property)
   - [банана](../../../glossary/glossary.md#internal-ads)
   - [LogViewer](../../../glossary/glossary.md#logviewer)
- добавили информации про код/логи/сборку [Wordstat](../../../jeri/reference/other-services.md#wordstat)
- улучшили [шаблон описания](../../exports/list.md) в нашем реестре YT-выгрузок
- завели [{#T}](../../qa/testing-regulations.md)
- описали суть [дежурства по DIRECTSUP](../../../duty/support-duty.md)
- завели раздел о тестировании асессорами:
    - [создание Crowdtest стендов для асессоров](../../assessors/how-to-create-crowdtest-stand.md)
    - как [авторизоваться на стенде crowdtest](../../assessors/crowdtest-authorization.md)
    - как [тестировать релизы canvas](../../assessors/canvas-asessors.md)
    - [регрессия Директа асессорами](../../assessors/regression-assessors.md)
    - [тестирование резолвов в релизах Директа](../../assessors/resolve-assessors.md)
    - как [обрабатывать баги асессоров](../../assessors/assessors-bugs-resolution.md)
- записали [дежурных Метрики](../../duty.md#metrika)
- задокументировали LogViewer:
   - [что такое и как попробовать](../../logviewer/quick-start.md)
   - снабдили [доступные логи](../../logviewer/tables-description.md) коротким описанием
   - задокументировали [язык выражений фильтров](../../logviewer/filter-query-language.md)
   - описали [возможности интерфейса](../../logviewer/utilities.md)
- документация на джобы:
   - [ApproveCpmPriceCampaignFlightStatusApproveJob](../../jobs/list/ApproveCpmPriceCampaignFlightStatusApproveJob.md) — подтверждение бронирований трафика для прайсовых кампаний
   - ModerateExportCampaignsUnlockJob (удалено 2022-06-29 из-за удаления старого транспорта модерации) — разблокировка кампаний подвисших из-за миганий
   - ModerateExportMonitor (удалено 2022-06-29 из-за удаления старого транспорта модерации) — поставка в Solomon данных для мониторинга экспорта на модерацию
   - ModerateWorkerBalancer (удалено 2022-06-29 из-за удаления старого транспорта модерации) — перераспределение воркеров экспорта в модерацию между шардами в зависимости от нагрузки
   - ReplicateModExportQueueToYdbJob (удалено 2022-06-29 из-за удаления старого транспорта модерации) — синхронизирует табличку `mod_export_queue` из MySQL в YDB для нужд мониторинга
   - [UserBlockProcessor](../../jobs/list/UserBlockProcessor.md) — остановка кампаний заблокированных пользователей

## Другие обновления { #updates }
- в инструкции по [выкладке релизов в Deploy](../../../jeri/guide/deploy.md):
   - добавили ссылку на deploy tickets java-intapi
   - описали более подробно процедуру отката на предыдущую версию
- добавили на страничку про беты [где искать логи](../../../dev/betas/betas.md#logs)
- обновили ссылки на дежурных app-duty на страницах про [дежурство](../../../duty/app-duty.md) и его [расписание](../../..//jeri/app-duty-schedule.md)
- про агррегированные статусы:
   - на страничку об [эксплуатациии](../../../aggr-statuses/jeri.md#monitoring) добавили идеи по диагностике торможений
   - в страничку пор [диагностику значения](../../../aggr-statuses/howto-diagnose-status.md) записали: исходный json можно посмотреть прямо в интерфейсе по особой фиче
- при [подготовке к недоступности ДЦ](../../../jeri/howto-minus-dc.md#paperwork):
   - просим фиксировать в тикете явно, кто из дежурных отвечает за прод, а кто за ТС
   - подсказываем переключить кластер чтения статистики, если работы во VLA
- из инструкции по [переключению MySQL](../../../jeri/guide/mysql-switch-master.md) удалили особые указания для ppcdict (он больше не xtradb), пометили что базы бывают в MDB
- на страничке про [ачивки за докуменатацию](../achievements.md) — отразили "стаус-кво": уровень ачвики отражает активность между дайджестами, без привязки к календарю
- про [фичи](../../../features/howto-code.md):
   - дали совет по именованию новых фичей
   - добавили оговорку про удаление фичей со своей беты
- актуализировали ответственных за [данные в YT](../../../guide/analytics/abc-direct-analytics.md) и [секрет доступа к ppchouse](../../../guide/analytics/setup-yql.md)
- про копирование кампаний:
   - в доку джобы [CampQueueMonitoringJob](../../jobs/list/CampQueueMonitoringJob.md) поставили ссылку на доку скрипта, который она мониторит
   - в [доку самого скрипта](../../perl-scripts/list/ppcCampQueue.pl.md) поставили ссылку на тикет—исследование работы дополнительных воркеров
   - там же отметили, что базовые воркеры не могут быть переназначены в другие шардывс
- поправили ссылку на первоисточник в документации к [утилите dctl](../../../jeri/howto-dctl.md)


## Для комментариев
Коммментарии к дайджесту можно оставить [у поста в этушке](https://clubs.at.yandex-team.ru/direct-dev/709).
