## Ручка создания клиента addOrGetClient

# Где живёт, пример запроса
Адрес ручки `$intapi_url/clients/addOrGet`

{% cut "Пример для тестовой среды" %}

```
curl -X POST --header 'Content-Type: application/json' --header 'Accept: application/json' --header 'X-Ya-Service-Ticket: **********' -d '{
"login": "user_login",
"fio": "Ivan Ivanov",
"country": 225,
"currency": "RUB",
"with_api": true
}' 'https://intapi.test.direct.yandex.ru:9443/clients/addOrGet'
```

{% endcut %}

Про X-Ya-Service-Ticket
[TVM-тикеты в Директе](https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal/tvm/src/main/java/ru/yandex/direct/tvm/TvmService.java )

Продовый url `intapi_url=http://ipv6.intapi.direct.yandex.ru/`

{% cut "Пример ответа на успешный запрос" %}

```
{
  "client_id": 111111111,
  "user_id": 123456789,
  "finance_token": "tokentoken",
  "success": true
}
```
{% endcut %}

{% cut "Пример ответа на неуспешный запрос" %}

Ниже ответ на запрос с неправильной валютой для клиента в Балансе 
[См. заведение в директе клиента, который уже есть в Балансе](#поддерживаемые-сценарии)
Для других текст ошибки может отличаться
```
{
  "code": 1000,
  "text": "DefectInfo{path=, value=at-direct-test-addclient6, defect=Defect{defectId=INVALID_VALUE, params=null}}",
  "description": null,
  "success": false
}
```

{% endcut %}

# Что принимает и отдаёт
**login** - паспортный логин клиента. Можно вместо него uid передать клиента с непустым логином 
[См. клиент с внешней с авторизацией](#поддерживаемые-сценарии)
**uid** - uid, игнорируется, если передан логин
**fio** - фио, валидируется, что непустое
**country** - идентфикатор региона страны клиента
**currency** - идентификатор валюты, допустимо одно из значений **RUB, UAH, USD, EUR, KZT, CHF, TRY, BYN**
**with_api** - подключать ли клиенту API директа (заодно принимается офферта), значения true/false. **При непереданном параметре создаём с подключенным API.** При with_api=false финансовый токен не возвращается (возвращается null)

# Поддерживаемые сценарии
В настоящий момент поддержаны сценарии 
1. нового самоходного (не под агентством/менеджером/фрилансером) клиента. В ручку передаётся логин/uid, фио,валюта и страна, с которыми хотим завести. Клиенту нужно сначала завести кампанию перед тем, как пополнять общий счёт
2. получения финансового токена и проставления необходимых полей в базе для существующего клиента. Вернёт токен, проставит необходимые флаги для использования клиентом апи. Использование апи подразумевает, что клиент принимает оферту, поэтому перед походом надо вывести клиенту оферту апишную и/или [директовую](#оферта) в каком-либо виде. При этом фио, а также связка валюты и страны не валидируются с существующими (остаются существующие фио, страна, валюта)
3. заведение в директе клиента, который уже есть в Балансе, с одной из комбинаций страны и валюты, в нём используемых. Если комбинации валюты-страны нет в Балансе, будет ошибка. Насчёт оферты тоже актуально
 
Для клиента с внешней авторизацией (через аккаунт в другом сервисе) без логина(или пустым) ручка выдаст ошибку. В директе у каждого клиента должен быть уникальный логин

# Оферта
(ручка checkClientState)

В директе клиент принимает оферту при регистрации и при заведении api. В зависимости от его текущего статуса нужно показать одну или две этих оферты. Чтобы узнать текущий статус, нужно сходить в ручку checkClientState, живёт по `$intapi_url/clients/checkClientState`

{% cut "Пример для тестовой среды" %}
```
curl -X POST --header 'Content-Type: application/json' --header 'Accept: application/json' --header 'X-Ya-Service-Ticket: **********' -d '{
"login": "user_login",
}' 'https://intapi.test.direct.yandex.ru:9443/clients/checkClientState'
```
{% endcut %}

{% cut "Пример ответа на запрос" %}
```
{
  "client_state": "API_ENABLED",
  "client_role": "CLIENT",
  "has_shared_wallet": false,
  "success": true
}
```
{% endcut %}

====Принимает:====

**login** - паспортный логин клиента. Можно вместо него передать uid клиента

**uid** - uid, игнорируется, если передан логин

====Возвращаемый client_state:====

**NOT_EXISTS** - Клиент отсутствует в директе

**CAN_NOT_BE_CREATED** - Клиент отсутствует в Директе и его нельзя добавить

**API_DISABLED** - Клиент присутствует в директе, но ему не подключено API

**API_ENABLED** - Клиент присутствует в директе, и ему подключено API

**API_BLOCKED** -Клиент присутствует в директе, и ему заблокирован доступ к API (не может пользоваться API)

**BLOCKED** -Клиент заблокирован в интерфейсе директа (не может пользоваться API в том числе)

====Возвращаемая роль client_role:====

//! Поле client_role отсутствует в случае, если вернулся client_state NOT_EXISTS//

**CLIENT** - Обычный клиент

**AGENCY** - Агентство (не клиент Директа)

**AGENCY_SUBCLIENT** - Субклиент агенства с возможностью редактировать рекламные материалы

**AGENCY_READ_ONLY_SUBCLIENT** - Субклиент агенства без возможности редактировать рекламные материалы

**OTHER** - Другие внутренние роли

====Имеется ли общий счёт has_shared_wallet====

//! Поле has_shared_wallet отсутствует в случае, если вернулся client_state NOT_EXISTS//

**true** - Имеется общий счёт

**false** - Общий счёт не заведён

====Причина, по которой клиент не может быть создан can_not_be_created_reason====

//! Поле can_not_be_created_reason присутствует только в случае, если вернулся client_state NOT_EXISTS//

Содержит строку с кодом ошибки, например, LOGIN_CANNOT_BE_PDD.

