## CheckPincodeAccessFallbackModeJob

### Продукт/подсистема

CRM, выдача пинкодных доступов саппортов Директа к клиентам.

### Роль в работе продукта/подсистемы

По умолчанию саппорты с ограниченным доступом получают доступ к клиенту по пинкодной схеме. В случае проблем с таким
доступом, CRM включает fallback-режим, дающий саппортам доступ ко всем клиентам. Джоба регулярно проверяет, включен ли
данный режим, и если включен, сигнализирует об этом как о критической ошибке.

### Датафлоу

- Выполняется каждые 10 минут
- Зажигает CRIT, если включен fallback-режим; включенность определяется по
  проперти ```enable_limited_support_read_all_clients```
- Вместе с CRIT-ом отправляет описание контекста включения fallback-режима из
  проперти ```enable_limited_support_read_all_clients_meta```

### Способы наблюдения за текущим состоянием

- [Juggler-проверка](https://juggler.yandex-team.ru/check_details/?host=checks_auto.direct.yandex.ru&service=jobs.CheckPincodeAccessFallbackModeJob.working.production)
- [Логи](https://direct.yandex.ru/logviewer/#~(logType~'messages~form~(fields~(~'log_time~'host~'service~'method~'trace_id~'span_id~'prefix~'log_level~'class_name~'message)~conditions~(service~'direct.jobs~method~'crm.CheckPincodeAccessFallbackModeJob)~limit~100~offset~0~reverseOrder~false~showTraceIdRelated~false))$)

### Какая функциональность пострадает от отказа джобы

Если джоба зажгла CRIT, значит, включился fallback-режим. Это нестабильное состояние системы. В этом случае нужно
определить, кто включил fallback, связаться с ним и уточнить информацию о причинах включения и ожидаемых сроках
выключения. <br>
Если зажглась NO_DATA_FORCE_CRIT, значит, джоба сломалась, нужно смотреть логи.
Информацию по fallback-у в таком случае можно найти в упомянутых пропертях.

### Как пользователи (или команда) заметят проблему и через какое время

Fallback-режим дает доступ саппортам ко всем клиентам, это нештатная ситуация.
Возможен несанкционированный доступ к данным клиентов Директа.

### Контакты разработчиков и менеджеров

Разработчики: [Никита Ермаков](https://staff.yandex-team.ru/kit-rex),
[Максим Логунов](https://staff.yandex-team.ru/kit-rex) <br>
Менеджеры: [Ксения Аникеева](https://staff.yandex-team.ru/anyksenya)

### Желательное время исправления в случае поломки

Ожидаемое время починки - 1-2 часа.
Если fallback-режим остается включенным дольше,
стоит подключить к решению проблемы дежурного по продукту: https://abc.yandex-team.ru/services/direct/duty/?role=3739.
Он поможет решить, оставлять fallback включенным или отключать и отнимать доступ к клиентам у саппортов.

### Способы регулирования работы джобы

Выключить fallback можно через CRM (предпочтительный вариант)
или через проперти ```enable_limited_support_read_all_clients``` (резервный вариант)

### Известные причины поломок

Если горит CRIT, значит, включился fallback, см. выше.

### Дополнительно: тонкости и подводные камни
