## DeleteUnusedAssetsFromMDSJob


### Продукт/подсистема

Удаление ассетов, которые за установленное время так и не были связаны ни с одной кампанией. Ассеты загружаются клиентами или посредством работы саджеста при создании/редактировании кампании, если кампания или изменения в ней впоследствии так и не будут сохранены, ассеты зависают в неиспользованном состоянии, но продолжают храниться в аватарнице.
Позоволяет эффективнее расходовать квоту в аватарнице.


### Датафлоу

Обработка ведется чанками, для каждого чанка выполняется следующий флоу:

- Из проперти считываются ограничивающие значения (минимальное время создания delete_uac_asset_min_lookup_time, время жизни несвязанного ассета delete_uac_asset_current_date_offset, лимиты итераций delete_uac_asset_iteration_limit и удалений delete_uac_asset_total_delete_limit)

- Из таблицы asset в GrUT отбираются ассеты, созданные не ранее указанного в delete_uac_asset_min_lookup_time времени и не позднее delete_uac_asset_current_date_offset дней назад

- По таблице campaign из полученных ассетов отбираются те, что не связаны ни с одной кампанией

- Неиспользуемые ассеты удаляются из аватарницы и таблицы asset

- Выдерживается время бездействия delete_uac_asset_idle_time

Процесс повторяется пока не будет превышен лимит итераций(delete_uac_asset_iteration_limit) или удалений(delete_uac_asset_total_delete_limit), либо не будет достигнута временная метка, в которых ассеты еще не рассматриваются как неиспользуемые.


### Способы наблюдения за текущим состоянием

- [Логи](https://direct.yandex.ru/logviewer/short/6cDR5X6P55impH)
- [График MDS space usage для avatars-uac](https://yasm.yandex-team.ru/template/panel/mds-ns-space/ns=avatars-uac?range=21600000)
- [График MDS space usage для avatars-uac-test](https://yasm.yandex-team.ru/template/panel/mds-ns-space/ns=avatars-uac-test?range=21600000)
- [Juggler-alert, следящий за свободным место в avatars-uac, value измеряется в Тб](https://juggler.yandex-team.ru/project/yasm.ambry.simple/aggregate?host=uac-production&service=mds_storage_uac_namespace_free_space_alert&project=yasm.ambry.simple)


### Какая функциональность пострадает от отказа джобы

Может возникнуть ситуация, что невозможно будет добавить новые ассеты и как следствие невозможно будет добавить новые кампании и отредактировать существующие


### Как пользователи (или команда) заметят проблему и через какое время

В нормальном состоянии при current_timestamp - delete_uac_asset_min_lookup_time -> delete_uac_asset_current_date_offset график расхода свободного места в аватарнице стремится к виду линейной убывающей функции, а график количества ключей - к линейной возрастающей.
Если нормальная работа джобы нарушена (или резко изменился объем потребления памяти в тестовой/продовой среде) сработает Juggler-alert mds_storage_uac_namespace_free_space_alert(см. выше), когда свободное место снизится до пороговых значений, соответствующая картина будет отображаться на графиках мониторинга MDS space usage
(резко уменьшится количество удаляемых в сутки ключей, а расход места наоборот должен начать расти, на графике должны появиться скачкообразные/ступенчатые изменения)


### Контакты разработчиков и менеджеров

Разработчики: [Аршиева Карина](https://staff.yandex-team.ru/arevolution), [Павел Катайкин](https://staff.yandex-team.ru/pavelkataykin) <br/>
Менеджеры: [Вадим Костомаров](https://staff.yandex-team.ru/nevadimka)


### Желательное время исправления в случае поломки

В течение недели. Проблемы могут возникнуть в случае сильного снижения свободного места в аватарнице (контроль осуществляет Juggler-alert), в критических случаях может потребовать увеличения квоты в аватарнице


### Способы регулирования работы джобы

В случае возникновения проблемы с работой джобы в первую очередь следует оценить объем свободной памяти, оставшееся в аватарнице, при необходимости увеличить квоту.
Если резкое уменьшение места вызвано увеличением нагрузки(прирост ключей в сутки резко вырос), требуется увеличить пропускную способность джобы отрегулировав проперти, указанные ниже.

PpcProperty delete_uac_asset_current_date_offset - время жизни несвязанного ассета в днях, в течении которого он не рассматривается как неиспользуемый, по умолчанию 7 дней;

PpcProperty delete_uac_asset_idle_time - время бездействия между каждой итерацией поиска-удаления в миллисекундах, по умолчанию 1000 ms;

PpcProperty delete_uac_asset_iteration_limit - общее число итераций, которое может быть выполнено за один запуск;

PpcProperty delete_uac_asset_min_lookup_time - минимальное время создания ассета, который может быть удален, если значение не установлено ограничение применятся не будет, ручное редактирование допускается только в случае, если в периоде меньшем, чем значение этой проперти, содержится большое число неиспользуемых ассетов;

PpcProperty delete_uac_asset_total_delete_limit - максимально возможное число удалений за один запуск, если значение не установлено ограничение применятся не будет.

### Известные причины поломок

Не зафиксированы.
